<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=user/');


// SETUP TAGS
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['network']);
$tag->user_id = $me['user_id'];


if (isset($_POST['update_tag'])) {
	$tag->deleteTags($frmdata);
	$tag->insertTags($frmdata);
}	
else
//block or unblock user
if (isset($_REQUEST['block'])) {
    $display = "block";
}
elseif (isset($_REQUEST['unblock'])) {
	$sn->user_id = $me['user_id'];
    $user_blocked = $sn->unSetBlockUser($user_id, 'unblock');
}
elseif (isset($_POST['set_block'])) {
    $sn->user_id = $me['user_id'];
	$user_blocked = $sn->setBlockUser($user_id, $data['block_description']);
	//rebuild social network
	$_SESSION['s_social_network'] = $sn->createNetwork();
	$sn->updateSnStatistics();
	

	//refresh this page to show new status
	header("Location: sn_profile.php?user_id=" . $_POST['user_id']."&".SID);
	exit;
}
else {
	if ($sn->getBlockStatus($user_id)) {
		$display = "blocked";
	}
}


$output_profile['profile_summary'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');



//get the relationships
$output_relationship_paths = $sn->getDegreePaths($user_id);

if (!empty($output_relationship_paths)) {
	foreach($output_relationship_paths as $key => $r):
		foreach($r['relation'] as $key => $i):
			$user->user_ids[] = $i;
		endforeach;
	endforeach;
}
$output_relationship_profiles = $user->getProfiles();


//get tags
$tag->item_id = $output_profile['user_id'];
$output_my_tags = $tag->selTags();


// get groups
require_once($c_node['dir']['class_path'] . 'Group.class.php');
$group = new Group($db, $date, null);
$group->user_id = $output_profile['user_id'];
$group->registration_types = $c_node['group']['registration_type'];
$output_groups = $group->getMyGroups();



//move to template
if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship_paths)) {
	$body->set('relationship_paths', $output_relationship_paths);
}

if (!empty($output_relationship_profiles)) {
	$body->set('relationship_profiles', $output_relationship_profiles);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

if (!empty($user_blocked)) {
	$body->set('user_blocked', $user_blocked);
}

if (!empty($degree_path['degree'])) {
	$body->set('degree_id', $degree_path['degree']);
}



if (!empty($display)) {
	$body->set('display', $display);
}

$template_pageLink =  $lang['txt_profile'];
$template_pageLinkNote = $lang['txt_profile'] . ": " . $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
