<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include_once "inc/header.inc.php";
$menu_section = "group"; //sets menu in default template


//append language setup
require_once($languageArrayPath . 'arr_group.lang.php');

//check received vars
if (!isset($group_id)) {
	if (isset($_REQUEST['group_id'])) {
		$group_id = $_REQUEST['group_id'];
	}
	elseif ($page_name[0] != "grp_list" && $page_name[0] != "grp_create") {
		header("Location: grp_list.php?" . strip_tags(SID));
		exit;
	}
}

// PROCESS FORM ----------------------------------------------------------
if (isset($frmdata['options']) && $frmdata['options'] != $page_name[0]) {
	if ($frmdata['options'] == "grp_view") {
		header("Location: grp_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_blog") {
		header("Location: blg_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_forum") {
		header("Location: frm_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_poll") {
		header("Location: pol_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_file") {
		header("Location: fil_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_library") {
		header("Location: lib_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_schedule") {
		header("Location: sch_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_channel") {
		header("Location: chl_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_structure") {
		header("Location: grp_structure.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_directory") {
		header("Location: grp_directory.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_membership") {
		header("Location: grp_membership.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "grp_newsletter") {
		header("Location: nlt_view.php?group_id=". $group_id . "&" . strip_tags(SID));
		exit;
	}
}

//get group details
require_once('class/Group.class.php');
$group = new Group($db, $file);
$group->registration_types = $c_node['group']['registration_type'];
if (isset($me['user_id'])) {
	$group->user_id = $me['user_id'];
}

if (isset($group_id)) {
	$group->file->group_id = $group_id;
	$group->group_id = $group_id;
	$output_group = $group->getGroup();
	
	if (empty($output_group['group_id'])) {
		header("Location: grp_list.php?" . strip_tags(SID));
		exit;
	}
	
	
	//is the group status active
	if ($output_group['status_id'] != $c_node['group']['status']['active']) {
		header("Location: grp_list.php?" . strip_tags(SID));
		exit;
	}
	
	//setup acs
	$group_acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
	$group_acs->group_id = $group_id;
	
	if (isset($me['user_id'])) {
		$output_group['member'] = $group->getGroupMembership();
	}
	
	if (!isset($output_group['member']['status_id']) || isset($output_group['member']['status_id']) && $output_group['member']['status_id'] != $c_node['group']['member_status']['active']) {
		if ($output_group['group_visibility'] != 1) { // group is hidden
			header("Location: grp_list.php?" . strip_tags(SID));
			exit;
		}
		elseif ($page_name[0] != "grp_membership" && ($output_group['group_registration_type'] == $c_node['group']['registration_type']['closed'])) { // closed group
			header("Location: grp_membership.php?group_id=" . $group_id . "&" . strip_tags(SID));
			exit;
		}
		
		unset($output_group['member']);
	}
	
	if (empty($output_group['member']['role_id'])) {
		// treat as a visitor to the group
		$output_group['member'] = $group_acs->getGroupRole(null, 1);
	}
	
	$group_acs->role_id = $output_group['member']['role_id'];
}

?>
