<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

/*
formatFileOutput
formats the html for a file
style = thumbnail image or link
tom calthrop
6th December 2004
*/
function formatFileOutput($arr_file, $style = null) {

	global $template_path, $c_node;

	if ($arr_file['file_suffix'] == "jpg" || $arr_file['file_suffix'] == "gif" || $arr_file['file_suffix'] == "png") {
		echo "<img src=\"get_file.php?file="  . $arr_file['file'] . "\" border=\"0\" class=\"picture\">";

	}
	elseif ($arr_file['file_suffix'] == "pdf") {
		echo "<img src=\"" . $template_path . "img/file_pdf.png\" border=\"0\">";
	}
	elseif ($arr_file['file_suffix'] == "txt") {
		echo "<img src=\"" . $template_path . "img/file_txt.png\" border=\"0\">";
	}
}


/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function dots($num, $string) {
	if (strlen($string) > $num) {
		$string = substr_replace($string, '...', $num);
	}
	return $string;
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);

	return $output;
}




/*
* searchTextFormat
* takes a search string, highlights it in the supplied txt
* and strips unwanted data
*
* tom calthrop
* 10th April 2004
*/
function searchTextFormat($search, $txt) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",          // Strip out HTML tags
       	"'([\r\n])[\s]+'",                // Strip out white space
       	"'&(quot|#34);'i"                // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search))-20);

	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}

	//make the search word red
	$txt = preg_replace("/($search)/i","<span class='txt_search_highlight'>\\0</span>",$txt);

	return $txt;
}



/*
* compare
* general function for usort (used in SocialNetwork.class.php
* 8th January 2005
*/
function compare($a, $b) {

	if($a["degree"]==$b["degree"])
		return 0;
	elseif($a["degree"]<$b["degree"])
		return -1;
	else
		return 1;
}



/*
* writeLogFile
* writes output to a text file
*
* tom calthrop
* 14th June 2005
*/
function writeLogFile($content) {
	
	$content = "\n" . date("Y-m-d H:i:s") . "\t " . $content;
	
	$path = "log/";
	$filename = "am_" . date('Y_m_d') . ".txt";
	
	//open or make the file
	if(!$handle = fopen($path . $filename, 'a')) {
		$handle = fopen($path . $filename, 'x');
	}
	// Write to file.
	@fwrite($handle, $content);
	//close file
	@fclose($handle);
}


// trimArray ---------------------------------------------------------------
// cuts an array down (used in lists)
// tom calthrop - 07 November 2005
//
function trimArray($arr) {
	
	global $c_node;
	
	if (count($arr) > $c_node['display']['max_list_rows']) {
		if (!isset($_REQUEST['_frm'])) {
			$_REQUEST['_frm'] = 0;
		}
		$new_arr = array_slice($arr, $_REQUEST['_frm'], $c_node['display']['max_list_rows']);
	}
	else {
		$new_arr = $arr;
	}
	
	return $new_arr;
}

// createArrayList ----------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function createArrayList($arr, $url_append=null) {
	
	global $c_node, $lang;
	
	if (isset($url_append)) {
		$url_append = "&" . $url_append;
	}
	else {
		$url_append = "";
	}
	
	if (count($arr) > $c_node['display']['max_list_rows']) {
		//build the url
		$args = array();
		
		foreach($_GET as $key => $i) {
			$args[$key] = $i;
		}
		
		if (isset($args['_frm'])) {
			$from = $args['_frm'];
			unset($args['_frm']);
		}
		else {
			$from = 0;
		}
		
		
		//start button
		$start_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
		if (0 == $from) {
			$start_html = "&lt;&lt;";
		}
		else {
			$start_html = "<a href='" . $start_url . "' title='" . $lang['txt_list_nav_start'] . "'>&lt;&lt;</a>";
		}
		
		//end button
		$num = count($arr)+1;
		while ($num > $c_node['display']['max_list_rows']):
			$num = $num - $c_node['display']['max_list_rows'];
		endwhile;
		
		$num = count($arr)+1 - $num;
		$args['_frm'] = $num;
		if ($from >= $num) {
			$end_html = "&gt;&gt;";
		}
		else {
			$end_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$end_html = "<a href='" . $end_url . "' title='" . $lang['txt_list_nav_end'] . "'>&gt;&gt;</a>";
		}
		
		//next button
		$args['_frm'] = $from + $c_node['display']['max_list_rows'];
		if ($args['_frm'] > count($arr)) {
			$next_html = "&gt;";
		}
		else {
			$next_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$next_html = "<a href='" . $next_url . "' title='" . $lang['txt_list_nav_next'] . "'>&gt;</a>";
		}
		
		//previous button
		$num = $from - $c_node['display']['max_list_rows'];
		
		if ($num < 0) {
			$num = 0;
		}
		$args['_frm'] = $num;
		if ($args['_frm'] == $from) {
			$prev_html = "&lt;";
		}
		else {
			$prev_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$prev_html = "<a href='" . $prev_url . "' title='" . $lang['txt_list_nav_prev'] . "'>&lt;</a>";
		}
		
		//pages
		$numrows = ceil(count($arr) / $c_node['display']['max_list_rows']);
		$pages_html = "";
		for ($i = 0; $i < $numrows; $i++) {
			$args['_frm'] = $i * $c_node['display']['max_list_rows'];
			$page_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args);
			
			if ($args['_frm'] == $from) {
				$pages_html .= ($i+1) . "&nbsp;&nbsp;";
			}
			else {
				$pages_html .= "<a href='" . $page_url . "' title='" . ($i+1) . "'>" . ($i+1) . "</a>&nbsp;";
			}
		}
		
		$out_html = "<p class='listnav'>";
		
		//first page
		$out_html .= $start_html . "&nbsp;&nbsp;";
		
		//previous page
		$out_html .= $prev_html . "&nbsp;&nbsp;";
		
		//pages
		$out_html .= $pages_html;
		
		//next page
		$out_html .= $next_html . "&nbsp;&nbsp;";
		
		//last page
		$out_html .= $end_html;
		
		$out_html .= "</p>";
		
		return $out_html;
	}
}

// arrayToString ---------------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function arrayToString($arr) {
	$str = "";
	foreach($arr as $key => $i):
		$str .= $key . "=" . $i . "&amp;";
	endforeach;
	
	$str = substr($str, 0, strlen($str)-5);
	
	return $str;
	
}

?>
