<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<form action="node_group.php" method="post">
<input type="hidden" name="group_id" value="<?php echo $group['group_id'];?>" />

<?php
if (isset($display) && $display == "view_group") {
?>
<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
					<?php echo $group['group_synopsis'];?><br />
				</p>
				
				
				<table width="100%" cellpadding="2" cellspacing="0" border="0">
					<?php 
					if (isset($group['group_registration_type'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_registration_group_type'];?><br />
						</td>
						<td>
							<?php echo $lang['arr_registration_type'][$group['group_registration_type']];?><br />
						</td>
					</tr>
					<?php }?>
					<tr>
						<td>
							<?php echo $lang['txt_status'];?><br />
						</td>
						<td>
							<?php echo $lang['arr_group_status'][$group['status_id']];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_language'];?><br />
						</td>
						<td>
							<?php echo $lang['arr_lang_name'][$group['language_id']];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_age'];?><br />
						</td>
						<td>
							<?php echo $lang['txt_age_from'];?> <?php if(isset($group['group_from_age'])) { echo $group['group_from_age']; } else {echo $lang['txt_age_any'];}?>&nbsp;
							<?php echo $lang['txt_age_to'];?> <?php if(isset($group['group_to_age'])) { echo $group['group_to_age']; } else {echo $lang['txt_age_any'];}?><br />
						</td>
					</tr>
					<?php 
					if (isset($group['genre_id'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_genre'];?><br />
						</td>
						<td>
							put meta data here
						</td>
					</tr>
					<?php }?>
					<tr>
						<td>
							<?php echo $lang['txt_group_id'];?><br />
						</td>
						<td>
							<?php echo $group['group_id'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_create_datetime'];?><br />
						</td>
						<td>
							<?php echo $group['group_create_datetime'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_author'];?><br />
						</td>
						<td>
							<?php echo $group['user_id'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_default_image'];?><br />
						</td>
						<td>
							<?php echo $group['file_id'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_visibility'];?><br />
						</td>
						<td>
							<?php
							if ($group['group_visibility'] == 1) {
								echo $lang['arr_group_visibility'][1];
							}
							else {
								echo $lang['arr_group_visibility'][2];
							}
							
							;?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_file_allocation'];?><br />
						</td>
						<td>
							<?php echo round($group['group_file_allocation']/1000, 2);?>kb<br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<b><?php echo $lang['txt_rules'];?></b><br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<?php echo $group['display_group_rules'];?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_menu'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<a href="node_group.php?group_id=<?php echo $group['group_id'];?>&amp;edit_group=1"><?php echo $lang['href_edit_group'];?></a><br />
				<a href="node_group.php"><?php echo $lang['href_list_groups'];?></a><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<?php
}
elseif (isset($display) && $display == "edit_group") {
?>
<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
					<?php echo $group['group_synopsis'];?><br />
				</p
				
				
				<table width="100%" cellpadding="2" cellspacing="0" border="0">
					<tr>
						<td>
							<label for="id_group_file_allocation"><?php echo $lang['txt_file_allocation'];?></label><br />
						</td>
						<td>
							<input id="id_group_file_allocation" type="text" name="group_file_allocation" size="10" value="<?php echo round($group['group_file_allocation']/1000, 2);?>">&nbsp;kb<br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_status"><?php echo $lang['txt_status'];?></label><br />
						</td>
						<td>
							<select id="id_status" name="status_id">
							<?php foreach($lang['arr_group_status'] as $key => $i): 
							?>
							<option value="<?php echo $key;?>" <? if($group['status_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_group_visibility"><?php echo $lang['txt_visibility'];?></label><br />
						</td>
						<td>
							<input id="id_group_visibility" type="radio" name="group_visibility" value="1" <?php if($group['group_visibility'] == 1) { echo "checked=\"checked\"";}?>>&nbsp;<?php echo $lang['arr_group_visibility'][1];?>&nbsp;&nbsp;
							<input id="id_group_visibility" type="radio" name="group_visibility" value="0" <?php if($group['group_visibility'] != 1) { echo "checked=\"checked\"";}?>>&nbsp;<?php echo $lang['arr_group_visibility'][2];?><br />
						</td>
					</tr>
					<tr>
						<td align="right" colspan="2">
							<input type="submit" name="update_group" value="<?php echo $lang['sub_update_group'];?>" class="button_urgent"><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_menu'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<a href="node_group.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_view_group'];?></a><br />
				<a href="node_group.php"><?php echo $lang['href_list_groups'];?></a><br />
				<a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_go_to_group'];?></a><br />
				
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
<?php
}
else {
?>
<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_groups'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
		<?php
		if (isset($groups)) {
		$display_items = trimArray($groups);
		?>
			<table border="0" cellspacing="0" cellpadding="4" width="100%">
				<?php
				foreach($display_items as $key => $i):
				?>
				<tr>
					<td valign="top">
						<a href="node_group.php?group_id=<?php echo $i['group_id'];?>"><?php echo $i['group_id'];?></a><br />
					</td>
					<td valign="top">
						<?php echo $i['group_title'];?><br />
					</td>
					<td valign="top">
						<?php if (isset($i['group_registration_type'])) { echo $lang['arr_registration_type'][$i['group_registration_type']];}?><br />
					</td>
					<td valign="top">
						<?php echo $i['group_total_members'];?><br />
					</td>
					<td valign="top">
						<?php echo $lang['arr_group_status'][$i['status_id']];?><br />
					</td>
					<td nowrap valign="top">
						<?php echo $this->date->formatDate($i['group_create_datetime'], 1)?><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php
			echo createArrayList($groups);
			}
			else {
			?>
			<p>
				<?php echo $lang['err_no_groups'];?><br />
			</p>
			<?php }?>
		</div>
	</div>
</div>
		
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php }?>
</form>
