<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

$menu_section = "magazine";

//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['blog']);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


//get blogs -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['blog'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resource_id, Priv_id
	require_once('class/Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $file);
	$blog->rsp_level_id = $rsp_level_id;
	$blog->rsp_featured = 1;
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	$blog->limit = 10;
	$blog->order_by = "rsp.rsp_sticky desc, b.blog_create_datetime desc";
	$output_blogs = $blog->selBlogs();
	
	if (!empty($output_blogs)) {
		unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		
		foreach($output_blogs as $key => $i):
			if (!empty($i['blog_allow_comments'])) {
				$output_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
			}
		endforeach;
	}
}


//get library items -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], $file);
	$library->rsp_level_id = $rsp_level_id;
	$library->rsp_featured = 1;
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	$library->order_by = "library_create_datetime desc";
	$library->limit = 10;
	$library->order_by = "rsp.rsp_sticky desc, l.library_create_datetime desc";
	$output_library_items = $library->selLibraryItems();
}


//get polls  -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['poll'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Poll.class.php');
	$poll = new Poll($db, $c_node['rsp']['item_type']['poll']);
	$poll->order_by = "p.poll_start_datetime desc";
	$poll->rsp_level_id = $rsp_level_id;
	$poll->rsp_featured = 1;
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	$poll->limit = 10;
	$poll->order_by = "rsp.rsp_sticky desc, p.poll_create_datetime desc";
	$output_polls = $poll->selPolls();
}


//get subjects  -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Forum.class.php');
	$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $file);
	$forum->rsp_level_id = $rsp_level_id;
	$forum->rsp_featured = 1;
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	$forum->order_by = "rsp.rsp_sticky desc, s.subject_create_datetime desc";
	$forum->limit = 10;
	
	unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
	$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
	$forum->comment = $comment;
	
	$output_subjects = $forum->selSubjects();
}


// SETUP SCHEDULE ------------------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Schedule.class.php');
	$schedule = new Schedule($db, null, $date, $file);
	$schedule->schedule_config = $c_node['schedule'];
	$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
	$schedule->rsp_level_id = $rsp_level_id;
	$schedule->rsp_featured = 1;
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	$schedule->order_by = "rsp.rsp_sticky desc, s.schedule_start_datetime desc";
	$schedule->limit = 10;
	$output_schedule_items = $schedule->selScheduleItems();
}


//move to template
if (!empty($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
}

if (!empty($display)) {
	$body->set('display', $display);
}

include "inc/footer.inc.php";
?>
