<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<?php
if (isset($display) && $display == "member") {
?>
<div class="col_main">
	<form action="grp_membership.php" method="post">
	<input type="hidden" name="group_id" value="<?php echo $group['group_id'];?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_profile'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($profile) ) {
				?>
				<?php
				if (isset($display) && $display == "blocked") {
				?>
				<p>
					<b><?php echo $lang['hdr_blocked'];?></b><br />
				</p>
				
				<p>
					<?php echo $lang['txt_blocked_help'];?><br />
				</p>
				
				<p align="right">
					<a href="sn_profile.php?blocked=1"><?php echo $lang['href_blocked_list'];?></a><br />
				</p>
				
				<hr />
				<?php }?>
				
				<p>
					<?php echo $profile['profile_summary'];?><br />
				</p>
				
				<?php 
				}
				else {
				?>
				<p>
					<?php echo $lang['err_no_member'];?><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_statistics'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" width="100%" cellspacing="0" cellpadding="2">
					<?php
					if (isset($gm_statistics)) {
					foreach($gm_statistics as $key => $i):
					if (isset($lang['arr_group_member_statistic_type_id'][$i['statistic_type_id']])) {
					?>
					<tr>
						<td>
							<?php echo $lang['arr_group_member_statistic_type_id'][$i['statistic_type_id']];?><br />
						</td>
						<td align="right">
							<?php echo $i['total'];?><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					} else {
					?>
					<tr>
						<td colspan="2">
							<?php echo $lang['err_no_member_statistics'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_edit_membership'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td valign="top" width="60%">
							<input type="hidden" name="user_id" value="<?php echo $profile['user_id'];?>" />
							<?php
							if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['edit_membership'])) { //resourece_id, Priv_id
								$edit_admin = 1;
							}
							else {
							?>
							<input type="hidden" name="group_member_number" value="<?php echo $group['member']['group_member_number'];?>" />
							<input type="hidden" name="role_id" value="<?php echo $group['member']['role_id'];?>" />
							<input type="hidden" name="status_id" value="<?php echo $group['member']['status_id'];?>" />
							<?php
							}
							?>
							
							<?php
							if ($me['user_id'] == $profile['user_id']) {
								$edit_profile = 1;
							}
							else {
							?>
							<input type="hidden" name="profile_id" value="<?php echo $profile['profile_id'];?>" />
							<?php
							}
							?>
							
							<?php
							if (!empty($edit_admin) || !empty($edit_profile)) {
							?>
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_edit_membership']?></b><br />
									</td>
								</tr>
								<?php
								if (!empty($edit_admin)) {
								?>
								<tr>
									<td>
										<?php echo $lang['txt_membership_number'];?><br />
									</td>
									<td>
										<input type="text" name="group_member_number" value="<?php echo $group['member']['group_member_number'];?>" size="20" /><br />
									</td>
								</tr>
								<tr>
									<td>
										<?php echo $lang['txt_member_role'];´?><br />
									</td>
									<td>
										<select name="role_id">
											<?php
											foreach($group_roles as $key => $i):
												$selected = "";
												if($group['member']['role_id'] == $i['role_id']) {
													$selected = " selected=\"selected\"";
												}
												echo "<option value='" . $i['role_id'] . "'" . $selected . ">" . $i['role_name'] . "</option>";
											endforeach;
											?>
										</select>
									</td>
								</tr>
								<tr>
									<td>
										<?php echo $lang['txt_member_status'];?><br />
									</td>
									<td>
										<select name="status_id">
											<?php
											foreach($group_member_status_ids as $key => $i):
												$selected = "";
												if($group['member']['status_id'] == $i) {
													$selected = " selected";
												}
												echo "<option value='" . $i . "'" . $selected . ">" . $lang['arr_group_member_status'][$i] . "</option>";
											endforeach;
											?>
										</select>
									</td>
								</tr>
								<?php
								}
								
								if (!empty($edit_profile)) {
								?>
								<tr>
									<td>
										<?php echo $lang['txt_profile'];?><br />
									</td>
									<td>
										<select name="profile_id">
											<?php
											foreach($profiles as $key => $i):
												$selected = "";
												if (isset($profile['profile_id']) && $profile['profile_id'] == $i['profile_id']) {
													$selected = "selected=\"selected\"";
												}
												echo "<option value='" . $i['profile_id'] . "' " . $selected . ">" . $i['profile_name'] . "</option>";
											endforeach;
											?>
										</select>
										<br />
									</td>
								</tr>
								<?php
								}
								?>
								<tr>
									<td align="right" colspan="2">
										<input type="submit" name="update_membership" value="<?php echo $lang['sub_update'];?>" class="button_urgent" /><br />
									</td>
								</tr>
							</table>
							<?php }?>
						</td>
						
						<td width="20">&nbsp;</td>
						
						<td valign="top" width="40%">
							<?php
							if (isset($display_confirmation_delete)) {
							?>
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_delete_membership_confirm']?></b><br />
									</td>
								</tr>
				
								<tr>
									<td>
										<?php echo $lang['txt_delete_membership_confirm'];?><br />
									</td>
								</tr>
								<tr>
									<td align="right">
										<input type="submit" name="delete_membership_confirm" value="<?php echo $lang['sub_confirm_delete'];?>" class="button_urgent"><br /><br />
									</td>
								</tr>
							</table>
							<?php
							}
							elseif ($profile['user_id'] == $group['member']['user_id'] || $this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['edit_membership'])) {
							?>
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								<tr>
									<td colspan="2">
										<b><?php echo $lang['hdr_delete_membership']?></b><br />
									</td>
								</tr>
				
								<tr>
									<td>
										<?php echo $lang['txt_delete_membership'];?><br />
									</td>
								</tr>
								<tr>
									<td align="right">
										<input type="submit" name="delete_membership" value="<?php echo $lang['sub_delete'];?>" class="button_urgent" /><br />
									</td>
								</tr>
							</table>
							
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
							<?php }?>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div style="float:left">
		<table width="100%" cellpadding="4" cellspacing="0" border="0">
			<tr>
				<td width="270" valign="top">
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['blog'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<div class="box">
						<div class="box_top">
							<?php echo $lang['hdr_member_blogs'];?><br />
						</div>
						
						<div class="box_mid">
							<div class="content">
								<table width="100%" cellpadding="4" cellspacing="0" border="0">
									<?php
									if (isset($blogs)) {
									foreach($blogs as $key => $i):
									?>
									<tr>
										<td valign="top" width="1%">
											<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
										</td>
										<td valign="top">
											<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a><br />
											<b><?php echo $i['blog_title'];?></b><br />
											<?php echo $i['blog_synopsis'];?><br />
										</td>
									</tr>
									<?php
									endforeach;
									} else {
									?>
									<tr>
										<td colspan="2">
											<?php echo $lang['err_no_blogs'];?><br />
										</td>
									</tr>
									<?php }?>
								</table>
							</div>
						</div>
					</div>
					
					<div class="box_bottom">
						<span class="box_bottom_right"></span>
						<span class="box_bottom_left"></span>
					</div>
					<?php }?>
					
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<div class="box">
						<div class="box_top">
							<?php echo $lang['hdr_member_library'];?><br />
						</div>
						
						<div class="box_mid">
							<div class="content">
								<table width="100%" cellpadding="4" cellspacing="0" border="0">
									<?php
									if (isset($library)) {
									foreach($library as $key => $i):
									?>
									<tr>
										<td valign="top" width="1%">
											<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
										</td>
										<td valign="top">
											<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><?php echo $i['library_title'];?></a><br />
											<b><?php echo $i['library_title'];?></b><br />
											<?php echo $i['library_synopsis'];?><br />
										</td>
									</tr>
								<?php
									endforeach;
									} else {
									?>
									<tr>
										<td colspan="2">
											<?php echo $lang['err_no_library'];?><br />
										</td>
									</tr>
								<?php }?>
								</table>
							</div>
						</div>
					</div>
					
					<div class="box_bottom">
						<span class="box_bottom_right"></span>
						<span class="box_bottom_left"></span>
					</div>
					<?php }?>
				</td>
				
				<td width="20">&nbsp;</td>
				
				<td width="270" valign="top">
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<div class="box">
						<div class="box_top">
							<?php echo $lang['hdr_member_subjects'];?><br />
						</div>
						
						<div class="box_mid">
							<div class="content">
								<table width="100%" cellpadding="4" cellspacing="0" border="0">
									<?php
									if (isset($subjects)) {
									foreach($subjects as $key => $i):
									?>
									<tr valign="top">
										<td valign="top" width="1%">
											<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
										</td>
										<td valign="top">
											<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime']);?></a><br />
											<b><?php echo $i['subject_title'];?></b><br />
											<?php echo $i['subject_synopsis'];?><br />
										</td>
									</tr>
									<?php
									endforeach;
									} else {
									?>
									<tr>
										<td colspan="2">
											<?php echo $lang['err_no_subjects'];?><br />
										</td>
									</tr>
									<?php }?>
								</table>
							</div>
						</div>
					</div>
					
					<div class="box_bottom">
						<span class="box_bottom_right"></span>
						<span class="box_bottom_left"></span>
					</div>
					<?php }?>
					
					<div class="box">
						<div class="box_top">
							<?php echo $lang['hdr_member_comments'];?><br />
						</div>
						
						<div class="box_mid">
							<div class="content">
								<table width="100%" cellpadding="4" cellspacing="0" border="0">
									<?php
									if (isset($comments)) {
									foreach($comments as $key => $i):
									?>
									<tr>
										<td width="3" valign="top">
											<img src="<?php echo $templatePath;?>img/green_dot.png" width="3" height="9" alt="" /><br />
										</td>
										<td valign="top">
											<?php echo $i['comment_body'];?><br />
										</td>
									</tr>
								<?php
									endforeach;
									} else {
									?>
									<tr>
										<td colspan="2">
											<?php echo $lang['err_no_comments'];?><br />
										</td>
									</tr>
								<?php }?>
								</table>
							</div>
						</div>
					</div>
					
					<div class="box_bottom">
						<span class="box_bottom_right"></span>
						<span class="box_bottom_left"></span>
					</div>
				</td>
			</tr>
		</table>
	</div>
</div>
</form>

<div class="col_side">
	<?php
	if (isset($profile) ) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $profile['profile_nic'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_membership_number'];?><br />
						</td>
						<td>
							<?php echo $member['group_member_number'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_join_date'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($member['group_member_create_datetime']);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_membership_role'];?><br />
						</td>
						<td>
							<?php echo $member['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<a href="msg_edit.php?to_user_id=<?php echo $profile['user_id'];?>"><img src="<?php echo $templatePath;?>img/unopenned_mail.png" alt="<?php echo $lang['ttl_send_message'];?>" border="0" /></a><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($profile) && $me['user_id'] == $profile['user_id']) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_apply'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table cellpadding="2" cellspacing="0" border="0">
					<tr>
						<td valign="top">
							<?php echo $lang['txt_group_title'];?><br />
						</td>
						<td valign="top">
							<b><?php echo $group['group_title'];?></b><br />
						</td>
					</tr>
					
					<tr>
						<td valign="top">
							<?php echo $lang['txt_group_registration_type'];?><br />
						</td>
						<td valign="top">
							<?php
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden_group'];
							}
							?>
							<br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_language'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['arr_lang_name'][$group['language_id']];?>
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_group_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $group['group_from_age'] . " and up";
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo "up to " . $group['group_to_age'];
							}
							else {
								echo "all";
							}
							?>
							<br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_start_date'];?><br />
						</td>
						<td valign="top">
							<?php echo $this->date->formatDate($group['group_create_datetime']);?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_status'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['arr_group_status'][$group['status_id']];?><br />
						</td>
					</tr>
				</table>
					
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
				
				<?php
				if (isset($display)) {
				?>
				<p>
					<?php
					if (isset($display) && $display == "group_application_in_progress") {
						echo $lang['txt_group_pending'];
					}
					elseif (isset($display) && $display == "group_apply_approved") {
						echo $lang['txt_group_approved'];
						$button = "reg";
					}
					elseif (isset($display) && $display == "group_apply_automatic") {
						echo $lang['txt_group_automatic'];
						$button = "open";
					}
					?>
				</p>
				
				<?php
				if (isset($button)) {
				?>
				<p>
					<?php echo $lang['txt_profile_select_txt'];?><br />
					</p>
					<p>
					<label for="id_profile_id"><?php echo $lang['txt_from_profile'];?></label>
					
					<select id="id_profile_id" name="profile_id" class="formInput">
						<?php
						foreach($profiles as $key => $i):
							echo "<option value='" . $i['profile_id'] . "'>" . $i['profile_name'] . "</option>";
						endforeach;
						?>
					</select>
					<br />
				</p>
				
				<p>
					<?php echo $lang['txt_join_notes'];?><br />
				</p>
				
				<p align="right">
					<?php
					if ($button == "reg") {
					?>
					<input type="submit" name="user_pending" value="<?php echo $lang['sub_join'];?>" class="button_urgent" /><br />
					<?php
					}
					elseif ($button == "open") {
					?>
					<input type="submit" name="user_member" value="<?php echo $lang['sub_join'];?>" class="button_urgent" /><br />
					<?php
					}}
					?>
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
<?php
}
elseif (isset($display) && $display == "apply") {
?>
<div class="col_main">
	<form action="grp_membership.php" method="post">
	<input type="hidden" name="group_id" value="<?php echo $group['group_id'];?>" />
	
	<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_apply'];?><br />
	</div>
	
	<div class="box_mid">
			<div class="content">
				<p>
					<?php
					if (isset($display_join) && $display_join == "group_application_in_progress") {
						echo $lang['txt_group_pending'];
					}
					elseif (isset($display_join) && $display_join == "group_apply_approved") {
						echo $lang['txt_group_approved'];
						$button = "reg";
					}
					elseif (isset($display_join) && $display_join == "group_apply_automatic") {
						echo $lang['txt_group_automatic'];
						$button = "open";
					}
					?>
				</p>
				<?php
				if (isset($button)) {
				?>
				<p>
					<?php echo $lang['txt_profile_select_txt'];?><br />
				</p>
				
				<p>
					<label for="id_profile_id"><?php echo $lang['txt_from_profile'];?></label>
					
					<select id="id_profile_id" name="profile_id" class="formInput">
						<?php
						foreach($profiles as $key => $i):
							echo "<option value='" . $i['profile_id'] . "'>" . $i['profile_name'] . "</option>";
						endforeach;
						?>
					</select>
					<br />
				</p>
					
				<p align="right">
					<?php
					echo $lang['txt_join_notes'] . "&nbsp;&nbsp;";
					
					if ($button == "reg") {
					?>
					<input type="submit" name="user_pending" value="<?php echo $lang['sub_join'];?>" class="button_urgent" /><br />
					<?php
					}
					elseif ($button == "open") {
					?>
					<input type="submit" name="user_member" value="<?php echo $lang['sub_join'];?>" class="button_urgent" /><br />
					<?php
					}
					?>
				</p>
				<?php
				}
				else {
				?>
				<?php echo $lang['txt_group_unavailable'];?><br />
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group_rules'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $group['display_group_rules'];?></b><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_node_rules'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_node_rules'];?><br />
			</p>
		</div>
		</div>
	</div>
</div>
</form>

<div class="col_side">
	
</div>


<?php
}
else {
?>
<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_apply'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<b><?php echo $lang['txt_no_access_allowed_login'];?></b><br />
		</div>
	</div>
</div>

<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php }?>
