<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="<?php echo $language_arr[0];?>" />
<meta name="keywords" content="<?php echo $lang['meta_keywords'];?>" />
<meta name="OriginalPublicationDate" content="<?php echo $lang['meta_OriginalPublicationDate'];?>" />
<meta name="Description" content="<?php echo $lang['meta_Description'];?>" />

<title><?php echo $lang['txt_page_title'];?></title>
<style type="text/css">
<!--
@import url(<?php echo $templatePath;?>aroundme.css);

-->
</style>
<!--[if IE]>
<style type="text/css">
@import url(<?php echo $templatePath;?>aroundme-IE.css);
</style>
<![endif]-->



<?php
//we reload an image in this template just before the session times out to
//make sure that the session does not time out
$session_maxlifetime = ini_get('session.gc_maxlifetime'); // in seconds

// we need to warn 1 minute before
$session_warning_time = 60; // seconds
if ($session_maxlifetime > $session_warning_time) {
	$session_maxlifetime = $session_maxlifetime-$session_warning_time;
}
$session_maxlifetime_ms = $session_maxlifetime*1000; // in milliseconds
?>


<script type="text/javascript" src="js/functions.js"></script>
<script type="text/javascript" src="speller/spellChecker.js"></script>
<script type="text/javascript">
	var baseImgURL = '<?php echo $templatePath;?>img/';

	//takes form elements (text and textarea) and passes to spellchecker
	function openSpellChecker() {
		var speller = new spellChecker();
		speller.spellCheckAll();
	}

</script>


</head>

<script type="text/javascript">
var session_maxlifetime_ms = <?php echo $session_maxlifetime_ms;?>;

function ShowTimeoutWarning () {
	// we append the time to the string to avoid caching
	var urldate = new Date()
	var urltime = urldate.getTime()
	document.session_reload_image.src = 'get_file.php?file=session_reload_image.png&reloadsession=start&now=' + urltime;
	setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
}

</script>

<body onLoad="setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );">

<div id="layout">
	<div id="header">
		<div class="masthead">
			
			
			<div class="menu">
				<?php
				if ($page_name_short == "search") {
				?>
				<?php echo $lang['hdr_search'];?>
				<?php
				}
				else {
				?>
				<a href="search.php"><?php echo $lang['hdr_search'];?></a>
				<?php }?>
				&nbsp;
				<?php
				if (isset($me['mail']) && $me['mail'] > 0) {
				?>
				<a href="msg_view.php"><img src="<?php echo $templatePath;?>img/unopenned_mail.png" alt="" border="0" /></a>&nbsp;(<a href="msg_view.php"><?php echo $me['mail'];?></a>)
				&nbsp;
				<?php }?>
				
				<?php
				if (isset($me['user_id']) && $me['user_id'] > 0) {
				?>
				
				<?php
				if (empty($_POST) && $page_name_short != "report_abuse") { //we do not want them to report abuse after they post as it will create a page error as we cannot re-pass the POST data to the page
					$url = $_SERVER['REQUEST_URI'];
					if (substr($url, -4) == ".php") {
						$url .= "?";
					}
					else {
						$url .= "&amp;";
					}
					$url .= "abuse_report=1";
				?>
				<a href="<?php echo $url;?>"><?php echo $lang['href_report_abuse'];?></a>
				&nbsp;
				<?php }?>
				
				<a href="index.php?logoff=1"><?php echo $lang['href_logoff'];?></a>&nbsp;<?php echo $_SESSION['user_firstname'];?>
				<?php
				}
				else {
				?>
				<?php
				if (count($lang['arr_lang_name']) > 1) {
					foreach ($lang['arr_lang_name'] as $key => $i):
						if ($key == $me['language_id']) {
							echo $i . "&nbsp;";
						}
						else {
							echo "<a href=\"spl_view.php?language_id=" . $key . "\">" . $i . "</a>&nbsp;";
						}
					endforeach;
				}
				?>
				<a href="index.php"><?php echo $lang['href_login'];?></a>
				<?php
				if (isset($allow_registration) && $allow_registration == 1) {
				?>
				&nbsp;
				<a href="register.php"><?php echo $lang['href_register'];?></a>
				<?php }}?>
			</div>
			
			<div class="shoutbox">
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['shoutbox'], $privilege_ids['allow_access'])) {
				?>
				<a href="sho_view.php"><?php echo $lang['href_shoutbox'];?></a>
				<?php
				if (isset($shoutbox)) {
				?>
				&nbsp;
				<a href="sn_profile.php?user_id=<?php echo $shoutbox['user_id'];?>"><?php echo $shoutbox['profile_nic'];?></a>
				&nbsp;
				<?php echo $shoutbox['shoutbox_body'];?>
				<?php }}?>
				<br />
			</div>
		</div>
	
		<div id="main_menu">
			<div class="content">
				<p>
					<?php
					if (isset($section) && $section == "splash") {
						echo $lang['href_splash'];
					}
					else {
						echo "<a href='spl_view.php'>" . $lang['href_splash'] . "</a>";
					}
					?><br />
				</p>
					
				<p>
					<?php
					if (isset($section) && $section == "magazine") {
						echo $lang['href_data'];
					}
					else {
						echo "<a href='mag_view.php'>" . $lang['href_data'] . "</a>";
					}
					?><br />
				</p>
					
				<?php
				if (isset($me['user_id']) && $me['user_id'] > 0) {
				?>
				<p>
					<?php
					if (isset($section) && $section == "my") {
						echo $lang['href_me'];
					}
					else {
						echo "<a href='my_view.php'>" . $lang['href_me'] . "</a>";
					}
					?><br />
				</p>
				<?php }?>
					
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['network'], $privilege_ids['allow_directory'])) { //resource_id, Priv_id
				?>
				<p>
					<?php
					if (isset($section) && $section == "network") {
						echo $lang['href_network'];
					}
					else {
						echo "<a href='sn_list.php?relation=1'>" . $lang['href_network'] . "</a>";
					}
					?><br />
				</p>
				<?php }?>
				
				<p>
					<?php
					if (isset($section) && $section == "group") {
						echo $lang['href_group'];
					}
					else {
						echo "<a href='grp_list.php'>" . $lang['href_group'] . "</a>";
					}
					?><br />
				</p>
				
				<p>
					<?php
					if (isset($section) && $section == "structure") {
						echo $lang['href_structure'];
					}
					else {
						echo "<a href='node_structure.php'>" . $lang['href_structure'] . "</a>";
					}
					?><br />
				</p>
			</div>
		</div>
	
		<div id="sub_menu">
			<div class="content">
				<?php
				if (isset($section)) {
				?>
				
					<?php
					if ($section == "splash") {
					?>
						<?php
						if ($page_name_short == "spl_view" && !isset($_REQUEST['man'])) {
						?>
						<?php echo $lang['menu_intro'];?>
						<?php
						} else {
						?>
						<a href="spl_view.php"><?php echo $lang['menu_intro'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "spl_view" && isset($_REQUEST['man'])) {
						?>
						<?php echo $lang['menu_help'];?>
						<?php
						} else {
						?>
						<a href="spl_view.php?man=1"><?php echo $lang['menu_help'];?></a>
						<?php }?>
						<br />
						
					<?php
					}
					elseif ($section == "magazine") {
					?>
						<span class="txt_highlight"><?php echo $lang['txt_everyone'];?></span>:
						&nbsp;
						
						<?php
						if ($page_name_short == "mag_view") {
						?>
						<?php echo $lang['menu_featured'];?>
						<?php
						} else {
						?>
						<a href="mag_view.php"><?php echo $lang['menu_featured'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "blg_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_blog'];?></span>
						<?php
						} else {
						?>
						<a href="blg_view.php"><?php echo $lang['menu_blog'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "lib_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_library'];?></span>
						<?php
						} else {
						?>
						<a href="lib_view.php"><?php echo $lang['menu_library'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "frm_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_forum_subject'];?></span>
						<?php
						} else {
						?>
						<a href="frm_view.php"><?php echo $lang['menu_forum_subject'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "pol_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_polls'];?></span>
						<?php
						} else {
						?>
						<a href="pol_view.php?list=1"><?php echo $lang['menu_polls'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "sch_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_schedule'];?></span>
						<?php
						} else {
						?>
						<a href="sch_view.php"><?php echo $lang['menu_schedule'];?></a>
						<?php }?>
						&nbsp;
						<?php
						if ($page_name_short == "chl_view") {
						?>
						<span class="txt_highlight"><?php echo $lang['menu_channels'];?></span>
						<?php
						} else {
						?>
						<a href="chl_view.php"><?php echo $lang['menu_channels'];?></a>
						<?php }?>
						<br />
					<?php
					}
					elseif ($section == "my") {
					?>
						<?php
						if ($page_name_short == "my_view") {
						?>
						<?php echo $lang['menu_overview'];?>
						<?php
						} else {
						?>
						<a href="my_view.php"><?php echo $lang['menu_overview'];?></a>
						<?php }?>
						&nbsp;
						
						<?php
						if ($page_name_short == "msg_view" || $page_name_short == "msg_edit") {
						?>
						<?php echo $lang['menu_messages'];?>&nbsp;(<?php echo $me['mail'];?>)
						<?php
						} else {
						?>
						<a href="msg_view.php"><?php echo $lang['menu_messages'];?></a>&nbsp;(<?php echo $me['mail'];?>)
						<?php }?>
						&nbsp;
						
						<?php
						if ($page_name_short == "my_membership") {
						?>
						<?php echo $lang['menu_membership'];?>
						<?php
						} else {
						?>
						<a href="my_membership.php"><?php echo $lang['menu_membership'];?></a>
						<?php }?>
						&nbsp;
						
						<?php
						if ($page_name_short == "my_profile") {
						?>
						<?php echo $lang['menu_profile'];?>
						<?php
						} else {
						?>
						<a href="my_profile.php"><?php echo $lang['menu_profile'];?></a>
						<?php }?>
						&nbsp;
						
						<?php
						if (isset($me['user_id']) && $this->user_acs->checkPermission($resource_ids['node']['skills'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
						if ($page_name_short == "skl_edit") {
						?>
						<?php echo $lang['menu_skills'];?>
						<?php
						} else {
						?>
						<a href="skl_edit.php"><?php echo $lang['menu_skills'];?></a>
						<?php }?>
						&nbsp;
						<?php }?>
						
						<?php
						if ($page_name_short == "my_bookmarks") {
						?>
						<?php echo $lang['menu_bookmarks'];?>
						<?php
						} else {
						?>
						<a href="my_bookmarks.php"><?php echo $lang['menu_bookmarks'];?></a>
						<?php }?>
						
						&nbsp;
						<?php
						if ($page_name_short == "my_publishing") {
						?>
						<?php echo $lang['menu_publishing'];?>
						<?php
						} else {
						?>
						<a href="my_publishing.php"><?php echo $lang['menu_publishing'];?></a>
						<?php }?>
						
						&nbsp;
						<?php
						if ($page_name_short == "fil_view") {
						?>
						<?php echo $lang['menu_files'];?>
						<?php
						} else {
						?>
						<a href="fil_view.php"><?php echo $lang['menu_files'];?></a>
						<?php }?>
						<br />
					<?php
					}
					elseif ($section == "network") {
					?>
						<?php
						if (isset($me['user_id']) && $this->user_acs->checkPermission($resource_ids['node']['network'], $privilege_ids['allow_network'])) { //resource_id, Priv_id
						if ($page_name_short == "sn_list" && isset($relations)) {
						?>
						<?php echo $lang['menu_network'];?>
						<?php
						} else {
						?>
						<a href="sn_list.php?relation=1"><?php echo $lang['menu_network'];?></a>
						<?php }?>
						&nbsp;
						<?php }?>
						
						<?php
						if ($page_name_short == "sn_list" && !isset($relations)) {
						?>
						<?php echo $lang['menu_directory'];?>
						<?php
						} else {
						?>
						<a href="sn_list.php"><?php echo $lang['menu_directory'];?></a>
						<?php }?>
						
						<?php
						if (isset($me['user_id'])) {
							echo "&nbsp;";
						if ($page_name_short == "sn_blocked") {
						?>
						<?php echo $lang['menu_blocked_users'];?>
						<?php
						} else {
						?>
						<a href="sn_blocked.php"><?php echo $lang['menu_blocked_users'];?></a>
						<?php }}?>
										
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['network'], $privilege_ids['allow_network_ext'])) { //resource_id, Priv_id
						?>
						&nbsp;
						<?php
						if ($page_name_short == "sn_invite") {
						?>
						<?php echo $lang['menu_invite'];?>
						<?php
						} else {
						?>
						<a href="sn_invite.php"><?php echo $lang['menu_invite'];?></a>
						<?php }}?>
						
						<?php
						if (isset($me['user_id']) && $this->user_acs->checkPermission($resource_ids['node']['skills'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
						?>
						&nbsp;
						<?php
						if ($page_name_short == "skl_view") {
						?>
						<?php echo $lang['menu_skills_finder'];?>
						<?php
						} else {
						?>
						<a href="skl_view.php"><?php echo $lang['menu_skills_finder'];?></a>
						<?php }}?>
						
						<br />
					<?php
					}
					elseif ($section == "structure") {
					?>
						<?php
						if ($page_name_short == "node_structure") {
						?>
						<?php echo $lang['menu_structure'];?>
						<?php
						} else {
						?>
						<a href="node_structure.php"><?php echo $lang['menu_structure'];?></a>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_membership'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_user") {
						?>
						<?php echo $lang['menu_user_list'];?>
						<?php
						} else {
						?>
						<a href="node_user.php"><?php echo $lang['menu_user_list'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_newsletter'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "nlt_view" || $page_name_short == "nlt_edit") {
						?>
						<?php echo $lang['menu_newsletter'];?>
						<?php
						} else {
						?>
						<a href="nlt_view.php"><?php echo $lang['menu_newsletter'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_acs'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_acs") {
						?>
						<?php echo $lang['menu_acs'];?>
						<?php
						} else {
						?>
						<a href="node_acs.php"><?php echo $lang['menu_acs'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['rsp'], $privilege_ids['allow_edit'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_rsp") {
						?>
						<?php echo $lang['menu_rsp'];?>
						<?php
						} else {
						?>
						<a href="node_rsp.php"><?php echo $lang['menu_rsp'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_abuse_reports'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_abuse_reports") {
						?>
						<?php echo $lang['menu_abuse_reports'];?>
						<?php
						} else {
						?>
						<a href="node_abuse_reports.php"><?php echo $lang['menu_abuse_reports'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['tagging'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_tags") {
						?>
						<?php echo $lang['menu_tag_mgmt'];?>
						<?php
						} else {
						?>
						<a href="node_tags.php"><?php echo $lang['menu_tag_mgmt'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_group_mgmt'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "node_group") {
						?>
						<?php echo $lang['menu_group_mgmt'];?>
						<?php
						} else {
						?>
						<a href="node_group.php"><?php echo $lang['menu_group_mgmt'];?></a>
						<?php }}?>
						<br />
						
					<?php
					}
					elseif ($section == "group") {
					?>
						<?php
						if ($page_name_short == "grp_list") {
						?>
						<?php echo $lang['menu_groups'];?>
						<?php
						} else {
						?>
						<a href="grp_list.php"><?php echo $lang['menu_groups'];?></a>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['node']['group'], $privilege_ids['allow_create'])) { //resource_id, Priv_id
						echo "&nbsp;";
						if ($page_name_short == "grp_create") {
						?>
						<?php echo $lang['menu_create_group'];?>
						<?php
						} else {
						?>
						<a href="grp_create.php"><?php echo $lang['menu_create_group'];?></a>
						<?php }}?>
						<br />
					<?php }?>
				<?php }?>
				
				<?php
				if (isset($group)) {
				?>
					<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
					<a href="grp_view.php?group_id=<?php echo $group['group_id'];?>" class="txt_highlight" title="<?php echo $group['group_title'];?>">group</a>:
					&nbsp;
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['blog'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "blg_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_blog'];?></span>
					<?php
					} else {
					?>
					<a href="blg_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_blog'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "frm_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_forum_subject'];?></span>
					<?php
					} else {
					?>
					<a href="frm_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_forum_subject'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['poll'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "pol_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_polls'];?></span>
					<?php
					} else {
					?>
					<a href="pol_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_polls'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['files'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "fil_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_files'];?></span>
					<?php
					} else {
					?>
					<a href="fil_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_files'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "lib_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_library'];?></span>
					<?php
					} else {
					?>
					<a href="lib_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_library'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['schedule'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "sch_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_schedule'];?></span>
					<?php
					} else {
					?>
					<a href="sch_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_schedule'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['channels'], $privilege_ids['allow_access'])) { //resource_id, Priv_id
					if ($page_name_short == "chl_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_channels'];?></span>
					<?php
					} else {
					?>
					<a href="chl_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_channels'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($page_name_short == "grp_structure") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_structure'];?></span>
					<?php
					} else {
					?>
					<a href="grp_structure.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_structure'];?></a>
					<?php }?>
					&nbsp;
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_membership'])) { //resource_id, Priv_id
					if ($page_name_short == "grp_directory") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_directory'];?></span>
					<?php
					} else {
					?>
					<a href="grp_directory.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_directory'];?></a>
					<?php }}?>
					&nbsp;
					
					<?php
					if ($page_name_short == "grp_membership") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_membership'];?></span>
					<?php
					} else {
					?>
					<a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_membership'];?></a>
					<?php }?>
					&nbsp;
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_newsletter'])) { //resource_id, Priv_id
					if ($page_name_short == "nlt_view") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_newsletter'];?></span>
					<?php
					} else {
					?>
					<a href="nlt_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_newsletter'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_acs'])) { //resource_id, Priv_id
					if ($page_name_short == "grp_acs") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_acs'];?></span>
					<?php
					} else {
					?>
					<a href="grp_acs.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_acs'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['rsp'], $privilege_ids['allow_edit'])) { //resource_id, Priv_id
					if ($page_name_short == "grp_rsp") {
					?>
					<span class="txt_highlight"><?php echo $lang['menu_rsp'];?></span>
					<?php
					} else {
					?>
					<a href="grp_rsp.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['menu_rsp'];?></a>
					<?php }?>
					&nbsp;
					<?php }?>
					<br />
				<?php }?>
			</div>
		</div>
	
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
	</div>

	<?php
	if (isset ($breadcrumb)) {
	?>
	<div id="breadcrumb">
	 	<?php echo $lang['txt_history'];?>:&nbsp;&nbsp;
		<?php
		foreach($breadcrumb as $key => $i):
			if(isset($i['breadcrumb_title'])) {

				if (count($breadcrumb) == $key+1) {
				    echo $i['breadcrumb_title'];
				}
				else {
					echo "<a href='" . $i['breadcrumb_url'] . "' title='" . $i['breadcrumb_note'] . "'>" . $i['breadcrumb_title'] . "</a>&nbsp;&nbsp;&nbsp;";
				}
			}
		endforeach;
		?><br />
	</div>
	<?php }?>

	<?php
	if (isset($log)) {
	?>
	<div id="system_message">
		<?php
		foreach($log as $key => $i):
			if (isset($i[0])) {
				unset($error);
				if (isset($error_handling) && $error_handling>0 && isset($i[1])) {
					$error = $lang['arr_error'][$i[0]] . ": " . $i[2] . "<br />";
				}
				elseif (empty($i[1])) {
					$error = $lang['arr_error'][$i[0]] . "<br />";
				}
			}

			if (isset($error)) {
				echo "<p>" . $error . "</p>";
			}
		endforeach;
		?>
	</div>
	<?php }?>


	<div id="content">
		<?php echo $content;?>
	</div>

	<div id="footer">
		<!-- under our free license policy you are allowed to remove this, however we would obviously like it if you chose to promote us through including the following text/link/logo -->
		<a href="http://www.barnraiser.org/aroundme/"><img src="<?php echo $templatePath;?>img/aroundme.png" width="142" height="43" alt="" border="0" /></a>
		<?php echo $lang['txt_strap'];?><br />
	</div>
	
	<img name="session_reload_image" src="get_file.php?file=session_reload_image.png" alt="" />
	

</div>
</body>
</html>
