<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Fratinglin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="skl_edit.php" method="post" name="frm" id="id_frm">
<input type="hidden" name="skill_id" value="<?php if (isset($skill['skill_id'])) { echo $skill['skill_id'];}?>" /><br />
				
<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_skills'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_skills_intro'];?><br />
				</p>
				
				<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
				
				<?php 
				if (isset($skills)) {
				?>
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<?php
					foreach($skills as $key => $i): ?>
					<tr>
						<td valign="top">
							<b><a href="skl_edit.php?skill_id=<?php echo $i['skill_id'];?>"><?php echo $i['skill_name'];?></a></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $i['skill_experience'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top" align="right">
							<i>
							<?php 
							if (isset($lang['arr_skill']['rating'][$i['skill_rating']])) {
								echo $lang['arr_skill']['rating'][$i['skill_rating']];
							}
							?>, 
							<?php 
							if (isset($lang['arr_skill']['degree'][$i['degree_id']])) {
								echo $lang['arr_skill']['degree'][$i['degree_id']];
							}
							else {
								echo $lang['txt_directory'];
							}
							?>
							</i><br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						</td>
					</tr>
					<?php 
					endforeach; 
					?>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['err_no_skills'];?><br />
				</p>
				<?php }?>
				
				<p align="right">
					<br />
					<a href="skl_edit.php?view=add_skill"><?php echo $lang['href_add_item'];?></a><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_skills_add'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_skill_hint'];?><br />
				</p>
				
				<p>
					<label for="id_skill_name"><?php echo $lang['txt_skill_name'];?></label>
					<input id="id_skill_name" type="text" class="input" name="skill_name" size="30" value="<?php if (isset($skill['skill_name'])) { echo $skill['skill_name'];}?>" /><br />
				</p>
				<br />
				<p>
					<label for="id_skill_experience"><?php echo $lang['txt_skill_experience'];?></label>
					<textarea id="id_skill_experience" name="skill_experience" cols="28" rows="6"><?php if (isset($skill['skill_experience'])) { echo $skill['skill_experience'];}?></textarea><br />
				</p>
				
				<?php
				if (isset($lang['arr_skill']['rating'])) {
				?>
				<p>
					<label for="id_skill_rating"><?php echo $lang['txt_skill_rating'];?></label>
					<select name="skill_rating">
					<?php foreach($lang['arr_skill']['rating'] as $key => $i): ?>
						<option value="<?php echo $key;?>" <?php if(isset($skill['skill_rating']) && $skill['skill_rating'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
					<?php endforeach; ?>
					</select>
				</p>
				<?php }?>
				
				
				<p>
					<?php echo $lang['txt_degree'];?><br /><br />
					<input type="radio" name="degree_id" value="1" checked="checked">
					<?php echo $lang['form_my_network'];?><br />
					<input type="radio" name="degree_id" value="all" <?php if(isset($skill['degree_id']) && $skill['degree_id'] == "all") { echo "checked=\"checked\"";}?>>
					<?php echo $lang['form_directory'];?><br />
				</p>
					
				<p align="right">
					<?php
					if (!empty($skill)) {
					?>
					<input type="submit" class="input_submit" name="delete_skill" value="<?php echo $lang['sub_delete'];?>" />&nbsp;
					<input type="submit" class="input_submit" name="update_skill" value="<?php echo $lang['sub_update'];?>" /><br />
					<?php
					}
					else {
					?>
					<input type="submit" class="input_submit" name="insert_skill" value="<?php echo $lang['sub_add'];?>" /><br />
					<?php }?>
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
</form>