<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<div class="col_main">
	<?php
	if (isset($blog)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($blog['blog_create_datetime'], 1);?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<div class="metadata_top">
					<b><?php echo $lang['txt_item_options'];?></b> -&#62; 
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) { // we need to be logged in
					?>
					
					<?php
					if ($me['user_id'] == $blog['user_id']) {
					?>
					<a href="blg_edit.php?blog_id=<?php echo $blog['blog_id'];?>"><?php echo $lang['href_edit'];?></a>
					,&nbsp;
					<?php }?>
					
					<?php
					if (isset($blog['bookmark']['watch'])) {
					?>
					<a href="blg_view.php?blog_id=<?php echo $blog['blog_id'];?>&amp;bookmark=del_mark"><?php echo $lang['href_unwatch_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="blg_view.php?blog_id=<?php echo $blog['blog_id'];?>&amp;bookmark=ins_mark"><?php echo $lang['href_watch_this'];?></a>
					<?php }?>
					
					
					<?php
					if ($me['user_id'] != $blog['user_id']) {
					?>
					,&nbsp;
					<?php
					if (isset($blog['bookmark']['recommend'])) {
					?>
					<a href="blg_view.php?blog_id=<?php echo $blog['blog_id'];?>&amp;bookmark=del_tip"><?php echo $lang['href_unrecommend_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="blg_view.php?blog_id=<?php echo $blog['blog_id'];?>&amp;bookmark=ins_tip"><?php echo $lang['href_recommend_this'];?></a>
					<?php }}?>
					
					<?php
					if (!isset($blog['bookmark']['watch']) && isset($batch_enabled) && $batch_enabled == true) {
					?>
					,&nbsp;
					<a href="blg_view.php?blog_id=<?php echo $blog['blog_id'];?>&amp;bookmark=ins_mark&amp;notify=1"><?php echo $lang['href_watch_this_notify'];?></a>
					<?php }?>
					
					<?php }?>
					<br />
				</div>
				
				<p class="txt_item_title">
					<?php echo $blog['blog_title'];?><br />
				</p>
				
				<p>
				<?php echo $blog['blog_body_display'];?><br />
				</p>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
						if (isset($group)) {
							$profile_url = "grp_membership.php?group_id=" . $group['group_id'] . "&amp;user_id=" . $author['user_id'];
						}
						else {
							$profile_url = "sn_profile.php?user_id=" . $author['user_id'];
						}
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="<?php echo $profile_url;?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<?php
							if (isset($group)) {
							?>
							&nbsp;<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a>
							<?php }?>
							<br />
						</p>
					<?php }?>
					
					<p>
						<b><?php echo $lang['hdr_blog_entry'];?></b> -&#62; 
						<?php
						if (!empty($blog['bookmark'])) {
							echo $lang['txt_bookmarks'] . ": ";
							
							if (!empty($blog['bookmark']['watch'])) {
								echo $lang['txt_marked'];
							}
							
							if (!empty($blog['bookmark']['watch']) && !empty($blog['bookmark']['recommend'])) {
								echo "&nbsp;&amp;&nbsp;";
							}
							
							if (!empty($blog['bookmark']['recommend'])) {
								echo $lang['txt_tipped'];
							}
							echo ", ";
						}
						?>
						<?php
						if ($blog['blog_create_datetime'] != $blog['blog_edit_datetime'] && !empty($blog['blog_edit_datetime'])) {
							echo $lang['txt_last_edited'] . ": ";
							echo $this->date->formatDate($blog['blog_edit_datetime'], 1) . ", ";
						}
						?>
						<?php echo $lang['txt_published_to'];?>: 
						<?php
						if (isset($blog['rsp'])) {
							foreach($blog['rsp'] as $key => $i):
								if (!empty($i['degree_id']) && $i['level_id'] == $rspconfig['rsp_level']['node']) {
									echo $lang['rsp']['rsp_level_degree'][$i['degree_id']];
								}
								else {
									echo trim($lang['rsp']['rsp_level'][$i['level_id']]);
								}
								echo " (" .$lang['rsp']['status'][$i['status_id']];
								
								if (!empty($i['rsp_featured'])) {
									echo " &amp; " .  $lang['txt_featured'];
								}
								
								echo ")";
								if ($key+1 < count($blog['rsp'])) {
									echo ", ";
								}
							endforeach;
						}
					?>
					<br />
					</p>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (!empty($blog['blog_allow_comments'])) {
					$unlocked = 1;
				}
					
				$hidden_form = array(
					"blog_id" => $blog['blog_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
					
				if (isset($group['group_id'])) {
					$hidden_form['group_id'] = $group['group_id'];
				}
				
				if (isset($blog['user_id'])) {
					$hidden_form['item_user_id'] = $blog['user_id'];
				}
				
				$comment_url = "blg_view.php?blog_id=" . $blog['blog_id'];
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($blogs)) { //list view
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
					echo "<p>" . $lang['txt_intro'] . "<br /></p>";
				}
				?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<?php
					$display_items = trimArray($blogs);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'], 1);?></a><br />
						</td>
						<td valign="top">
							<?php echo $i['blog_title'];?><br />
						</td>
						<td valign="top" align="right">
							<?php
							if (!empty($i['blog_allow_comments'])) {
							?>
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<?php }?>
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="3">
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($blogs);
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	elseif (isset($my_group_blogs)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_group_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_intro_group'];?><br />
				
				<?php
				if (!empty($my_group_blogs)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_group_blogs as $key => $g):
					if (!empty($g['blogs'])) {
					?>
					<tr>
						<td colspan="2">
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right" nowrap="nowrap">
							<a href="blg_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_blog'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['blogs'] as $key => $i):
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'], 1);?></a><br />
							<?php echo $i['blog_title'];?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="3">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$group_no_blog_list[] = $g;
					}
					endforeach;
					?>
					
				</table>
				<?php }?>
				
				<?php
				if (!empty($group_no_blog_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_group'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($group_no_blog_list as $key => $g):
					?>
					<tr>
						<td>
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right">
							<a href="blg_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_blog'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($my_network_blogs)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_network_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_intro_network'];?><br />
				</p>
				
				<?php
				if (!empty($my_network_blogs)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_network_blogs as $key => $g):
					if (!empty($g['blogs'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="blg_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_blog'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['blogs'] as $key => $i):
					?>
					<tr>
						<td width="32" rowspan="2">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'], 1);?></a><br />
							<?php echo $i['blog_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
						<td>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$network_no_blog_list[] = $g;
					}
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (!empty($network_no_blog_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_network'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($network_no_blog_list as $key => $g):
					?>
					<tr>
						<td colspan="2">
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right" colspan="2">
							<a href="blg_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_blog'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($recommended_blogs)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
					echo "<p>" . $lang['txt_intro'] . "<br /></p>";
				}
				?>
				
				<?php
				if (!empty($recommended_blogs)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($recommended_blogs as $key => $g):
					if (!empty($g['blogs'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="blg_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_blog'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['blogs'] as $key => $i):
					?>
					<tr>
						<td width="32" rowspan="2">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'], 1);?></a><br />
							<?php echo $i['blog_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
						<td>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	else  { //error - no blogs
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blogs'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_blog'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<?php
	if (isset($blogs) && isset ($profile)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blog_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $profile['profile_nic'];?></b><br />
				</p>
				
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($blogs) && isset ($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blog_group_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
				</p>
				
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $group['group_from_age'];
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $group['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $lang['txt_view'];?></b><br />
				</p>
				
				<?php
				if (isset($view) && $view == "node") {
				?>
				<?php echo $lang['href_view_node'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=node"><?php echo $lang['href_view_node'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($me['user_id'])) {
				?>
				
				<?php
				if (isset($view) && $view == "my_network") {
				?>
				<?php echo $lang['href_view_network'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=my_network"><?php echo $lang['href_view_network'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_groups") {
				?>
				<?php echo $lang['href_view_my_groups'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=my_groups"><?php echo $lang['href_view_my_groups'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_blog") {
				?>
				<?php echo $lang['href_my_blog'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=my_blog"><?php echo $lang['href_my_blog'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "marked_blog_entries") {
				?>
				<?php echo $lang['href_marked'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=marked_blog_entries"><?php echo $lang['href_marked'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "tipped_blog_entries") {
				?>
				<?php echo $lang['href_tipped'];?><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?view=tipped_blog_entries"><?php echo $lang['href_tipped'];?></a><br />
				<?php }?>
				
				
				<?php }?>
				<?php
				if (isset($blog)) {
				if (isset($group)) {
				?>
				<a href="blg_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_list_blog'];?></a><br />
				<?php
				}
				else {
				?>
				<a href="blg_view.php?user_id=<?php echo $blog['user_id'];?>"><?php echo $lang['href_list_blog'];?></a><br />
				<?php }}?>
				
				<?php
				if (isset($group) || isset($view) && $view == "my_blog") {
				?>
				<p>
					<b><?php echo $lang['txt_options'];?></b><br />
				</p>
				
					<?php
					if (isset($view) && $view == "my_blog" && $this->user_acs->checkPermission($resource_ids['node']['blog'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="blg_edit.php"><?php echo $lang['href_add_blog'];?></a><br />
					<?php }?>
					
					<?php
					if (isset($group)) {
					if ($this->group_acs->checkPermission($resource_ids['group']['blog'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="blg_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_group_add_blog'];?></a><br />
					<?php }}?>
				<?php }?>
				
				<?php
				if (isset($blog)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
					
					<p>
					<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if (isset($me['user_id']) && $i['user_id'] == $me['user_id']) {
								$tags .= "*";
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
					
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['blog'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
				
				<form action="blg_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="blog_id" value="<?php if(isset($blog['blog_id'])) { echo $blog['blog_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
				<p>
					<input width="30" class="input" name="tags" value="<?php echo $tags;?>" />
					<input type="image" name="update_tag" src="<?php echo $templatePath;?>img/go.png" value="1" class="go" /><br />
				</p>
				
				<?php }?>
				<?php }?>
				</form>
				
				<p>
					<h3><?php echo $lang['hdr_search'];?></h3>
				</p>
				
				<form action="search.php" method="post" name="search" id="id_search">
				<input type="hidden" name="search_type" value="blog" />
				
				<p>
					<input type="text" class="input" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				</form>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if (isset($blog) || isset($sidebar_blogs)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_blog_entry'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($blog['image']['file'])) {
				?>
				<img src="get_file.php?file=<?php echo $blog['image']['file'];?>" border="0" alt="<?php echo $blog['image']['file_title'];?>" /><br />
				<?php }?>
				
				<p>
					<b>
					<?php
					if (isset($group)) {
					?>
						<?php echo $lang['hdr_group_blog'];?>
					<?php
					}
					else {
					?>
						<?php echo $lang['hdr_blog'];?>
					<?php }?>
					</b><br />
				</p>
				
				<?php 
				if (isset($sidebar_blogs)) {
					foreach($sidebar_blogs as $key => $i):
					if (!isset($blog) || isset($blog) && $blog['blog_id'] != $i['blog_id']) {
					?>
					<p>
						<?php echo $i['blog_title'];?><br />
						<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a> 
						<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
						<br />
					</p>
					<?php
					}
					endforeach;
					?>
					<p>
						<?php
						if (isset($blog)) {
						if (isset($group)) {
						?>
						<a href="blg_view.php?group_id=<?php echo $group['group_id'];?>"><img src="<?php echo $templatePath;?>img/go.png" class="go" /></a><br />
						<?php
						}
						else {
						?>
						<a href="blg_view.php?user_id=<?php echo $blog['user_id'];?>"><img src="<?php echo $templatePath;?>img/go.png" class="go" /></a><br />
						<?php }}?>
					</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($rss_my_blogs)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_rss_my_blog'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php 
				foreach($rss_my_blogs as $key => $i):
				?>
				<p>
					<b><?php echo $i['channel_title'];?></b><br />
				</p>
				<?php
				if (!empty($i['feed']['items'])) {
				foreach($i['feed']['items'] as $item):
				?>
				<p>
					<?php
					echo "<a href='" . $item['link'] . "' target='_new'>". dots(56, $item['title']) ."</a><br />";
					?>
				</p>
				<?php
				endforeach;
				}
				endforeach;
				?>
				<p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($rss_read_blogs)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_rss_read_blog'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php 
				foreach($rss_read_blogs as $key => $i):
				?>
				<p>
					<b><?php echo $i['channel_title'];?></b><br />
				</p>
				<?php
				if (!empty($i['feed']['items'])) {
				foreach($i['feed']['items'] as $item):
				?>
				<p>
					<?php
					echo "<a href='" . $item['link'] . "' target='_new'>". dots(56, $item['title']) ."</a><br />";
					?>
				</p>
				<?php
				endforeach;
				}
				endforeach;
				?>
				<p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
