<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Tie {



	// the constructor ---------------------------------------------------
	// Sebastian Oblom, 3rd November 2006
	//
	function Tie($db, $core_config) {
		$this->db = $db;
		$this->core_config = $core_config;
	}//EO Tie



	// selWeakTies -------------------------------------------------------
	// returns a list of a users weak ties, including number of weak ties
	// Sebastian Oblom, 3rd November 2006
	//
	function selWeakTies($identity_id) {
		$query = "
			SELECT DISTINCT t1.identity_id, count(*) AS count_ 
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON (t2.identity_id=" . $identity_id . " AND t1.item_id=t2.item_id AND t1.module_id=t2.module_id) 
			WHERE t1.identity_id !=" . $identity_id . " GROUP BY t1.identity_id ORDER BY count(*) DESC"
		;
// 		echo $query; exit;
		$result = $this->db->Execute($query);
		$temp = array();
		
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		return $temp;
	}//EO selWeakTies
	
	
	
	// selStrongTies ----------------------------------------------------------------
	// returns a list of strong ties including the number of strong ties
	// Sebastian Oblom, 3rd November 2006
	//
	function selStrongTies($identity_id) {
		$query = "
			SELECT t1.identity_id_relation AS identity_id, count(*) AS count_ 
			FROM " . $this->db->prefix . "_relation AS t1 
			INNER JOIN " . $this->db->prefix . "_relation AS t2 
			ON t1.identity_id=t2.identity_id_relation AND t1.identity_id_relation=t2.identity_id 
			AND t1.module_id=t2.module_id AND t1.item_id=t2.item_id
			WHERE t1.identity_id=" . $identity_id . " AND t1.identity_id_relation != " . $identity_id . " 
			GROUP BY t1.identity_id_relation ORDER BY count(*) DESC"
		;
		
		$result = $this->db->Execute($query);
		$temp = array();
//   echo $query; exit;
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		return $temp;
	}//EO selStrongTies
	
	
	
	// countWeakTies -----------------------------------------------------------------
	// returns the number of weak ties between 2 users
	// Sebastian Oblom, 3rd November 2006
	//
	function countWeakTies($identity_id, $identity_id_relation) {
		$query = "
			SELECT count(*) AS total
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON t2.identity_id = " . $identity_id . "
			WHERE t1.identity_id = " . $identity_id_relation . "
			AND t1.item_id = t2.item_id 
			AND t1.module_id = t2.module_id"
		;
		
		$result = $this->db->Execute($query);
		$temp = array();
// echo $query; exit;
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields['total']);
				$result->moveNext();
			}
			$result->Close();
		}
		return $temp[0];
	}//EO countWeakTies
	
	
	
	// countStrongTies ----------------------------------------------------------
	// returns the number of strong ties between 2 users
	// Sebastian Oblom, 3rd November 2006
	//
	function countStrongTies($identity_id, $identity_id_relation) {
		$query = "
			SELECT count(*) AS total 
			FROM " . $this->db->prefix . "_relation AS t1 
			INNER JOIN am_relation AS t2 ON t1.identity_id=t2.identity_id_relation 
			AND t1.identity_id_relation=t2.identity_id AND t1.module_id=t2.module_id 
			AND t1.item_id=t2.item_id 
			WHERE t1.identity_id=" . $identity_id . " AND t1.identity_id_relation=" . $identity_id_relation . ""
		;
  //echo $query; exit;
		$result = $this->db->Execute($query);
		$temp = array();
		
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields['total']);
				$result->moveNext();
			}
			$result->Close();
		}
		return $temp[0];
	}//EO countStrongTies
	
	
	
	// selWeakTiePaths -----------------------------------------------------------------------
	// returns the weakest paths from 2 users (identity-level)
	// Sebastian Oblom, 6th November 2006
	//
	function selWeakTiePaths($identity_id, $identity_id_relation, $mode, $limit = null) {
		
		$relations = array();
		$ties = array();
		$counter = 0;
		$i = 1;
		
		if ($mode == 'outbound') {
			$key_vars   = array('me', 'you');
			$key_change = array(0, 1);
		}
		else {
			$key_vars   = array('you', 'me');
			$key_change = array(1, 0);
		}
		
		$relations['me']  = $this->selWeakTies($identity_id);
		$relations['you']  = $this->selWeakTies($identity_id_relation);
		$arr = $this->_intersection($relations[$key_vars[0]], $relations[$key_vars[1]]);

		foreach($arr[0] as $key => $r) {
 			$ties[$i]['from']         = $identity_id;
 			$ties[$i]['to']           = $r;
 			$ties[$i+1]['from']         = $r;
   			$ties[$i+1]['to']           = $identity_id_relation;
   			$ties[$i+$key_change[0]]['count_weak']   = $relations[$key_vars[0]][$key]['count_'];
   			
   			if (isset($this->count_strong)) {
   				$ties[$i+$key_change[0]]['count_strong'] = $this->countStrongTies($ties[$i+$key_change[0]]['from'], $ties[$i+$key_change[0]]['to']);
   			}
   			
   			foreach($arr[1] as $rekey => $s) {
				if ($r == $s) {
					$ties[$i+$key_change[1]]['count_weak']   = $relations[$key_vars[1]][$rekey]['count_'];
					
					if (isset($this->count_strong)) {
   						$ties[$i+$key_change[1]]['count_strong'] = $this->countStrongTies($ties[$i+$key_change[1]]['from'], $ties[$i+$key_change[1]]['to']);
   					}
					break;
				}
			}
			$i += 2;
 			
 			if (isset($limit)) {
 				if ($i > $limit * 2) {
 					break;
 				}
 			}
 		}
 		return $ties;
	}//EO selWeakTiePaths
	
	
	
	// selStrongTiePaths --------------------------------------------------------------------
	// returns the strongest paths from 2 users (identity-level)
	// Sebastian Oblom, 6th November 2006
	//
	function selStrongTiePaths($identity_id, $identity_id_relation,$mode, $limit = null) {
		
		$relations = array();
		$ties = array();
		$counter = 0;
		$i = 1;
		
		if ($mode == 'outbound') {
			$key_vars   = array('me', 'you');
			$key_change = array(0, 1);
		}
		else {
			$key_vars   = array('you', 'me');
			$key_change = array(1, 0);
		}
		
		$relations['me']  = $this->selStrongTies($identity_id);
		$relations['you']  = $this->selStrongTies($identity_id_relation);
		$arr = $this->_intersection($relations[$key_vars[0]], $relations[$key_vars[1]]);

		foreach($arr[0] as $key => $r) {
 			$ties[$i]['from']         = $identity_id;
 			$ties[$i]['to']           = $r;
 			$ties[$i+1]['from']         = $r;
   			$ties[$i+1]['to']           = $identity_id_relation;
   			$ties[$i+$key_change[0]]['count_strong']   = $relations[$key_vars[0]][$key]['count_'];
   			
   			if (isset($this->count_weak)) {
   				$ties[$i+$key_change[0]]['count_weak'] = $this->countWeakTies($ties[$i+$key_change[0]]['from'], $ties[$i+$key_change[0]]['to']);
   			}
   			
   			foreach($arr[1] as $rekey => $s) {
				if ($r == $s) {
					$ties[$i+$key_change[1]]['count_strong']   = $relations[$key_vars[1]][$rekey]['count_'];
					
					if (isset($this->count_weak)) {
   						$ties[$i+$key_change[1]]['count_weak'] = $this->countWeakTies($ties[$i+$key_change[1]]['from'], $ties[$i+$key_change[1]]['to']);
   					}
					
					break;
				}
				
			}
			$i += 2;
 			
 			if (isset($limit)) {
 				if ($i > $limit * 2) {
 					break;
 				}
 			}
 		}
 		return $ties;
	}//EO selStrongTiePaths
	


	// selStrongToWeakTiePaths ----------------------------------------------------------------
	// returns the strong-weak paths from 2 users
	// Sebastian Oblom, 6th November 2006
	//
	function selStrongToWeakTiePaths($identity_id, $identity_id_relation, $limit = null) {
		
		$relations = array();
		$ties = array();
		$counter = 0;
		$i = 1;
		
		$relations['me']  = $this->selStrongTies($identity_id);
		$relations['you']  = $this->selWeakTies($identity_id_relation);
		$arr = $this->_intersection($relations['me'], $relations['you']);
		
		foreach($arr[0] as $key => $r) {
 			$ties[$i]['from']         = $identity_id;
 			$ties[$i]['to']           = $r;
 			$ties[$i+1]['from']         = $r;
   			$ties[$i+1]['to']           = $identity_id_relation;
   			$ties[$i]['count_strong']   = $relations['me'][$key]['count_'];
   			$ties[$i]['count_weak'] = $this->countWeakTies($identity_id, $r);
   			
   			foreach($arr[1] as $rekey => $s) {
				if ($r == $s) {
					$ties[$i+1]['count_weak']   = $relations['you'][$rekey]['count_'];
					$ties[$i+1]['count_strong'] = $this->countStrongTies($r, $identity_id_relation);	
					break;
				}
				
			}
			$i += 2;
 			
 			if (isset($limit)) {
 				if ($i > $limit * 2) {
 					break;
 				}
 			}
 		}
 		return $ties;
	}//EO selStrongToWeakTiePaths
	
	
	
	// selWeakToStrongTiePaths ---------------------------------------------------------------
	// returns the weak-to-strong paths for 2 users
	// Sebastian Oblom, 6th November 2006
	//
	function selWeakToStrongTiePaths($identity_id, $identity_id_relation, $limit = null) {
		$relations = array();
		$ties = array();
		$counter = 0;
		$i = 1;
		
		$relations['me']  = $this->selWeakTies($identity_id);
		$relations['you']  = $this->selStrongTies($identity_id_relation);
		$arr = $this->_intersection($relations['me'], $relations['you']);
		
		foreach($arr[0] as $key => $r) {
 			$ties[$i]['from']         = $identity_id;
 			$ties[$i]['to']           = $r;
 			$ties[$i+1]['from']         = $r;
   			$ties[$i+1]['to']           = $identity_id_relation;
   			$ties[$i]['count_weak']   = $relations['me'][$key]['count_'];
   			$ties[$i]['count_strong'] = $this->countStrongTies($identity_id, $r);
   			
   			foreach($arr[1] as $rekey => $s) {
				if ($r == $s) {
					$ties[$i+1]['count_strong']   = $relations['you'][$rekey]['count_'];
					$ties[$i+1]['count_weak'] = $this->countWeakTies($r, $identity_id_relation);	
					break;
				}
				
			}
			$i += 2;
 			
 			if (isset($limit)) {
 				if ($i > $limit * 2) {
 					break;
 				}
 			}
 		}
 		return $ties;
	}//EO selWeakToStrongTiePaths
	
	
	
	// selCommonTies ------------------------------------------------------------
	// returns an array of common ties of 2 users
	// Sebastian Oblom, 6th November 2006
	//
	function selCommonTies($identity_id, $identity_id_relation) {
		$query = "
			SELECT t1.item_id, t1.module_id 
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON (t2.identity_id=" . $identity_id . " AND t1.item_id=t2.item_id AND t1.module_id=t2.module_id) 
			WHERE t1.identity_id =" . $identity_id_relation . ""
		;
		
		$result = $this->db->Execute($query);
		$temp = array('weak' => array(), 'strong' => array());
// 		echo $query;exit;
		if (isset($result->fields)) {
			while(!$result->EOF) {
				array_push($temp['weak'], $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}

		$query = "
			SELECT t1.item_id, t1.module_id 
			FROM " . $this->db->prefix . "_relation AS t1 
			INNER JOIN am_relation AS t2 ON t1.identity_id=t2.identity_id_relation 
			AND t1.identity_id_relation=t2.identity_id AND t1.module_id=t2.module_id 
			AND t1.item_id=t2.item_id 
			WHERE t1.identity_id=" . $identity_id . " AND t1.identity_id_relation=" . $identity_id_relation . ""
		;
			
		$result = $this->db->Execute($query);

//  		echo $query;exit;
		if (isset($result->fields)) {
			while(!$result->EOF) {
				array_push($temp['strong'], $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		
		$temp['count_weak']   = count($temp['weak']);
		$temp['count_strong'] = count($temp['strong']);
		return $temp;
		
	}//EO selCommonTies
	
	
	
	// _intersection ------------------------------------------------------------------------
	// help-function for sel[*]TiePaths
	// Sebastian Oblom, 3rd November 2006
	//
	function _intersection($me, $you) {
		
		$tmp1 = array();	
		foreach($me as $r) {
			array_push($tmp1, $r['identity_id']);
		}
			
		$tmp2 = array();
		foreach($you as $r) {
			array_push($tmp2, $r['identity_id']);
		}
			
		$tmp1 = array_intersect($tmp1, $tmp2);
		$tmp2 = array_intersect($tmp2, $tmp1);
		
		return array($tmp1, $tmp2);
	}//EO _intersection



	// selItem -------------------------------------------------------------------
	// selects an item (title and vars to construct a link from the databas)
	// Sebastian Oblom, 9th November 2006
	//
	function selItem($module_id, $item_id) {
	
		$long  = $this->core_config['module'][$module_id]['db_tbl'];
		$short = $this->core_config['module'][$module_id]['prefix'];
		$table = $this->db->prefix . '_' . $long;
		
		$query = "
			SELECT i.*
			FROM " . $table . " i
			WHERE i." . $long . "_id=" . $item_id
		;
		
		$result = $this->db->Execute($query);
		$temp = array();

		if (isset($result->fields)) {
			while(!$result->EOF) {
				$result->fields['subject']   = $result->fields[$long . '_title'];
				$result->fields['module_id'] = $module_id;
				$result->fields['item_id']   = $item_id;
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		if (isset($temp[0])) {
			return $temp[0];
		}
		else {
			return array();
		}
	}//EO selItem
	
	
	
	// isMutual --------------------------------------------------------------------
	// does the user_id have a relationship with the relation?
	// tom calthrop - 1st November 2006
	//
	function isMutual($identity_id, $identity_id_relation) {
		
		$query = "
			SELECT identity_id 
			FROM " . $this->db->prefix . "_relation  
			WHERE 
			module_id=" . $this->module_id . " AND 
			item_id=" . $this->item_id . " AND 
			identity_id=" . $identity_id . " AND 
			identity_id_relation=" . $identity_id_relation
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields) && isset($result->fields['identity_id'])) {
			return true;
		}
		else {
			return false;
		}	
	} // EO isMutual
	
	
	
	
	// deletePortable --------------------------------------------------------------------
	// remove all portable setting for a user
	// tom calthrop - 1st November 2006
	//
	function deletePortable($identity_id) {
		$query = "UPDATE " . $this->db->prefix . "_relation SET relation_portable=null WHERE identity_id=" . $identity_id;
		
		$result = $this->db->Execute($query);
	} // EO deletePortable
	
	
	
	
	// setPortable --------------------------------------------------------------------
	// set a relationship as portable
	// tom calthrop - 1st November 2006
	//
	function setPortable($identity_id, $identity_id_relation) {
		$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_relation  
			WHERE 
			identity_id=" . $identity_id . " AND 
			identity_id_relation=" . $identity_id_relation . " AND 
			module_id=" . $this->module_id . " AND 
			item_id=" . $this->item_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
		
			$rec = array();
			$rec['relation_portable'] = 1;
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
		}
		
	} // EO setPortable
	
	
	// selRelation --------------------------------------------------------------------
	// select the user_id having a relationship with the relation
	// tom calthrop - 25th November 2006
	//
	function selRelation($identity_id, $identity_id_relation) {
		
		$query = "
			SELECT identity_id 
			FROM " . $this->db->prefix . "_relation  
			WHERE 
			module_id=" . $this->module_id . " AND 
			item_id=" . $this->item_id . " AND 
			identity_id=" . $identity_id . " AND 
			identity_id_relation=" . $identity_id_relation
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			return $result->fields;
		}
	} // EO selRelation
	
	
	// insertRelation --------------------------------------------------------------------
	// inserts a single relation record
	// tom calthrop - 24th October 2006
	//
	function insertRelation($data) {
		
		$rec = array();
		$rec['module_id'] = $this->module_id;
		$rec['item_id'] = $this->item_id;
		$rec['identity_id'] = $data['identity_id'];
		$rec['identity_id_relation'] = $data['identity_id_relation'];
		$rec['relation_create_datetime'] = time();
		$rec['user_id'] = $this->user_id;
		
		$table = $this->db->prefix . "_relation";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	
	} //EO insertRelation

}

?>