<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

if (isset($_POST['reply_message'])) {
	header("Location: index.php?amn=core_msg_edit&message_id=" . $_POST['message_id'] . "&reply=1&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['delete_message'])) {
	$_POST['message_ids'][] = $_POST['message_id'];
	
	$im->deleteMessages($_POST['message_ids']);
	header("Location: index.php?amn=core_msg_view&". $_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['message_id'])) {
	$output_message = $im->selMessage($_REQUEST['message_id']);
	$im->setMessagesStatus($_REQUEST['message_id'], $core_config['messaging']['status']['read']);
}


require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->module_id = 0; // core
$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
$user->file = $file;


if (!empty($output_message)) {
	require_once ('class/Wiki/Wiki.php');
	require_once ('class/Wiki/Wiki/Parse.php');
	require_once ('class/Wiki/Wiki/Render.php');
	$wiki = new Text_Wiki();
	$wiki->disableRule('freelink');
	$wiki->disableRule('wikilink');
	$wiki->setRenderConf('xhtml', 'image', 'base', "get_file.php?file=");
	
	if ($user->selUserPreference($_SESSION['user_id'], $core_config['user']['preference']['use_new_window'])) {
		$wiki->setRenderConf('xhtml', 'url', 'target', '_blank');
	}
	
	$output_message['message_body'] = $wiki->transform($output_message['message_body'], 'Xhtml');
	
	$body->set('message', $output_message);
	
	$output_identity = $user->selUserIdentity(null, $output_message['from_identity_id']);
	
	if (!empty($output_identity)) {
		$body->set('identity', $output_identity);
	}
	
}
else {
	header("Location: index.php?amn=core_msg_list&" . strip_tags(SID));
	exit;
}


?>