<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<div class="col_main">
	
	<?php if (isset($announcement)) { ?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($announcement['announce_create_datetime'],1); ?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<p class="txt_item_title">
					<?php echo $announcement['announce_title']; ?><br />
				</p>
				
				<p>
					<?php echo $announcement['announce_body']; ?>
				
				</p>
				
				<p class="metadata">
					<?php echo $lang['txt_announce_by']; ?>: 
					<a href="index.php?amn=core_sn_profile&amp;user_id=<?php echo $announcement['user_id'];?>"><?php echo $announcement['identity_nic'];?></a>
									
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php } ?>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<b><?php echo $lang['hdr_latest_announce']; ?></b><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<p>
				<?php if (isset($announcements)) { ?>
					<?php foreach($announcements as $a): ?>
						<?php if (isset($_REQUEST['announce_id']) && $_REQUEST['announce_id'] == $a['announce_id']) { ?>
							<?php echo $a['announce_title']; ?><br />
						<?php } else { ?>
							<a href="index.php?amn=core_ann_view&amp;announce_id=<?php echo $a['announce_id']; ?>"><?php echo $a['announce_title']; ?></a><br />
						<?php } ?>
					<?php endforeach; ?>
				<?php } ?>
				</p>
				
				<p align="right">
					<a href="index.php?amn=core_ann_list"><?php echo $lang['href_all_ann']; ?></a>
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>