<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Bookmark {



	// Bookmark --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 25th Jan 2004
	//
	function Bookmark($db, $module_id = null, $item_id = null) {
		$this->db = $db;
		$this->module_id = $module_id;
		$this->item_id = $item_id;
	}



	// selBookmarks --------------------------------------------------------------------
	// returns multiple rows from the DB
	// the library needs the name and not the id, hence the $return_names var is set to 1 for names
	// tom calthrop - 25th Jan 2004
	//
	function selBookmarks($full = null, $meta=null) {
		if (isset($meta)) {
			// used for tag clouds
			$query = "
				SELECT count(user_id) as total, item_id, inner_item_id "
			;
		}
		elseif (isset($full)) {
			$query = "
				SELECT user_id, item_id, inner_item_id, bookmark_notify, bookmark_alarm_datetime, module_id "
			;
		}
		else {
			$query = "
				SELECT item_id "
			;
		}
		
		$query .= "
			FROM " . $this->db->prefix . "_bookmark
			WHERE "
		;
		
		if (!empty($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($this->bookmark_type)) {
		    $query .= "bookmark_type=" . $this->bookmark_type . " and ";
		}

		if (isset($this->module_ids)) {
			$query .= "module_id in (" . $this->module_ids . ") AND ";
		}
		elseif (isset($this->module_id)) {
			$query .= "module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($this->inner_item_id)) {
			$query .= "inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($meta)) {
			$query .= "GROUP BY item_id, inner_item_id order by total desc";
		}
		elseif (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				if (isset($full)) {
					array_push($temp, $result->fields);
				}
				else {
					array_push($temp, $result->fields['item_id']);
				}
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selBookmarks class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selBookmarks



	// selBookmark --------------------------------------------------------------------
	// sels the bookmark (returns true if found)
	// tom calthrop - 11th December 2004
	//
	function selBookmark($full = null) {
		
		if (isset($full)) {
			$query = "
				SELECT user_id, item_id, bookmark_notify, bookmark_alarm_datetime "
			;
		}
		else {
			$query = "
				SELECT user_id "
			;
		}
		
		$query .= "
			FROM " . $this->db->prefix . "_bookmark
			WHERE
			user_id=" . $this->user_id . " AND
			module_id=" . $this->module_id . " AND
			bookmark_type=" . $this->bookmark_type . " AND
			item_id=" . $this->item_id . " AND "
		;
		
		
		
		if (isset($this->inner_item_id)) {
			$query .= "inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($full)) {
			return $result->fields;
		}
		elseif (isset($result->fields['user_id'])) {
			return true;
		}
		else {
			return false;
		}
	} //EO selBookmark



	// insertBookmark --------------------------------------------------------------------
	// inserts the bookmark
	// tom calthrop - 11th December 2004
	//
	function insertBookmark($notify = null) {
		
		$rec = array();
		$rec['item_id'] = $this->item_id;
		
		if (isset($this->inner_item_id)) {
			$rec['inner_item_id'] = $this->inner_item_id;
		}
		
		$rec['module_id'] = $this->module_id;
		$rec['bookmark_type'] = $this->bookmark_type;
		$rec['user_id'] = $this->user_id;
		$rec['bookmark_lastview_datetime'] = time();
		
		if (isset($notify)) {
			$rec['bookmark_notify'] = 1;
		}
		
		$table = $this->db->prefix . "_bookmark";
		
		$query = $this->db->getInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "method=insertBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO insertBookmark



	// updateBookmark --------------------------------------------------------------------
	// updates the bookmark_lastview_datetime
	// tom calthrop - 11th December 2004
	//
	function updateBookmark($data=null) {
		$query = "
			SELECT * FROM " . $this->db->prefix . "_bookmark 
			WHERE 
			module_id=" . $this->module_id . " AND
			bookmark_type=" . $this->bookmark_type . " AND
			user_id=" . $this->user_id . " AND
			item_id=" . $this->item_id
		;
		
		if (isset($this->inner_item_id)) {
			$query .= " AND inner_item_id=" . $this->inner_item_id;
		}
		
		$result = $this->db->Execute($query);
		
		if (!empty($result)) {
			$rec = array();
			
			if (isset($data)) {
				if (!empty($data['bookmark_notify'])) {
					$rec['bookmark_notify'] = 1;
				}
				else {
					$rec['bookmark_notify'] = "null";
					$rec['bookmark_batch_request'] = "null";
				}
			}
			else {
				$rec['bookmark_lastview_datetime'] = time();
			}
			
			$query = $this->db->getUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result1 = $this->db->Execute($query);
			
			if (empty($result1)) {
				$error_info = "method=updateBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
		}
	} //EO updateBookmark



	// deleteBookmark --------------------------------------------------------------------
	// deletes a bookmark
	// tom calthrop - 11th December 2004
	//
	function deleteBookmark() {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_bookmark
			WHERE
			module_id=" . $this->module_id . " AND 
			bookmark_type=" . $this->bookmark_type . " AND
			user_id=" . $this->user_id . " AND
			item_id=" . $this->item_id . " AND
			inner_item_id=" . $this->inner_item_id
		;
		
		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "method=deleteBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO deleteBookmark


	// selBookmarkLastViewDate --------------------------------------------------------------------
	// sels the bookmarks last view date
	// tom calthrop - 11th December 2004
	//
	function selBookmarkLastViewDate($item_id = null) {

		if (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}

		$query = "
			SELECT bookmark_lastview_datetime
			FROM " . $this->db->prefix . "_bookmark
			WHERE
			user_id=" . $this->user_id . " and
			bookmark_type=" . $this->bookmark_type . " and
			module_id=" . $this->module_id . " and
			item_id=" . $item_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields['bookmark_lastview_datetime'])) {
			return $result->fields['bookmark_lastview_datetime'];
		}
		else {
			return false;
		}
	} //EO selBookmarkLastViewDate



	// updateBookmarkNotification --------------------------------------------------------------------
	// updates the bookmark Notification
	// tom calthrop - 20th February 2006
	//
	function updateBookmarkNotification($item_id, $notification=null) {
		$query = "
			SELECT * FROM " . $this->db->prefix . "_bookmark 
			WHERE 
			module_id=" . $this->module_id . " and
			bookmark_type=" . $this->bookmark_type . " and
			bookmark_notify=1 and
			item_id=" . $item_id
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		
		if (!empty($notification)) {
				$rec['bookmark_batch_request'] = 1;
		}
		else {
			$rec['bookmark_batch_request'] = "null";
		}
		
		$query = $this->db->selUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result1 = $this->db->Execute($query);
		
		if (empty($result1)) {
			$error_info = "function=updateBookmarkNotification class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO updateBookmarkNotification

}
?>
