<?php

/**
* 
* Parses for <div> tags.
* 
* @category Text
* 
* @package Text_Wiki
* 
* @author Tom Calthrop, Barnraiser (info@barnraiser.org)
* 
* @license GPL
* 
* @version $Id: Div.php,v 1.0 3rd October 2006
* 
*/

class Text_Wiki_Parse_Div extends Text_Wiki_Parse {
    
    
    /**
    * 
    * The regular expression used to parse the source text and find
    * matches conforming to this rule.  Used by the parse() method.
    * 
    * @access public
    * 
    * @var string
    * 
    * @see parse()
    * 
    */
    var $regex = '/^(\<block( .+)?\>)\n(.+)\n(\<\/block\>)(\s|$)/Umsi';
    /**
    * 
    * Generates a replacement for the matched text.  Token options are:
    * 
    * 'type' => ['start'|'end'] The starting or ending point of the
    * emphasized text.  The text itself is left in the source.
    * 
    * @access public
    *
    * @param array &$matches The array of matches from parse().
    *
    * @return A pair of delimited tokens to be used as a placeholder in
    * the source text surrounding the text to be emphasized.
    *
    */
   function process(&$matches) {
    
        $name = $matches[2];
        $text = $matches[3];
        
        $start = $this->wiki->addToken(
            $this->rule,
            array('type' => 'start', 'name' => $name)
        );
        
        $end = $this->wiki->addToken(
            $this->rule,
            array('type' => 'end', 'name' => $name)
        );
        
        // done, place the script output directly in the source
        return $start . trim($text) . $end;
    }
}
?>