<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// RELEASE NOTES --------------------------------------------------
$core_config['release']['version'] = 				"0.7.4";
$core_config['release']['release_date'] = 			"01-13-2007"; // MM-DD-YYYY
$core_config['release']['install_date'] = 			""; // MM-DD-YYYY


//DATABASE CONFIGURATION --------------------------------------------------
$core_config['db']['driver'] = 						"mysql";
$core_config['db']['host'] = 						"localhost";
$core_config['db']['user'] = 						"your_db_username";
$core_config['db']['pass'] = 						"your_db_password";
$core_config['db']['db']=	 						"your_db_name";
$core_config['db']['prefix'] =	 					"am";


// MAIL CONFIGURATION ---------------------------------------------------
// phpMailer. See http://phpmailer.sourceforge.net/ for settings.
$core_config['mail']['host'] = 						"your_mail_server.org";
$core_config['mail']['port'] = 						"25";
$core_config['mail']['no_reply_address'] = 			"noreply@your_mail.org";
$core_config['mail']['default_address'] = 			"you@your_mail.org";
$core_config['mail']['mailer'] = 					"smtp";
$core_config['mail']['from_name'] = 				"organisation_name";
$core_config['mail']['wordwrap'] = 					"80";
//if you need a username and password to access SMTP then uncomment these
// and add your username and password
//$core_config['mail']['smtp']['username'] = 		"your_mailserver_username";
//$core_config['mail']['smtp']['password'] = 		"your_mailserver_password";


// PHP CONFIGURATION -----------------------------------------------------
//ini_set('error_reporting', E_ALL); 				// error handling in development environment.
ini_set('error_reporting', 0); 						// error handling in production environment




// MODULE INCLUSION --------------------------------------------------------



// LANGUAGE CONFIGURATION ---------------------------------------------------
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$core_config['language']['default_id'] = 			1; //English, the default node language
$core_config['language']['pack'][1] = 				array('eng', 'en'); //UK (real) English /aspell lang
// if Aspell is installed you can configure AROUNDMe to show a spellchecker button
// standard aspell installs are either:
// WINDOWS -> '"C:\Program Files\Aspell\bin\aspell.exe"'(use the double quotes inside the single quotes)
// GNU/Linux -> "/usr/local/bin/aspell"
// Leave the variable blank "" to tell AROUNDMe NOT TO show shellchecker
$core_config['language']['aspell']['command'] = 	"/usr/bin/aspell";



// SYSTEM CONFIGURATION -----------------------------------------------
$core_config['template']['default_name'] = 			"barnraiser_01";
$core_config['template']['default_id'] = 			"1";
// PHP keeps data in a session. The session is called "PHPSESSID" as standard. If you 
// have more than one instance of this software you should create a unique session name.
// recomended is characters A-Z (uppercase),0-9 with no spaces. DO NOT use a dot (.).
$core_config['node']['php_session_name'] = 			"PHPSESSID";
//default home page (inserted in DB upon registration)
$core_config['node']['page_default'] = 				"core_msg_list";
// http path to scripts directory- only used by php when batch processing
$core_config['node']['url']['www_path'] = 			"http://www.your-domain.org/aroundme/";


// debug mode
// 0 = off // optimal choice
// 1 = basic page times at bottom of page
// 2 = full query and page times at bottom of page
$core_config['node']['debug_mode'] = 				"0";



// CORE PERMISSIONS ---------------------------------------------------
// binary number sequencing required!
// Bitmask based permissions system
// If you need help understanding bitwise operators try:
// http://www.litfuel.net/tutorials/bitwise.htm

// USER PERMISSIONS
// is able to access the membership maintainance
$core_config['resource']['user']['maintainer'] = 			1;
// is able to access permissions
$core_config['resource']['user']['permissions'] = 			2;
// is able to send internal announcements
$core_config['resource']['user']['int_announce'] = 			4;
// is able to send external (email) announcements
$core_config['resource']['user']['ext_announce'] = 			8;
// manages abuse reports
$core_config['resource']['user']['mng_contacts'] = 			16;
// can set a module item to be visible to only certain membership types
$core_config['resource']['user']['mem_visible'] = 			32;


// MODULE ACCESS PERMISSIONS


// INSTANCE PERMISSIONS
// set to '1' to allow registration on the site
$core_config['resource']['core']['allow_registration'] = 	1;

// DEFAULT VISITOR PERMISSIONS
$core_config['resource']['core']['user']['visitor'] = 		0;
$core_config['resource']['core']['module']['visitor']	=	0;

// DEFAULT REGISTRATION PERMISSIONS
$core_config['resource']['core']['user']['registry'] = 		0;
$core_config['resource']['core']['module']['registry']	=	0;

// DEFAULT ROLES AND MEMBERSHIP TYPES
$core_config['membership_type']['type']['honorary'] = 		1;
$core_config['membership_type']['type']['supporter'] = 		2;
$core_config['membership_type']['type']['builder'] = 		3;
$core_config['membership_type']['type']['volunteer'] = 		4;
$core_config['membership_type']['type']['sustainer'] = 		5;

$core_config['membership_type']['invite_default'] = 		4;

$core_config['role']['display']['structure'][1] = 			1;
$core_config['role']['display']['structure'][2] = 			2;
$core_config['role']['display']['structure'][3] = 			3;
$core_config['role']['display']['structure'][4] = 			4;


// MESSAGING CONFIGURATION -----------------------------------------
$core_config['messaging']['box']['in'] = 					"1";
$core_config['messaging']['box']['out'] = 					"2";

$core_config['messaging']['status']['unread'] = 			"1";
$core_config['messaging']['status']['read'] = 				"2";

$core_config['messaging']['priority']['urgent'] = 			"1";
$core_config['messaging']['priority']['normal'] = 			"2";
$core_config['messaging']['priority']['low'] = 				"3";

$core_config['messaging']['response']['reply_request'] = 	"1";
$core_config['messaging']['response']['no_reply_needed'] = 	"2";


// FILE CONFIGURATION ----------------------------------------------------
$core_config['file']['image']['max_height'] = 				400;
$core_config['file']['image']['max_width']  = 				500;

// MIME
//edit the functions.inc.php formatFileOutput functions to create correct html output
$core_config['file']['mime'][1]['mime'] = 					"image/jpeg";
$core_config['file']['mime'][2]['mime'] = 					"image/png";
$core_config['file']['mime'][3]['mime'] = 					"image/gif";
$core_config['file']['mime'][4]['mime'] = 					"application/pdf";
$core_config['file']['mime'][5]['mime'] = 					"text/plain";
//image and thumbs
$core_config['file']['dir'] =								"../asset/";
// default sizes, files

$core_config['file']['image']['thumb'][0]['height'] = 		200;
$core_config['file']['image']['thumb'][0]['width']  = 		178;
$core_config['file']['image']['thumb'][0]['suffix'] = 		"t1";
$core_config['file']['image']['thumb'][0]['no_image'] = 	"no_image_t1.png";

$core_config['file']['image']['thumb'][1]['height'] = 		70;
$core_config['file']['image']['thumb'][1]['width']  = 		90;
$core_config['file']['image']['thumb'][1]['suffix'] = 		"t2";
$core_config['file']['image']['thumb'][1]['no_image'] = 	"no_image_t2.png";

$core_config['file']['image']['thumb'][2]['height'] = 		32;
$core_config['file']['image']['thumb'][2]['width']  = 		32;
$core_config['file']['image']['thumb'][2]['suffix'] = 		"t3";
$core_config['file']['image']['thumb'][2]['no_image'] = 	"no_image_t3.png";

// allocation types
$core_config['file']['allocation']['type']['user'] = 			1;
$core_config['file']['allocation']['type']['message'] = 		2;

$core_config['file']['allocation']['default_user'] = 			"100000";
$core_config['file']['allocation']['default_message'] = 		"100000";



// USER CONFIGURATION --------------------------------------------------
// relationship type
$core_config['user']['relation_type']['approved'] = 			"2";
$core_config['user']['relation_type']['approval_pending'] = 	"1";
// user status (pending means they have registered but not setup)
$core_config['user']['status']['inactive'] = 					"1";
$core_config['user']['status']['hold'] = 						"2";
$core_config['user']['status']['pending'] = 					"3";
$core_config['user']['status']['active'] = 						"4";
$core_config['user']['status']['dormant'] = 					"5";
// user preferences
$core_config['user']['preference']['email_message'] = 			"1";
$core_config['user']['preference']['email_announcements'] = 	"2";
// identity
$core_config['user']['identity']['type']['public'] = 				"1";
$core_config['user']['identity']['type']['registered'] = 			"2";
// which identity custom fields are people allowed to search on
$core_config['user']['identity']['custom_searchable'] = 	array(5);

//RSS CONFIGURATION --------------------------------------------------------
// options: "RSS2.0" for RSS 2.0, "RSS1.0" for RSS 1.0, "RSS0.91" for
// RSS 0.91, "PIE0.1" for PIE 0.1, "MBOX" for Unix mbox, "OPML" for OPML
// 1.0, "ATOM0.3" for ATOM 0.3, "HTML" for HTML, "JAVASCRIPT" for Javascript
$core_config['rss']['output'] = 								"RSS2.0";
$core_config['rss']['channel_type']['my_blog'] = 				"1";
$core_config['rss']['channel_type']['read_blog'] = 				"2";


// DISPLAY CONFIGURATION ---------------------------------------------------
$core_config['display']['max_list_rows'] = 						"25";


// STATISTIC CONFIGURATION ----------------------------------------------
$core_config['statistic']['user']['total_logins'] = 			"1";
$core_config['statistic']['user']['total_comments'] = 			"2";


// TAG CONFIGURATION --------------------------------------------------------
$core_config['tag']['core']['network'] = 						"1";

// level - item level means item author can tag for search
$core_config['tag']['level']['item'] = 							"1";


// BOOKMARK CONFIGURATION --------------------------------------------------
$core_config['bookmark']['type']['watch'] = 					"1";
$core_config['bookmark']['type']['recommend'] = 				"2";


// RATING CONFIGURATION --------------------------------------------------
$core_config['rate']['type']['accurate'] = 						"1";
$core_config['rate']['type']['relevent'] = 						"2";

?>