<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Rate {

	// Rate --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd November 2006
	//
	function Rate($db, $module_id = null, $item_id = null) {
		$this->db = $db;
		$this->module_id = $module_id;
		$this->item_id = $item_id;
	}



	// deleteRating --------------------------------------------------------------------
	// deletes a rating
	// tom calthrop - 23rd November 2006
	//
	function deleteRating() {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_rate
			WHERE
			module_id=" . $this->module_id . " AND 
			rate_type=" . $this->rate_type . " AND
			user_id=" . $this->user_id . " AND
			item_id=" . $this->item_id
		;
		
		if (isset($this->inner_item_id)) {
			$query .= " AND inner_item_id=" . $this->inner_item_id;
		}
		
		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "method=deleteRating class=Rate.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO deleteRating



	// insertRating --------------------------------------------------------------------
	// inserts the bookmark
	// tom calthrop - 23rd November 2006
	//
	function insertRating($value=null) {
		
		if (!isset($value) || $value < 1) {
			$value = 0;
		}
		
		$rec = array();
		$rec['item_id'] = $this->item_id;
		$rec['module_id'] = $this->module_id;
		$rec['rate_type'] = $this->rate_type;
		$rec['user_id'] = $this->user_id;
		$rec['rate_value'] = $value;
		
		
		if (isset($this->inner_item_id)) {
			$rec['inner_item_id'] = $this->inner_item_id;
		}
		
		$table = $this->db->prefix . "_rate";
		
		$query = $this->db->getInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "method=insertRating class=Rate.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO insertRating



	// selRating --------------------------------------------------------------------
	// selects a single rating
	// tom calthrop - 23rd November 2006
	//
	function selRating($meta=null) {
		if (isset($meta)) {
			// used for tag clouds
			$query = "
				SELECT count(rate_value) as total, item_id, inner_item_id 
				FROM " . $this->db->prefix . "_rate 
				WHERE "
			;
		}
		else {
			$query = "
				SELECT rate_type, rate_value 
				FROM " . $this->db->prefix . "_rate
				WHERE "
			;
		}
		
		
		if (!empty($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->rate_type)) {
		    $query .= "rate_type=" . $this->rate_type . " AND ";
		}

		if (isset($this->module_id)) {
			$query .= "module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($this->inner_item_id)) {
			$query .= "inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($meta)) {
			$query .= "GROUP BY item_id, inner_item_id order by total desc";
			
		}
		elseif (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selRating class=Rate.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selRating



	// countRating --------------------------------------------------------------------
	// selects a single rating
	// tom calthrop - 23rd November 2006
	//
	function countRating($value=null) {
		$query = "
			SELECT count(user_id) as total 
			FROM " . $this->db->prefix . "_rate
			WHERE 
			"
		;
		
		if (isset($value)) {
		    $query .= "rate_value=" . $value . " AND ";
		}
		
		if (!empty($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->rate_type)) {
		    $query .= "rate_type=" . $this->rate_type . " AND ";
		}
		
		if (isset($this->module_id)) {
			$query .= "module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
			$query .= "item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($this->inner_item_id)) {
			$query .= "inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
		}
	}//EO countRating
}
?>
