<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



// trimArray ---------------------------------------------------------------
// cuts an array down (used in lists)
// tom calthrop - 07 November 2005
//
function trimArray($arr) {
	
	global $core_config;
	
	if (count($arr) > $core_config['display']['max_list_rows']) {
		if (!isset($_REQUEST['_frm'])) {
			$_REQUEST['_frm'] = 0;
		}
		$new_arr = array_slice($arr, $_REQUEST['_frm'], $core_config['display']['max_list_rows']);
	}
	else {
		$new_arr = $arr;
	}
	
	return $new_arr;
}

// createArrayList ----------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function createArrayList($arr, $url_append=null) {
	
	global $core_config, $lang;
	
	if (isset($url_append)) {
		$url_append = "&" . $url_append;
	}
	else {
		$url_append = "";
	}
	
	if (count($arr) > $core_config['display']['max_list_rows']) {
		//build the url
		$args = array();
		
		foreach($_GET as $key => $i) {
			$args[$key] = $i;
		}
		
		if (isset($args['_frm'])) {
			$from = $args['_frm'];
			unset($args['_frm']);
		}
		else {
			$from = 0;
		}
		
		
		//start button
		$start_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
		if (0 == $from) {
			$start_html = "&lt;&lt;";
		}
		else {
			$start_html = "<a href='" . $start_url . "' title='" . $lang['txt_list_nav_start'] . "'>&lt;&lt;</a>";
		}
		
		//end button
		$num = count($arr)+1;
		while ($num > $core_config['display']['max_list_rows']):
			$num = $num - $core_config['display']['max_list_rows'];
		endwhile;
		
		$num = count($arr)+1 - $num;
		$args['_frm'] = $num;
		if ($from >= $num) {
			$end_html = "&gt;&gt;";
		}
		else {
			$end_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$end_html = "<a href='" . $end_url . "' title='" . $lang['txt_list_nav_end'] . "'>&gt;&gt;</a>";
		}
		
		//next button
		$args['_frm'] = $from + $core_config['display']['max_list_rows'];
		if ($args['_frm'] > count($arr)) {
			$next_html = "&gt;";
		}
		else {
			$next_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$next_html = "<a href='" . $next_url . "' title='" . $lang['txt_list_nav_next'] . "'>&gt;</a>";
		}
		
		//previous button
		$num = $from - $core_config['display']['max_list_rows'];
		
		if ($num < 0) {
			$num = 0;
		}
		$args['_frm'] = $num;
		if ($args['_frm'] == $from) {
			$prev_html = "&lt;";
		}
		else {
			$prev_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$prev_html = "<a href='" . $prev_url . "' title='" . $lang['txt_list_nav_prev'] . "'>&lt;</a>";
		}
		
		//pages
		$numrows = ceil(count($arr) / $core_config['display']['max_list_rows']);
		$pages_html = "";
		for ($i = 0; $i < $numrows; $i++) {
			$args['_frm'] = $i * $core_config['display']['max_list_rows'];
			$page_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args);
			
			if ($args['_frm'] == $from) {
				$pages_html .= ($i+1) . "&nbsp;&nbsp;";
			}
			else {
				$pages_html .= "<a href='" . $page_url . "' title='" . ($i+1) . "'>" . ($i+1) . "</a> ";
			}
		}
		
		$out_html = "<p class='listnav'>";
		
		//first page
		$out_html .= $start_html . "&nbsp;&nbsp;";
		
		//previous page
		$out_html .= $prev_html . "&nbsp;&nbsp;";
		
		//pages
		$out_html .= $pages_html;
		
		//next page
		$out_html .= $next_html . "&nbsp;&nbsp;";
		
		//last page
		$out_html .= $end_html;
		
		$out_html .= "</p>";
		
		return $out_html;
	}
}

// arrayToString ---------------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function arrayToString($arr) {
	$str = "";
	foreach($arr as $key => $i):
		$str .= $key . "=" . $i . "&amp;";
	endforeach;
	
	$str = substr($str, 0, strlen($str)-5);
	
	return $str;
	
}


/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function dots($string, $num) {
	if (strlen($string) > $num) {
		$string = substr_replace($string, '...', $num);
	}
	return $string;
}


/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function drawMatrix($rel_arr) {

	global $lang;

	if (isset($rel_arr['relation']['mutual'])) {
		$sign = $lang['txt_mutual_respect'];
		$title_help = "Mutually respected ->";
	}
	elseif (isset($rel_arr['relation']['respected'])) {
		$sign = $lang['txt_respect'];
		$title_help = "Respected ->";
	}
	else {
		$sign = $lang['txt_no_respect'];
		$title_help = "X not yet shown respect ->";
	}
	
	$title = $title_help . "press to draw the matrix between " . $rel_arr['identity']['identity_nic'] . " and " . $rel_arr['identity_relation']['identity_nic'];
	
	$matrix_html = "
		<span class=\"icon_frame\">
			<span class=\"icon_title\">
				<a href=\"index.php?amn=core_tie_matrix&amp;identity_id=" . $rel_arr['identity']['identity_id'] . "&amp;identity_id_relation=" . $rel_arr['identity_relation']['identity_id'] . "\" title=\"" . $title ."\">" . $sign . "</a>
			</span>
		<span class=\"icon_value\">" . $rel_arr['ties']['total'] . "</span>
		</span>
	";

	return $matrix_html;
}
?>