<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------
//
//	Methods:SimpleOpenID to ValidateWithServer are FREE TO USE and 
//	Contributed by http://www.fivestores.com/
// -----------------------------------------------------------------------


class SimpleOpenID {
	var $openid_url_identity;
	var $URLs = array();
	var $error = array();
	var $fields = array();
	
	function SimpleOpenID ($db, $core_config) {
		if (!function_exists('curl_exec')) {
			die('Error: Class SimpleOpenID requires curl extension to work');
		}
		else {
			$this->db = $db;
			$this->core_config = $core_config;
		}
	}
	function SetOpenIDServer($a){
		$this->URLs['openid_server'] = $a;
	}
	function SetTrustRoot($a){
		$this->URLs['trust_root'] = $a;
	}
	function SetCancelURL($a){
		$this->URLs['cancel'] = $a;
	}
	function SetApprovedURL($a){
		$this->URLs['approved'] = $a;
	}
	function SetRequiredFields($a){
		if (is_array($a)){
			$this->fields['required'] = $a;
		}else{
			$this->fields['required'][] = $a;
		}
	}
	function SetOptionalFields($a){
		if (is_array($a)){
			$this->fields['optional'] = $a;
		}else{
			$this->fields['optional'][] = $a;
		}
	}
	function SetIdentity($a){ 	// Set Identity URL
			$a = trim($a);
			
			if(substr($a,-1,1) == '/'){
				$a = substr($a, 0, strlen($a)-1);
			}
	
 			if(strpos($a, 'http://') === false) {
		 		$a = 'http://'.$a;
		 	}
				
			$this->openid_url_identity = $a;
	}
	function GetIdentity(){ 	// Get Identity
		return $this->openid_url_identity;
	}
	function GetError(){
		$e = $this->error;
		return array('code'=>$e[0],'description'=>$e[1]);
	}

	function ErrorStore($code, $desc = null){
		$errs['OPENID_NOSERVERSFOUND'] = 'Cannot find OpenID Server TAG on Identity page.';
		if ($desc == null){
			$desc = $errs[$code];
		}
	   	$this->error = array($code,$desc);
	}

	function IsError(){
		if (count($this->error) > 0){
			return true;
		}else{
			return false;
		}
	}
	
	function splitResponse($response) {
		$r = array();
		$response = explode("\n", $response);
		foreach($response as $line) {
			$line = trim($line);
			if ($line != "") {
				list($key, $value) = explode(":", $line, 2);
				$r[trim($key)] = trim($value);
			}
		}
	 	return $r;
	}
	
	function OpenID_Standarize($openid_identity){
		$u = parse_url(strtolower(trim($openid_identity)));

		if ($u['path'] == '/'){
			$u['path'] = '';
		}
		if(substr($u['path'],-1,1) == '/'){
			$u['path'] = substr($u['path'], 0, strlen($u['path'])-1);
		}
		
		if (isset($u['query'])){ // If there is a query string, then use identity as is
			return $u['host'] . $u['path'] . '?' . $u['query'];
		}else{
			return $u['host'] . $u['path'];
		}
	}
	
	function array2url($arr){ // converts associated array to URL Query String
		$query = "";
		if (!is_array($arr) || empty($arr)){
			return false;
		}
		foreach($arr as $key => $value){
			$query .= $key . "=" . $value . "&";
		}
		return $query;
	}
	function FSOCK_Request($url, $method="GET", $params = ""){
		$fp = fsockopen("ssl://www.myopenid.com", 443, $errno, $errstr, 3); // Connection timeout is 3 seconds
		if (!$fp) {
			$this->ErrorStore('OPENID_SOCKETERROR', $errstr);
		   	return false;
		} else {
			$request = $method . " /server HTTP/1.0\r\n";
			$request .= "User-Agent: Simple OpenID PHP Class (http://www.phpclasses.org/simple_openid)\r\n";
			$request .= "Connection: close\r\n\r\n";
		   	fwrite($fp, $request);
		   	stream_set_timeout($fp, 4); // Connection response timeout is 4 seconds
		   	$res = fread($fp, 2000);
		   	$info = stream_get_meta_data($fp);
		   	fclose($fp);
		
		   	if ($info['timed_out']) {
		       $this->ErrorStore('OPENID_SOCKETTIMEOUT');
		   	} else {
		      	return $res;
		   	}
		}
	}
	function CURL_Request($url, $method="GET", $params = "") { // Remember, SSL MUST BE SUPPORTED
			if (is_array($params)) $params = $this->array2url($params);
			$curl = curl_init($url . ($method == "GET" && $params != "" ? "?" . $params : ""));

			if (! ini_get("safe_mode")) {
				curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
			}
			
			curl_setopt($curl, CURLOPT_HEADER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_HTTPGET, ($method == "GET"));
			curl_setopt($curl, CURLOPT_POST, ($method == "POST"));
			if ($method == "POST") curl_setopt($curl, CURLOPT_POSTFIELDS, $params);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

			$response = curl_exec($curl);
			
			if (curl_errno($curl) == 0){
				$response;
			}else{
				$this->ErrorStore('OPENID_CURL', curl_error($curl));
			}
			return $response;
	}
	
	 function HTML2OpenIDServer($content) {
		$get = array();
		// Get details of their OpenID server and (optional) delegate
		preg_match_all('/<link[^>]*rel="openid.server"[^>]*href="([^"]+)"[^>]*\/?>/i', $content, $matches1);
		preg_match_all('/<link[^>]*href="([^"]+)"[^>]*rel="openid.server"[^>]*\/?>/i', $content, $matches2);
		$servers = array_merge($matches1[1], $matches2[1]);
		
		preg_match_all('/<link[^>]*rel="openid.delegate"[^>]*href="([^"]+)"[^>]*\/?>/i', $content, $matches1);
		
		preg_match_all('/<link[^>]*href="([^"]+)"[^>]*rel="openid.delegate"[^>]*\/?>/i', $content, $matches2);
		
		$delegates = array_merge($matches1[1], $matches2[1]);
		
		$ret = array($servers, $delegates);
		return $ret;
	}
	
	function GetOpenIDServer(){
		//echo $this->openid_url_identity; exit;
		$response = $this->CURL_Request($this->openid_url_identity);
		
		list($servers, $delegates) = $this->HTML2OpenIDServer($response);
		if (count($servers) == 0){
			$this->ErrorStore('OPENID_NOSERVERSFOUND');
			return false;
		}
		if (isset($delegates[0]) && $delegates[0] != ""){
			$this->openid_url_identity = $delegates[0];
		}
		$this->SetOpenIDServer($servers[0]);
		
		return $servers[0];
	}
	
	function GetRedirectURL(){
		$params = array();
		$params['openid.return_to'] = urlencode($this->URLs['approved']);
		$params['openid.mode'] = 'checkid_setup';
		$params['openid.identity'] = urlencode($this->openid_url_identity);
		$params['openid.trust_root'] = urlencode($this->URLs['trust_root']);
		
		if (count($this->fields['required']) > 0){
			$params['openid.sreg.required'] = implode(',',$this->fields['required']);
		}
		if (count($this->fields['optional']) > 0){
			$params['openid.sreg.optional'] = implode(',',$this->fields['optional']);
		}
		return $this->URLs['openid_server'] . "?". $this->array2url($params);
	}
	
	function Redirect(){
		$redirect_to = $this->GetRedirectURL();
		if (headers_sent()){ // Use JavaScript to redirect if content has been previously sent (not recommended, but safe)
			echo '<script language="JavaScript" type="text/javascript">window.location=\'';
			echo $redirect_to;
			echo '\';</script>';
		}else{	// Default Header Redirect
			header('Location: ' . $redirect_to);
			
		}
	}
	
	function ValidateWithServer(){
		$params = array(
			'openid.assoc_handle' => urlencode($_GET['openid_assoc_handle']),
			'openid.signed' => urlencode($_GET['openid_signed']),
			'openid.sig' => urlencode($_GET['openid_sig'])
		);
		// Send only required parameters to confirm validity
		$arr_signed = explode(",",str_replace('sreg.','sreg_',$_GET['openid_signed']));
		for ($i=0; $i<count($arr_signed); $i++){
			$s = str_replace('sreg_','sreg.', $arr_signed[$i]);
			$c = $_GET['openid_' . $arr_signed[$i]];
			// if ($c != ""){
				$params['openid.' . $s] = urlencode($c);
			// }
		}
		$params['openid.mode'] = "check_authentication";
		// print "<pre>";
		// print_r($_GET);
		// print_r($params);
		// print "</pre>";
		$openid_server = $this->GetOpenIDServer();
		if ($openid_server == false){
			return false;
		}
		$response = $this->CURL_Request($openid_server,'GET',$params);
		$data = $this->splitResponse($response);
		if ($data['is_valid'] == "true") {
			return true;
		}else{
			return false;
		}
	}


	// setConnection
	// Tom Calthrop, 8th April 2007
	// Used under connect and lock
	function setConnection ($output_webspace) {
		// Create session vars
		$_SESSION['openid_nickname'] = $_GET['openid_sreg_nickname'];
		
		//$_SESSION['openid_identity'] = $_GET['openid_identity'];

		$openid = $_GET['openid_identity'];
			
		if(substr($openid,-1,1) == '/'){
			$openid = substr($openid, 0, strlen($openid)-1);
		}
			
		$_SESSION['openid_identity'] = $openid;


		if (!empty($_GET['openid_sreg_email'])) {
			$_SESSION['openid_email'] = $_GET['openid_sreg_email'];
		}

		if (!empty($_GET['openid_sreg_fullname'])) {
			$_SESSION['openid_fullname'] = $_GET['openid_sreg_fullname'];
		}

		if (!empty($_GET['openid_sreg_country'])) {
			$_SESSION['openid_country'] = $_GET['openid_sreg_country'];
		}

		if (!empty($_GET['openid_sreg_language'])) {
			$_GET['openid_sreg_language'] = strtolower($_GET['openid_sreg_language']);
			
			if (in_array($_GET['openid_sreg_language'], $this->core_config['language']['pack'])) {
				$_SESSION['language_code'] = $_GET['openid_sreg_language'];
			}
		}

		$_SESSION['webspace_id'] = $output_webspace['webspace_id'];

		// We look to see if we have a connection_ID
		// If yes, we look to see if they are the owner
		// If yes, we update the record
		// if no, we create a record
		$query = "
			SELECT
			connection_id, connection_permission, connection_openid
			FROM " . $this->db->prefix . "_connection 
			WHERE
			connection_openid=" . $this->db->qstr($_SESSION['openid_identity']) . " AND
			webspace_id=" . $output_webspace['webspace_id']
		;
		
		$result = $this->db->Execute($query, 1);
		
		if (isset($result[0])) { // I have previously connected
			$connection = $result[0];

			$_SESSION['connection_id'] =  $connection['connection_id'];
			$_SESSION['connection_permission'] =  $connection['connection_permission'];
			$_SESSION['level_id'] = 32;
			
			if ($connection['connection_id'] == $output_webspace['owner_connection_id']) { // I am the webspace owner
				$_SESSION['level_id'] = 64;
			}
			
			$query = "
				UPDATE " . $this->db->prefix . "_connection SET 
				connection_nickname=" . $this->db->qstr($_SESSION['openid_nickname'])
			;

			if (!empty($_GET['openid_sreg_email'])) {
				$query .= ", connection_email=" . $this->db->qstr($_GET['openid_sreg_email']);
			}
			else {
				$query .= ", connection_email=NULL";
			}

			if (!empty($_GET['openid_sreg_fullname'])) {
				$query .= ", connection_fullname=" . $this->db->qstr($_GET['openid_sreg_fullname']);
			}
			else {
				$query .= ", connection_fullname=NULL";
			}

			if (!empty($_GET['openid_sreg_country'])) {
				$query .= ", connection_country=" . $this->db->qstr($_GET['openid_sreg_country']);
			}
			else {
				$query .= ", connection_country=NULL";
			}

			if (!empty($_GET['openid_sreg_language'])) {
				$query .= ", connection_language=" . $this->db->qstr($_GET['openid_sreg_language']);
			}
			else {
				$query .= ", connection_language=NULL";
			}

			$query .= " WHERE connection_id=" . $connection['connection_id'];
			
			$this->db->Execute($query);

			if ($output_webspace['status_id'] == $this->core_config['webspace']['status']['active']) {
				header('location: index.php?ws=' . $output_webspace['webspace_id']);
				exit;
			}
			else {
				header("Location: index.php?ws=" . $output_webspace['webspace_id'] . "&t=lock");
				exit;
			}
		}
		elseif (!empty($output_webspace['webspace_locked'])) { // locked space
			$GLOBALS['am_error_log'][] = array('webspace_locked');
		}
		else { // webspace virgin - We insert them
			
			$rec = array();
			$rec['webspace_id'] = $output_webspace['webspace_id'];
			$rec['connection_create_datetime'] = time();
			$rec['status_id'] = $this->core_config['connection']['status']['active'];
			$rec['connection_openid'] = $_SESSION['openid_identity'];
			$rec['connection_nickname'] = $_SESSION['openid_nickname'];
			$rec['connection_permission'] = $output_webspace['default_permission'];
			
			if (!empty($_SESSION['openid_email'])) {
				$rec['connection_email'] = $_SESSION['openid_email'];
			}

			if (!empty($_SESSION['openid_fullname'])) {
				$rec['connection_fullname'] = $_SESSION['openid_fullname'];
			}

			if (!empty($_SESSION['openid_country'])) {
				$rec['connection_country'] = $_SESSION['openid_country'];
			}

			if (!empty($_GET['openid_sreg_language'])) {
				$rec['connection_language'] = $_GET['openid_sreg_language'];
			}
			elseif (!empty($_SESSION['openid_language'])) {
				$rec['connection_language'] = $_SESSION['openid_language'];
			}
			
			$table = $this->db->prefix . "_connection";

			$this->db->insertDB($rec, $table);

			$_SESSION['level_id'] = 32;
			$_SESSION['connection_id'] = $this->db->insertID();
			$_SESSION['connection_permission'] = $output_webspace['default_permission'];
		
			if ($output_webspace['status_id'] == $this->core_config['webspace']['status']['active']) {
				header('location: index.php?ws=' . $output_webspace['webspace_id']);
				exit;
			}
			else {
				header("Location: index.php?ws=" . $output_webspace['webspace_id'] . "&t=lock");
				exit;
			}
		}
	} // EO setConnection
}

?>
