<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('event', 'add_event', $_SESSION['connection_permission'])) {

	include_once($language_path . 'common.lang.php');
	
	
	
	if (isset($_POST['update_event'])) {

		if (empty($_POST['event_title'])) {
			$GLOBALS['am_error_log'][] = array('no_title');
		}
			
		if (empty($_POST['event_body'])) {
			$GLOBALS['am_error_log'][] = array('no_description');
		}
		
		if (!empty($_POST['event_start_date'])) {
		
			$start_datetime = strtotime($_POST['event_start_date'] . $_POST['event_start_time']);
			
			if ($start_datetime == 0 || $start_datetime == -1) {
				$GLOBALS['am_error_log'][] = array('timeformat_not_valid');
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array('no_start_date');
		}
		

		if (!empty($_POST['event_end_date'])) {
		
				$end_datetime = strtotime($_POST['event_end_date'] . $_POST['event_end_time']);
						
			if ($end_datetime == 0 || $end_datetime == -1) {
				$GLOBALS['am_error_log'][] = array('timeformat_not_valid');
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array('no_end_date');
		}
	
		if (isset($start_datetime)) {
			if ($start_datetime <= time()) {
				$GLOBALS['am_error_log'][] = array('too_late');
			}
			elseif ($end_datetime < $start_datetime) {
				$GLOBALS['am_error_log'][] = array('end_date_before_start_date');
			}
		}
		
		if (empty($GLOBALS['am_error_log'])) {

			$_POST['event_title'] = strip_tags($_POST['event_title']);
	
			$_POST['event_body'] = am_parse($_POST['event_body']);
			
			if (!empty($_POST['event_id'])) { // we update the page
				
				if (!empty($_POST['event_venue'])) {
					$_POST['event_venue'] = $db->qstr(strip_tags($_POST['event_venue']));
				}
				else {
					$_POST['event_venue'] = "null";
				}
				
				$start_datetime = date('Y-m-d H:i:s', $start_datetime);
				$end_datetime = date('Y-m-d H:i:s', $end_datetime);
				
				$query = "
					UPDATE " . $db->prefix . "_plugin_event SET
					event_title=" . $db->qstr($_POST['event_title']) . ",
					event_body=" . $db->qstr($_POST['event_body']) . ",
					event_venue=" . $_POST['event_venue'] . ",
					event_start_datetime=" . $db->qstr($start_datetime) . ",
					event_end_datetime=" . $db->qstr($end_datetime) . " 
					WHERE event_id=" . $_POST['event_id']
				;
				
				$result = $db->Execute($query);

				$_SESSION['am_message_log'][] = array($lang['message']['event_saved']);
			}
			else { // we insert
	
				$rec = array();
				$rec['webspace_id'] = $_SESSION['webspace_id'];
				$rec['webpage_id'] = $_POST['wp'];
				$rec['connection_id'] = $_SESSION['connection_id'];
				$rec['event_create_datetime'] = time();
	
				if (!empty($_POST['event_venue'])) {
					$rec['event_venue'] = $_POST['event_venue'];
				}
	
				$rec['event_title'] = $_POST['event_title'];
				$rec['event_body'] = $_POST['event_body'];
				$rec['event_start_datetime'] = $start_datetime;
				$rec['event_end_datetime'] = $end_datetime;
				
				$table = $db->prefix . "_plugin_event";
				
				$db->insertDB($rec, $table);
			
				$_POST['event_id'] = $db->insertID();

				$_SESSION['am_message_log'][] = array($lang['message']['event_saved']);
			}

			header("Location: index.php?t=edit_event&c=event&ws=" . $_REQUEST['ws'] . "&wp=" . $_POST['wp'] . "&event_id=" . $_POST['event_id']);
			exit;
		}
		else {
			$_POST['event_body'] = stripslashes($_POST['event_body']);
			$_POST['event_title'] = htmlspecialchars($_POST['event_title']);
			$_POST['event_title'] = stripslashes($_POST['event_title']);
			
			$body->set('event', $_POST);
			unset($_REQUEST['event_id']);
		}
	}


	if (isset($_REQUEST['wpn'])) {
		$query = "
			SELECT webpage_id
			FROM " . $db->prefix . "_webpage
			WHERE
			webpage_name=" . $db->qstr($_REQUEST['wpn']) . " AND
			webspace_id=". $db->qstr($_REQUEST['ws'])
		;

		$result = $db->Execute($query);

		if (!empty($result[0]['webpage_id'])) {
			$_REQUEST['wp'] = $result[0]['webpage_id'];
		}
	}
	
	
	if (isset($_REQUEST['event_id'])) { // we are editing a page
		$query = "
			SELECT event_id, webspace_id,
			UNIX_TIMESTAMP(event_start_datetime) as event_start_datetime,
			UNIX_TIMESTAMP(event_end_datetime) as event_end_datetime,
			event_title, event_body, event_venue, connection_id,
			event_create_datetime 
			FROM " . $db->prefix . "_plugin_event
			WHERE event_id=" . $_REQUEST['event_id']
		;
	
		$result = $db->Execute($query);
		
		if (!empty($result[0])) {
			$output_event = $result[0];

			// $output_event['event_end_time'] = date('H:i');
			$output_event['event_end_date'] = date('Y-m-d', $output_event['event_end_datetime']);
			$output_event['event_end_time'] = date('H:i', $output_event['event_end_datetime']);
			$output_event['event_start_date'] = date('Y-m-d', $output_event['event_start_datetime']);
			$output_event['event_start_time'] = date('H:i', $output_event['event_start_datetime']);

			$output_event['event_body'] = am_render($output_event['event_body']);
		
			$body->set('event', $output_event);
		}
	}
	elseif (!isset($_POST)) {
		$now = time();
		$tomorrow_start  = mktime(0, 0, 0, date("m", $now)  , date("d", $now)+1, date("Y", $now));
		$tomorrow_end  = mktime(23, 59, 0, date("m", $now)  , date("d", $now)+1, date("Y", $now));

		$output_event['event_end_date'] = date('Y-m-d', $tomorrow_end);
		$output_event['event_end_time'] = date('H:i', $tomorrow_end);
		$output_event['event_start_date'] = date('Y-m-d', $tomorrow_start);
		$output_event['event_start_time'] = date('H:i', $tomorrow_start);
		$body->set('event', $output_event);
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
?>