<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


	include ("../../core/config/core.config.php");
	
	
	// SETUP DATABASE ------------------------------------------------------
	require_once('../../core/class/Db.class.php');
	$db = new Database($core_config['db']);
	
	
	// START SESSION -----------------------------------------------------------
	session_name($core_config['node']['php_session_name']);
	session_start();
	
	header("Content-type: application/xml");
	echo '<?xml version="1.0"?>';
	echo '<poll>';
	
	if (isset($_POST['answer_id'])) {

 		$rec = array();
 		$rec['connection_id'] = $_SESSION['connection_id'];
 		$rec['poll_id'] = $_POST['poll_id'];
 		$rec['option_id'] = $_POST['answer_id'];
 		$rec['answer_create_datetime'] = time();
		
		$table = $db->prefix . "_plugin_poll_answer";

		$db->insertDb($rec, $table);
	}
	
	$query = "
		SELECT poll_id, poll_question,
		connection_id, poll_create_datetime
		FROM " . $db->prefix . "_plugin_poll
		WHERE
		webspace_id=" . $_POST['webspace_id'] . " AND "
	;

	if (isset($_POST['poll_id']) && $_POST['poll_id']>0) {
		$query .= "poll_id=" . $_POST['poll_id'] . " AND ";
	}

	$query .= "1=1 ORDER BY poll_create_datetime desc";
	
	$result = $db->Execute($query);

	if (isset($result[0])) {

		$poll = $result[0];

		echo '<poll_id>' . $poll['poll_id'] . '</poll_id>';
		echo '<poll_question>' . $poll['poll_question'] . '</poll_question>';
		echo '<connection_id>' . $poll['connection_id'] . '</connection_id>';
		echo '<poll_create_datetime>' . $poll['poll_create_datetime'] . '</poll_create_datetime>';


		// have I voted ? ------------------------------------------------
		$my_answer = 1;

		$myanswer_query = "
			SELECT answer_id 
			FROM " . $db->prefix . "_plugin_poll_answer
			WHERE 
			poll_id=" . $poll['poll_id'] . " AND
			connection_id=" . $_SESSION['connection_id']
		;

		$myanswer_result = $db->Execute($myanswer_query);
		
		if (isset($myanswer_result[0])) {
			$my_answer = $myanswer_result[0]['answer_id'];
			echo '<my_answer>' . $my_answer . '</my_answer>';
		}



		// get the total number of votes -----------------------
		if ($my_answer>0) {
		
			$total_votes = 0;
	
			$total_query = "
				SELECT count(answer_id) as total
				FROM " . $db->prefix . "_plugin_poll_answer
				WHERE
				poll_id=" . $poll['poll_id']
			;
			
			$total_result = $db->Execute($total_query);
	
			if (isset($total_result[0])) {
				$total_votes = $total_result[0]['total'];
			}
	
			echo '<total_votes>' . $total_votes . '</total_votes>';
		}

		// get the options ---------------------------------------------------------------
		$options_query = "
			SELECT option_id, option_body, option_order
			FROM " . $db->prefix . "_plugin_poll_option
			WHERE
			poll_id=" . $poll['poll_id'] . "
			ORDER BY option_order"
		;

		$options_result = $db->Execute($options_query);

		if (isset($options_result)) {
			foreach($options_result as $key => $i):
				//$poll_option =  $options_result->fields;

				echo '<option>';
				echo '<option_id>' . $i['option_id'] . '</option_id>';
				echo '<option_body>' . $i['option_body'] . '</option_body>';
				echo '<option_order>' . $i['option_order'] . '</option_order>';

				if ($my_answer>0) {
					// get the answer count
					$answer_query = "
						SELECT count(answer_id) as total
						FROM " . $db->prefix . "_plugin_poll_answer
						WHERE
						option_id=" . $i['option_id']
					;
	
					$answer_result = $db->Execute($answer_query);
	
					if (isset($answer_result[0])) {
						echo '<option_votes>' . $answer_result[0]['total'] . '</option_votes>';
	
						$percent = 0;
						
						if (!empty($answer_result[0]['total'])) {
							$percent = round((100/$total_votes)* $answer_result[0]['total']);
						}
						echo '<option_percent>' . $percent . '</option_percent>';
	
					}
				}
				
				echo '</option>';

			endforeach;
		}

		if ($my_answer>0) {
			echo '<total_votes>' . $total_votes . '</total_votes>';
		}
	}

	echo '</poll>';

?>