<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title>Create your webspace</title>

		<style type="text/css">
		<!--
		@import url(../core/template/css/aroundme.css);
		-->
		</style>
		
		<!--[if IE]>
		<style type="text/css">
		@import url(../core/template/css/aroundme-IE.css);
		</style>
		<![endif]-->

		<script type="text/javascript" src="../core/template/js/functions.js"></script>
	</head>
	
	<body id="am_admin">
		<?php
		if (!empty($GLOBALS['am_error_log'])) {
		?>
		<div id="error_container">
			<div class="content">
				<?php
				foreach($GLOBALS['am_error_log'] as $key => $i):
				?>
					<?php
					if (isset($lang['error'][$i[0]])) {
						echo $lang['error'][$i[0]];
					}
					else {
						echo $i[0];
					}

					if (!empty($i[1])) {
						echo ": " . $i[1];
					}?>
					<br />
				<?php
				endforeach;
				?>
			</div>
		</div>
		<?php }?>

		<div id="body_container">
			
			<form method="post">
			
			<?php
			if (isset($stage) && $stage < 6) {
			?>
			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td valign="top" width="50%">
						<div class="box">
							<div class="box_header">
								<h1>Create</h1>
							</div>
							
							<div class="box_body">
								<p>
									Create your webspace in 4 simple steps.
								</p>
								
								<ol>
									<?php
									if (isset($stage) && $stage > 1) {
									?>
									<li><del>Agree terms</del></li>
									<?php
									}
									else {
									?>
									<li>Agree terms</li>
									<?php }?>
									
									
									<?php
									if (isset($stage) && $stage > 2) {
									?>
									<li><del>Connect using your OpenID</del></li>
									<ul>
										<li><b><?php echo $_SESSION['openid_nickname'];?></b></li>
										<li><b><?php echo $_SESSION['openid_identity'];?></b></li>
										<li><b><?php echo $_SESSION['openid_email'];?></b></li>
									</ul>
									<?php
									}
									else {
									?>
									<li>Connect using your OpenID</li>
									<?php }?>
									

									<?php
									if (isset($stage) && $stage > 3) {
									?>
									<li><del>Design your webspace</del></li>
									<?php
									}
									else {
									?>
									<li>Design your webspace</li>
									<?php }?>

									
									<?php
									if (isset($stage) && $stage > 4) {
									?>
									<li><del>Choose settings</li>
									<?php
									}
									else {
									?>
									<li>Choose settings</li>
									<?php }?>
									
									
									
									<li>Choose your webspace URL</li>
								</ol>
							</div>
						</div>
					</td>
					<td valign="top" width="50%">
						
						<?php
						if (isset($stage) && $stage == 1) {
						?>
						
						<div class="box">
							<div class="box_header">
								<h1>1. Agree terms</h1>
							</div>
							
							<div class="box_body">
								<div style="width:100%; height:380px;overflow:auto">
									<?php include('language/en/terms_of_use.lang.php');?>
								</div>

								<p align="right">
									<input type="submit" name="reject_terms" value="I disagree" />
									<input type="submit" name="accept_terms" value="I agree" />
								</p>
							</div>
						</div>
						
						<?php
						}
						elseif (isset($stage) && $stage == 2) {
						?>
					
						<div class="box">
							<div class="box_header">
								<h1>2. Connect</h1>
							</div>

							<div class="box_body">
								<p>
									<label for="id_openid">OpenID</label><br />
									<input type="text" id="openid_login" name="openid_login" value="http://example.domain.org" onFocus="this.value=''; return false;" />
								</p>

								<p align="right">
									<input type="submit" name="connect" value="connect" />
								</p>

								<h3>Need an OpenID account?</h3>

								<p>
									OpenID is like a digital identity card with which you can show to enter a web site. You get to keep your information in one place and you get to choose which information you wish to present to each web site.
								</p>

								<p>
									If you have your own domain name you can host your own OpenID account using <a href="http://www.barnraiser.org/">AROUNDMe Personal identity</a> which is free. Alternatively you can obtain an OPenID account from a service provider such as <a href="http://www.barnraiser.info/">Barnraiser</a>.
								</p>
								</div>
							</div>

							<?php
							}
							elseif (isset($stage) && $stage == 3) {
							?>

							<div class="box">
								<div class="box_header">
									<h1>3. Design</h1>
								</div>

								<div class="box_body">
									<input type="hidden" id="theme_name" name="theme_name" value="" />
									<input type="hidden" id="theme_css" name="theme_css" value="" />

									<p>
										You can customise your webspace to include all sorts of stuff including a forum, a blog and a wiki. To start with pick the webspace that most closely matches what you want.
									</p>
									
									<?php
									if (isset($themes)) {
									?>
									<script type="text/javascript">

										function viewThumbs(theme) {
											var v = document.getElementById('thumbs').getElementsByTagName('div');
											for(i=0;i<v.length;i++) {
												v[i].style.display = "none";
											}
											document.getElementById('output_thumb').innerHTML = "";
											document.getElementById(theme+'_thumb').style.display = "block";
											document.getElementById('id_layout').value = theme;
											
										}

										function viewThumb(path, css, theme) {
											document.getElementById('output_thumb').innerHTML = "<img src=\""+path+"\"/>";
											document.getElementById('theme_name').value = theme;
											document.getElementById('theme_css').value = css;
										}

									</script>

									<div id="theme_names">
										<p>
											Select the layout you want:
										</p>

										<?php
										foreach($themes as $key => $v) {
										?>
										<h3><?php echo $lang['arr_theme'][$key]['name'];?></h3>
										<p>
											<?php echo $lang['arr_theme'][$key]['description'];?>
										</p>

										<ul>
											<?php foreach($v['thumb'] as $t) { ?>
												<?php
												$tmp = explode('/', $t);
												$tmp = explode('.', $tmp[count($tmp)-1]);
												?>

												<li><a href="#" onclick="viewThumb('<?php echo $t; ?>', '<?php echo $tmp[0];?>', '<?php echo $key;?>');"><?php echo $lang['arr_theme'][$key]['style'][$tmp[0]];?></a></li>
											<?php } ?>
										</ul>
										<?php } ?>
									</div>

									<div id="output_thumb"></div>

									<script type="text/javascript">
										viewThumb('themes/standard/thumb/barnraiser_light.png', 'barnraiser_light', 'standard');
									</script>
									<?php }?>
										
									<p align="right">
										<input type="submit" name="apply_design" value="apply design" />
									</p>
								</div>
							</div>

							<?php
							}
							elseif (isset($stage) && $stage == 4) {
							?>

							<div class="box">
								<div class="box_header">
									<h1>4. Settings</h1>
								</div>

								<div class="box_body">
									<p>
										The title of your webspace appears at the top of the browser window and is used to list your site on search engines.
									</p>

									<p>
										<label for="id_title">title</label>
										<input name="webspace_title" id="id_title" type="text" value="<?php if (isset($_POST['title'])) echo stripslashes($_POST['title']); ?>" />
									</p>
									
									
									
									<?php
									if (count($core_config['language']['pack']) > 1) {
									?>

									<p>
										<label for="id_language_id"><?php echo $lang['txt_language'];?></label><br />
										<select name="language_code" id="id_language_code" style="margin-top:6px;">
											<?php
											foreach($core_config['language']['pack'] as $key => $i):
												$selected = "";
												if (isset($_POST['language_code']) && $_POST['language_code'] == $i) {
													$selected = "selected=\"selected\"";
												}
											?>
											<option value="<?php echo $i;?>" <?php echo $selected; ?>><?php echo ucfirst(strtolower($lang['arr_language'][$i]));?></option>
											<?php
											endforeach;
											?>
										</select>
									</p>
									<?php }?>
									
									<p>
										You can make your webspace private so that people apply to join the webspace and can only see information upon your approval or keep it public meaning that anyone can join in.
									</p>

									<p>
										<label for="id_lock" style="width:300px;">Check the box to make it private</label><input type="checkbox" name="webspace_locked" id="id_lock" <?php if (isset($_POST['lock']) && !empty($_POST['lock'])) echo "checked=\"checked\""; ?>/>
									</p>
										
									<p align="right">
										<input type="submit" name="configure" value="apply settings" />
									</p>
								</div>
							</div>

							<?php
							}
							elseif (isset($stage) && $stage == 5) {
							?>

							<div class="box">
								<div class="box_header">
									<h1>5. Choose a URL</h1>
								</div>

								<div class="box_body">
         							<?php if (isset($webspace_name)) { ?>
										<p>
											This is the web address that you will use to access your webspace:
										</p>
										
										<h3><?php echo str_replace('REPLACE', $webspace_name, $config_url);?></h3>

										<p>
											<input type="submit" name="reject_webspace_name" value="choose another name" />
											<input type="submit" name="complete" value="choose and create webspace"/>
											<input type="hidden" name="webspace_name" value="<?php if (isset($webspace_name)) { echo $webspace_name;}?>" />
										</p>
									<?php } else { ?>
										<p>
											Choose a name to be used as your web address (URL). Picking the name '<b>example</b>' would result in your URL being '<b><?php echo str_replace('REPLACE', 'example', $config_url);?></b>'. You can choose any a-z or 0-9 character.
										</p>

										<p>
											<label for="id_webspace_name">webspace name</label><input type="text" name="webspace_name" id="id_webspace_name" value="<?php if (isset($_POST['webspace_name'])) { echo $_POST['webspace_name'];}?>" />
											<input type="submit" name="test_webspace_name" value="choose"/>
										</p>
									<?php } ?>
								</div>
							</div>
						<?php }?>
					</td>
				</tr>
			</table>
			<?php
			}
			elseif (isset($stage) && $stage == 6) {
			?>
			
			<div class="box">
				<div class="box_header">
					<h1>You are done!</h1>
				</div>

				<div class="box_body">
					<p>
						Congratulations! You have created your webspace. Please save the following informatiom:
					<ul>
						<li>Owner nickname: <?php echo $_SESSION['openid_nickname'];?></li>
						<li>Owner connection OpenID: <?php echo $_SESSION['openid_identity'];?></li>
						<li>Owner email: <?php echo $_SESSION['openid_email'];?></li>
						<li>URL : <?php echo str_replace('REPLACE', $_SESSION['webspace_name'], $config_url);?></li>
						<li>Created: <?php echo strftime("%d %b %G %H:%M", $_SESSION['webspace_create_datetime']);?></li>
					</ul>

					<?php
					if ($webspace_creation_type == 2) { // automatic
					?>
					<p>
						You can <a href="<?php echo str_replace('REPLACE', $_SESSION['webspace_name'], $config_url);?>">proceed directly to your webspace</a>. You will arrive at your home page. Press 'connect' and log in using your OpenID.
					</p>
					<?php
					}
					else {
					?>
					<p>
						Your webspace application has been received and will be reviewed. You will receive an email shortly.
					</p>
					<?php }?>

					<h3>Some things you should do soon</h3>
					<ol>
						<li>You should create your own internal webspace ettiquette policy.</li>
						<li>You should go to 'network', select 'Manage permissions' and set the permissions you wish people connecting to your webspace to have.</li>
						<li>You should always connect with a valid email address as this is how people in your webspace can contact you.</li>
					</ol>
				</div>
			</div>
			<?php }?>
			</form>
		</div>
	</body>		
</html>