<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

include ("../../core/config/aroundme_core.config.php");
include ("../../core/inc/functions.inc.php");


// START SESSION -----------------------------------------------------------
session_name($core_config['node']['php_session_name']);
session_start();


// SETUP STORAGE ---------------------------------------------------------------------------
require_once('../../core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP IDENTITY --------------------------------------------
require_once('../../core/class/Identity.class.php');
$identity = new Identity($db);


// OBTAIN IDENTITY ACCOUNT NAME
$identity->identity_name = $identity->getIdentityName($core_config['am']['domain_preg_pattern']);

if (!empty($identity->identity_name)) {
	define('AM_IDENTITY_NAME', $identity->identity_name);
	
	$output_identity = $identity->selIdentity();

	if (!empty($output_identity)) {
			
		define('AM_WEBSPACE_ID', $output_identity['webspace_id']);

		// SETUP TEMPLATE -------------------------------------------
		define("AM_TEMPLATE_PATH", "template/");

		require_once('../../core/class/Template.class.php');
		$tpl = new Template();


		// SETUP LANGUAGE ------------------------------------------------------
		if (array_key_exists(strtoupper($_SESSION['language_code']), $core_config['language']['localization'])) {
			$locale_code = $core_config['language']['localization'][strtoupper($_SESSION['language_code'])];

			setlocale(LC_ALL, $locale_code);
		}

		define("AM_LANGUAGE_PATH", "language/" . $_SESSION['language_code'] . "/");

		$lang = array();
		include_once('../../core/' . AM_LANGUAGE_PATH . 'common.lang.php');
		include_once(AM_LANGUAGE_PATH . 'block_tag_builder.lang.php');

		$tpl->set('lang', $lang);


		// SETUP WEBSPACE --------------------------------------------
		require_once('../../core/class/Webspace.class.php');
		$ws = new Webspace($db);
		$ws->webspace_id = AM_WEBSPACE_ID;

		$output_webpages = $ws->selWebPages();

		if (!empty($output_webpages)) {
			$tpl->set('webpages', $output_webpages);
		}

		echo $tpl->fetch(AM_TEMPLATE_PATH . 'block_tag_builder.tpl.php');
	}
}

?>