<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// used for RSS feeds
function am_plugin_blog_getItemsArray () {

	global $db, $url, $output_webspace;
	
	$query = "
		SELECT blog_id, blog_title, blog_body, blog_create_datetime 
		FROM " . $db->prefix . "_plugin_blog
		WHERE
		webspace_id=" . $output_webspace['webspace_id'] . "
		ORDER BY blog_create_datetime"
	;
		
	$result = $db->Execute($query);
	
	$rss = array();

	if (!empty($result)) {
		foreach ($result as $key => $i):

			$desc = strip_tags($i['blog_body']);

			if (strlen($desc) > 220) {
				$desc = substr_replace($desc, '...', 220);
			}
			
			$item['title'] = $i['blog_title'];
			$item['description'] = htmlspecialchars($desc);
			$item['link'] = $url . "&amp;blog_id=" . $i['blog_id'];
			$item['datetime'] = $i['blog_create_datetime'];
		
			array_push($rss, $item);
		endforeach;
	}
	
	return $rss;
}

?>