<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Template {
	var $vars; // contains all template variables
	

	// the constructor
	// Tom Calthrop, 26th March 2007
	//
	function Template() {
	
	} // EO Constructor


	// Set
	// Tom Calthrop, 26th March 2007
	// sets template variable
	//
	function set($key, $value) {
		$this->vars[$key] = $value;
	} // EO set


	// Set
	// Tom Calthrop, 26th March 2007
	// output buffers file
	//
	function fetch($file) {
		if (!empty($this->vars)) {
			extract($this->vars);
		}
		ob_start();
		include($file);
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	} // EO fetch


	// makeTemplate
	// Tom Calthrop, 26th March 2007
	// gets component include files and builds template body
	//
	function makeTemplate ($webspace, $ws) { // webspace array, ws=class

		global $lang;
		
		$body = $webspace['webpage_body'];


		// BLOCK PARSING ------------------------------------------------
		// we look through the body to discover any AM_BLOCK_? content
		$pattern = "/<AM_BLOCK_(.*?)>/";
	
		if (preg_match_all($pattern, $body, $blocks)) {
	
			if (!empty($blocks[1])) {
				$output_blocks = $ws->selBlocks();
				
				if (!empty($output_blocks)) {
					foreach ($output_blocks as $key => $i):
						// replace the block tag with the block
						$body = str_replace("<" . $i['webblock_tag'] . " />", $i['webblock_body'], $body);
	
						$pattern = "/<AM_BLOCK_" . $i['webblock_tag'] . "(.*)\/>/i";
	
						$replacement = $i['webblock_body'];
						
						$body = preg_replace($pattern, $replacement, $body);
					endforeach;
				}
			}
		}
		


		// PLUGIN PARSING ------------------------------------------------
		// we look through the body to discover any AM_PLUGIN_? content
		$pattern = "/<AM_PLUGIN_(.*?) (.*?)>/";
		
		if (preg_match_all($pattern, $body, $plugin_blocks)) {
	
			if (!empty($plugin_blocks[1])) {
				foreach ($plugin_blocks[1] as $key => $i):
					$tag_name = strtolower($plugin_blocks[1][$key]);

					unset ($tag_attribute);
					// get attributes
					$tag_attribute_arr = trim($plugin_blocks[2][$key]);
					
					$attribute_pattern = '/(\w+)(\s*=\s*"(.*?)"|\s*=\s*\'(.*?)\'|(\s*=\s*\w+)|())/s';
	
					if(preg_match_all($attribute_pattern, $tag_attribute_arr, $matches, PREG_PATTERN_ORDER)) {
	
						if (!empty($matches[1])) {
							
							foreach ($matches[1] as $key_attr => $at):
	
								$tag_attribute_name = $matches[1][$key_attr];
								
								if (!empty($matches[3][$key_attr])) {
									$tag_attribute[$tag_attribute_name] = $matches[3][$key_attr];
								}
								elseif (!empty($matches[4][$key_attr])) {
									$tag_attribute[$tag_attribute_name] = $matches[4][$key_attr];
								}
								elseif (!empty($matches[5][$key_attr])) {
									$tag_attribute[$tag_attribute_name] = $matches[5][$key_attr];
								}
							endforeach;
						}
					}
					
					
					//we run the function
					$function_name = "plugin_" . $tag_name;
					$function_path = "components/" . $tag_name . "/";
	
					if (!function_exists($function_name) && is_file($function_path . "/plugin.inc.php")) {
						// we include the plugin
						include_once($function_path  . "plugin.inc.php");
						include_once($function_path  . "language/" . $_SESSION['language_code'] ."/common.lang.php");

						$this->vars['lang'] = $lang;
					}
	
					if (function_exists($function_name) && is_file($function_path  . "template/plugin_blocks/" . $tag_attribute['block'] . ".tpl.php")) {
						$function_name($tag_attribute);
	
						// replace the block
						$pattern = "/" . $plugin_blocks[0][$key] . "/";
	
						$plugin_html = file_get_contents($function_path  . "template/plugin_blocks/" . $tag_attribute['block'] . ".tpl.php");

						if (!empty($this->vars)) {
							extract($this->vars);          // Extract the vars to local namespace
						}
						
						ob_start();
						echo eval("?>".$plugin_html);
						$plugin_html = ob_get_contents(); // Get the contents of the buffer
						ob_end_clean();
				
						$body = preg_replace($pattern, $plugin_html, $body);
					}
				endforeach;
			}
		}

		

		// INTERLINKING ------------------------------------------------
		$output_webpages = $ws->selWebpages();

		$interlink_path = "index.php?ws=" . $webspace['webspace_id'] . "&wpn=";
		$interlink_new_path = "index.php?ws=" . $webspace['webspace_id'] . "&wp=" . $webspace['webpage_id'] . "&t=admin_webpage&wpn=";
	
		// we run through the page body replacing any pages
		if (!empty($output_webpages)) {
			foreach ($output_webpages as $keyp => $p):
				// first with anchors
				$pattern = "/<interlink name=\"" . $p . "#(.*?)\">(.*?)<\/interlink>/";
	
				$replacement = "<a href=\"" . $interlink_path . $p . "#$1\">$2</a>";
	
				$body = preg_replace($pattern, $replacement, $body);

				// then without anchors
				$pattern = "/<interlink name=\"" . $p . "\">(.*?)<\/interlink>/";
	
				$replacement = "<a href=\"" . $interlink_path . $p . "\">$1</a>";
	
				$body = preg_replace($pattern, $replacement, $body);
			endforeach;
		}
	
		// now we look for new pages
		$pattern = "/<interlink name=\"(.*?)\">(.*?)<\/interlink>/";
	
		$replacement = "$2<a href=\"" . $interlink_new_path . "$1\"><sup>?</sup></a>";
	
		$body = preg_replace($pattern, $replacement, $body);

		
		

		if (!empty($this->vars)) {
			extract($this->vars); 
		}
		
		ob_start();
		echo $body;
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}
}
?>
