<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="maintain.php" method="POST">
<input type="hidden" name="webspace_id" value="<?php if (isset($webspace['webspace_id'])) { echo $webspace['webspace_id'];}?>" />


<div id="am_core_area">
	<?php
	if (isset($display) && $display == "maintain") {
	?>
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="240" valign="top">
				<div class="box">
					<h1><?php echo $lang['hdr_maintain_webspaces'];?></h1>

					<ul>
						<?php
						$link_css = "";
						if (isset($_REQUEST['status']) && $_REQUEST['status'] == 3) {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="maintain.php?status=3"<?php echo $link_css;?>><?php echo $lang['href_menu_list_live'];?></a></li>
						<?php
						$link_css = "";
						if (!isset($_REQUEST['status']) && !isset($_REQUEST['claimed'])) {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="maintain.php"<?php echo $link_css;?>><?php echo $lang['href_menu_list_pending'];?></a></li>
						<?php
						$link_css = "";
						if (isset($_REQUEST['status']) && $_REQUEST['status'] == 2) {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="maintain.php?status=2"<?php echo $link_css;?>><?php echo $lang['href_menu_list_barred'];?></a></li>
						<?php
						$link_css = "";
						if (!empty($_REQUEST['claimed'])) {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="maintain.php?claimed=1"<?php echo $link_css;?>><?php echo $lang['href_menu_list_claimed'];?></a></li>
						<?php
						$link_css = "";
						if (isset($display) && $display == "software") {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="maintain.php?add=1"<?php echo $link_css;?>><?php echo $lang['href_menu_add'];?></a></li>
						<li><a href="maintain.php?logoff=1"><?php echo $lang['href_logoff'];?></a></li>
					</ul>
				</div>
			</td>
			<td width="20">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="20" height="1" border="0" alt="" /><br />
			</td>
			<td valign="top">
				<?php
				if (isset($allow_add)) {
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_add_webspace'];?></h1>
					
					<p>
						<label for="openid_login"><?php echo $lang['txt_label_owner_openid'];?></label><br />
						<input type="text" id="openid_login" name="openid_login" value="" />
					</p>
	
					<p>
						<label for="unix_name"><?php echo $lang['txt_unix_name'];?></label><br />
						<input type="text" id="unix_name" name="unix_name" value="<?php if (isset($_POST['unix_name'])) echo $_POST['unix_name']; ?>" />
					</p>
	
					<p>
						<label for="id_webspace_title"><?php echo $lang['txt_webspace_title'];?></label><br />
						<input type="text" name="webspace_title" id="id_webspace_title" maxlength="150" value="<?php if (isset($_POST['webspace_title'])) { echo $_POST['webspace_title'];}?>" style="width:390px;" />
					</p>
						
					<?php
					if (count($core_config['language']['pack']) > 1) {
					?>
					<p>
						<label for="id_language_id"><?php echo $lang['txt_language'];?></label><br />
						<select name="language_code" id="id_language_code" style="margin-top:6px;">
							<?php
							foreach($core_config['language']['pack'] as $key => $i):
								$selected = "";
								if (isset($_POST['language_code']) && $_POST['language_code'] == $i) {
									$selected = "selected=\"selected\"";
								}
							?>
							<option value="<?php echo $i;?>" <?php echo $selected; ?>><?php echo ucfirst(strtolower($lang['arr_language'][$i]));?></option>
							<?php
							endforeach;
							?>
						</select>
					</p>
					<?php }?>
					
					<p>
						<label for="id_webspace_description"><?php echo $lang['txt_webspace_description'];?></label><br />
						<?php echo $lang['txt_input_description'];?><br />
						<textarea name="webspace_description" id="id_webspace_description" cols="50" rows="3" style="width:390px;" onKeyPress="javascript:inputMaxLength(this, 200, 'description_input_indicator');"><?php if (isset($_POST['webspace_description'])) { echo $_POST['webspace_description'];}?></textarea>
						<span id="description_input_indicator" class="input_indicator"></span>
					</p>
					
					<p>
						<label for="id_webspace_lock"><?php echo $lang['txt_lock_webspace'];?></label><br />
						<?php
						$selected = " checked=\"checked\"";
						if (empty($_POST['webspace_locked']) && isset($_POST['commit_webspace'])) {
							$selected = "";
						}
						?>
	
						<?php echo $lang['txt_lock_intro'];?>&nbsp;<input type="checkbox" id="id_webspace_lock" name="webspace_locked" style="margin:2px;"<?php echo $selected;?> />
					</p>
					
					<b><?php echo $lang['hdr_theme'];?></b>

					<?php
					if (isset($themes)) {
					?>

					<table cellspacing="0" cellpadding="6" border="0">
						<?php foreach($themes as $key => $t): ?>
						<tr>
							<td valign="top">
								<label for="id_theme_<?php echo $t['name']; ?>"><img src="<?php echo $template_path_core; ?>themes/<?php echo $t['name']; ?>/thumb.png" style="border: 1px solid black; margin-right: 5px; margin-bottom: 5px; cursor: pointer;" /></label><br />
							</td>
							<td valign="top">
								<input type="radio" id="id_theme_<?php echo $t['name']; ?>" name="theme" value="<?php echo $t['name']; ?>" <?php if($key==0) { echo "checked=\"checked\"";}?> /><br />
							</td>
							<td valign="top">
								<b><?php echo $t['title']; ?></b><br />
								<?php echo $t['description']; ?><br />
							</td>
						</tr>
						<?php
						endforeach; ?>
					</table>
					<?php } ?>
					
					<p align="right">
						<input type="submit" name="insert_webspace" value="<?php echo $lang['sub_finish_create'];?>" class="input_submit" /><br />
					</p>
				</div>
					
				<?php
				}
				elseif (isset($webspace)) {
				$url = formatSubDomainUrl($webspace['webspace_unix_name']);
				?>
				<h1><?php echo $lang['hdr_manage_webspace'];?></h1>
				
				<p>
					<b><?php echo $lang['txt_webspace_name'];?></b><br />
					<a href="<?php echo $url;?>"><?php echo $webspace['webspace_unix_name'];?></a><br />
				</p>
				
				<p>
					<b><?php echo $lang['txt_webspace_description'];?></b><br />
					<?php echo $webspace['webspace_description'];?><br />
				</p>

				<p>
					<b><?php echo $lang['txt_owner_nic'];?></b><br />
					<?php echo $webspace['connection_nickname'];?>
					<?php
					if (!empty($webspace['connection_fullname'])) {
					?>
					(<?php echo $webspace['connection_fullname'];?>)
					<?php }?>
					<br />
				</p>

				<p>
					<b><?php echo $lang['txt_owner_openid'];?></b><br />
					<a href="<?php echo $webspace['connection_openid'];?>"><?php echo $webspace['connection_openid'];?></a><br />
				</p>

				<p>
					<b><?php echo $lang['txt_owner_email'];?></b><br />
					<a href="mailto:<?php echo $webspace['connection_email'];?>"><?php echo $webspace['connection_email'];?></a><br />
				</p>

				<p>
					<b><?php echo $lang['txt_webspace_create_datetime'];?></b><br />
					<?php echo strftime("%d %b %G", $webspace['webspace_create_datetime']);?><br />
				</p>

				<p>
					<b><?php echo $lang['txt_label_language'];?></b><br />
					<?php echo $webspace['language_code'];?><br />
				</p>

				<p>
					<b><?php echo $lang['txt_label_locked'];?></b><br />
					<?php echo $webspace['webspace_locked'];?><br />
				</p>

				<p>
					<label for="id_webspace_allocation"><?php echo $lang['txt_status'];?></label><br />
					<select name="status_id">
						<?php
						foreach ($core_config['webspace']['status'] as $key => $i):

						$selected = "";

						if ($i == $webspace['status_id']) {
							$selected = " selected=\"selected\"";
						}
						?>
						<option value="<?php echo $i;?>"<?php echo $selected ;?>><?php echo $lang['arr_webspace_status'][$i];?></option>
						<?php
						endforeach;
						?>
					</select>
				</p>

				<p>
					<label for="id_webspace_allocation"><?php echo $lang['txt_allocation'];?></label><br />
					<input id="id_webspace_allocation" size="5" name="webspace_allocation" value="<?php echo $webspace['webspace_allocation'];?>" />&nbsp;kb<br />
				</p>

				<p>
					<label for="id_status"><?php echo $lang['txt_label_webspace_maintainer_log'];?></label><br />
					<textarea id="id_status" name="webspace_maintainer_log" cols="50" rows="6" style="width:390px;"><?php if (isset($webspace['webspace_maintainer_log'])) { echo $webspace['webspace_maintainer_log'];}?></textarea>
				</p>

				<p align="right">
					<input type="submit" name="update_webspace" value="<?php echo $lang['sub_save'];?>" class="input_submit" /><br />
				</p>

				<?php
				}
				elseif (isset($webspaces)) {
				?>
				<h1><?php echo $lang['hdr_manage_webspace'];?></h1>
				
				<table cellspacing="2" cellpadding="2" border="0" width="100%">
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_name'];?></b><br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_status'];?></b><br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_created'];?></b><br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_allocation'];?></b><br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_openid'];?></b><br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_language'];?></b><br />
						</td>
						<td valign="top" align="right">
							<b><?php echo $lang['txt_label_email'];?></b><br />
						</td>
					</tr>
					<?php
					foreach ($webspaces as $key => $i):
					?>
					<tr>
						<td valign="top">
							<a href="maintain.php?webspace_id=<?php echo $i['webspace_id'];?>"><?php echo $i['webspace_unix_name'];?></a><br />
						</td>
						<td valign="top">
							<?php
							if (isset($lang['arr_webspace_status'][$i['status_id']])) {
								echo $lang['arr_webspace_status'][$i['status_id']];
							}?>
							<br />
						</td>
						<td valign="top">
							<?php echo strftime("%d %b %G", $i['webspace_create_datetime']);?><br />
						</td>
						<td valign="top">
							<?php echo $i['webspace_allocation'];?>&nbsp;kb<br />
						</td>
						<td valign="top">
							<a href="<?php echo $i['connection_openid'];?>"><?php echo $lang['href_visit'];?></a><br />
						</td>
						<td valign="top">
							<?php echo $i['language_code'];?><br />
						</td>
						<td valign="top" align="right">
							<?php
							if (!empty($i['connection_email'])) {
							?>
							<a href="mailto:<?php echo $i['connection_email'];?>"><?php echo $lang['href_email'];?></a>
							<?php }?>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else {
				?>
				<h1><?php echo $lang['hdr_manage_webspace'];?></h1>

				<p>
					<?php echo $lang['err_no_webspaces'];?>
				</p>
				<?php }?>
			</td>
		</tr>
	</table>
	<?php
	}
	else {
	?>
	<div class="box" style="text-align:left;margin-left:auto;margin-right:auto; width:380px;">
		<h1><?php echo $lang['hdr_maintainer_access'];?></h1>

		<p>
			<input type="text" id="openid_login" name="openid_login" value="" />
			<input name="commit" type="submit" value="<?php echo $lang['sub_login'];?>" class="input_submit" />
		</p>
	</div>
	<?php }?>
</div>
</form>