<?php

// -----------------------------------------------------------------------
// This file is part of beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";

if (!isset($_SESSION['user_id'])) {
	if (isset($_REQUEST['item_id'])) {
		$url = "account.php?item_id=" . $_REQUEST['item_id'];
	}
	else {
		$url = "account.php";
	}
	return header("Location: " . $url);
	exit;
}

if (!$user->checkPermission($c_node['permission']['send_newsletter'])) {
	header("Location: index.php?" . SID);
	exit;
}


// SETUP LANGUAGE FILES ---------------------------------------------------
$languageFile = $c_node['node']['language']['pack'][$_SESSION['language_id']][1] . "_admin.lang.php";
require_once($languagePath . $languageFile);



// SETUP NEWSLETTER -----------------------------------------------------
if (isset($_POST['send_newsletter'])) {

	require_once($c_node['dir']['class_path'] . 'Newsletter.class.php');
	$nl = new Newsletter($db, null);
	$nl->insertNewsletter($frmdata);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		//send newsletter
		if($c_node['cron']['bulk_email'] != 1) {
			//we send email directly 
			unset($_SESSION["newsletter_id"]);
			$_SESSION["newsletter_id"] = $nl->message_id;
			header("Location: newsletter_send.php");
			exit;
		}
	}
}
elseif (isset($_REQUEST['complete'])) {
	if ($_REQUEST['complete'] < 1) {
		$_REQUEST['complete'] = 0;
	}
	
	$lang['arr_error'][20] = str_replace("NUMBER", $_REQUEST['complete'], $lang['arr_error'][20]);
	$GLOBALS['beacon_error_log'][] = array(20, null);
}

$template_file = "newsletter.tpl.php";
include "inc/footer.inc.php";

?>
