<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="en" />
<meta name="keywords" content="<?php echo $lang['meta_keywords'];?>" />
<meta name="OriginalPublicationDate" content="<?php echo $lang['meta_OriginalPublicationDate'];?>" />
<meta name="Description" content="<?php echo $lang['meta_Description'];?>" />

<title><?php echo $lang['txt_page_title'];?></title>
<style type="text/css">
<!--
@import url(<?php echo $templatePath;?>beacon.css);

-->
</style>
<!--[if IE]>
<style type="text/css">
@import url(<?php echo $templatePath;?>beacon-IE.css);
</style>
<![endif]-->

<script language="JavaScript" src="js/functions.js" type="text/javascript"></script>
<script language="JavaScript" src="speller/spellChecker.js" type="text/javascript"></script>
<script language="JavaScript" type="text/javascript">
	var baseImgURL = '<?php echo $templatePath?>img/';
	
	//takes form elements (text and textarea) and passes to spellchecker
	function openSpellChecker() {
		var speller = new spellChecker();
		speller.spellCheckAll();
	}

</script>

<link rel="SHORTCUT ICON" href="<?php echo $templatePath;?>img/favicon.ico" />

</head>

<body>

<div id="layout">
	<div id="header">
		<div class="masthead">
			<div class="menu">
				<?php
				if ($page_name_short == "search") {
				?>
				<?php echo $lang['href_search'];?>
				<?php
				}
				else {
				?>
				<a href="list.php"><?php echo $lang['href_search'];?></a>
				<?php }?>
				&nbsp;&#47;&nbsp;
				
				<?php
				if (count($lang['language']) > 1) {
					foreach ($lang['language'] as $key => $i):
						if ($key == $_SESSION['language_id']) {
							echo $i . "&nbsp;&#47;&nbsp;";
						}
						else {
							echo "<a href=\"index.php?language_id=" . $key . "\">" . $i . "</a>&nbsp;&#124;&nbsp;";
						}
					endforeach;
				}
				?>
				
				<?php
				if (isset($_SESSION['s_user_id'])) {
					echo $_SESSION['user_name'] . "&nbsp;&#47;&nbsp;<a href=\"account.php\">" . $lang['href_account'] . "</a>&nbsp;&#47;&nbsp;<a href=\"index.php?logoff=1\">" .$lang['txt_logoff'] . "</a>";
				}
				else {
					echo "<a href=\"splash.php\">" .$lang['href_login'] . "</a>";
					
					if (!empty($access_config['allow_registration'])) {
						echo "&nbsp;&#47;&nbsp;";
						echo "<a href=\"splash.php?register=1\">" .$lang['href_register'] . "</a>";
					}
				}
				?>
				<br />
			</div>
		</div>
	
		<div id="main_menu">
			<div class="content">
				<p>
					<?php
					if (isset($section) && $section == "splash") {
						echo $lang['menu_splash'];
					}
					else {
						echo "<a href='splash.php'>" . $lang['menu_splash'] . "</a>";
					}
					?><br />
				</p>
				
				<p>
					<?php
					if (isset($section) && $section == "wiki") {
						echo $lang['menu_wiki'];
					}
					else {
						echo "<a href='index.php'>" . $lang['menu_wiki'] . "</a>";
					}
					?><br />
				</p>
				
				<?php
				if (isset($_SESSION['s_user_id'])) {
				?>
				<p>
					<?php
					if (isset($section) && $section == "me") {
						echo $lang['menu_me'];
					}
					else {
						echo "<a href='account.php'>" . $lang['menu_me'] . "</a>";
					}
					?><br />
				</p>
				<?php }?>
				
				<p>
					<?php
					if (isset($section) && $section == "structure") {
						echo $lang['menu_structure'];
					}
					else {
						echo "<a href='structure.php'>" . $lang['menu_structure'] . "</a>";
					}
					?><br />
				</p>
			</div>
		</div>
	
		<div id="sub_menu">
			<div class="content">
				<?php
				if (isset($section)) {
				?>
				
					<?php
					if ($section == "splash") {
					?>
					
						<?php
						if ($page_name_short == "splash" && !isset($_REQUEST['man'])) {
						?>
						<?php echo $lang['menu_intro'];?>
						<?php
						} else {
						?>
						<a href="splash.php"><?php echo $lang['menu_intro'];?></a>
						<?php }?>
						&nbsp;&#47;&nbsp;
						<?php
						if ($page_name_short == "splash" && isset($_REQUEST['man'])) {
						?>
						<?php echo $lang['menu_help'];?>
						<?php
						} else {
						?>
						<a href="splash.php?man=1"><?php echo $lang['menu_help'];?></a>
						<?php }?>
						
						<?php
						if (!empty($access_config['allow_registration'])) {
						?>
						&nbsp;&#47;&nbsp;
						<?php
						if ($page_name_short == "splash" && isset($_REQUEST['register'])) {
						?>
						<?php echo $lang['menu_register'];?>
						<?php
						} else {
						?>
						<a href="splash.php?register=1"><?php echo $lang['menu_register'];?></a>
					<?php }}?>
						<br />
					<?php
					}
					elseif ($section == "me") {
					?>
						<?php
						if ($page_name_short == "account") {
						?>
						<?php echo $lang['menu_account'];?>
						<?php
						} else {
						?>
						<a href="account.php"><?php echo $lang['menu_account'];?></a>
						<?php }?>
						&nbsp;&#47;&nbsp;
						<?php
						if ($page_name_short == "publish") {
						?>
						<?php echo $lang['menu_publishing'];?>
						<?php
						} else {
						?>
						<a href="publish.php"><?php echo $lang['menu_publishing'];?></a>
						<?php }?>
						<br />
						
					<?php
					}
					elseif ($section == "wiki") {
					?>
						<?php
						if ($page_name_short == "list" && !isset($contents)) {
						?>
						<?php echo $lang['menu_contents'];?>
						<?php
						} else {
						?>
						<a href="list.php?contents=1"><?php echo $lang['menu_contents'];?></a>
						<?php }?>
						&nbsp;&#47;&nbsp;
						
						<?php
						if ($page_name_short == "list" && !isset($contents)) {
						?>
						<?php echo $lang['menu_wiki_first_page'];?>
						<?php
						} else {
						?>
						<a href="index.php"><?php echo $lang['menu_wiki_first_page'];?></a>
						<?php }?>
						
						<?php
						$menu = $this->menu->selMenu(1);
				
						if (!empty($menu)) {
							foreach($menu as $key => $i):
								echo "&nbsp;&#47;&nbsp;";
								if (isset($item) && (($link_type_ids[1] && $item['item_wiki_page'] == $i['menu_link']) || ($link_type_ids[2]))) {
									echo $i['menu_title'];
								}
								else {
									if ($i['menu_link_type_id'] == $link_type_ids['wikipage']) {
										$lnk = "view.php?page=" . $i['menu_link'];
									}
									elseif ($i['menu_link_type_id'] == $link_type_ids['tag']) {
										$lnk = "list.php?tag=" . $i['menu_link'];
									}
									else {
										$lnk = $i['menu_link'];	
									}
									
									echo "<a href=\"" . $lnk . "\">" . $i['menu_title'] . "</a>";
								}
							endforeach;
						}
						?>
						<br />
					<?php
					}
					elseif ($section == "structure") {
					?>
						<?php
						if ($page_name_short == "structure") {
						?>
						<?php echo $lang['menu_structure'];?>
						<?php
						} else {
						?>
						<a href="structure.php"><?php echo $lang['menu_structure'];?></a>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['menu'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "admin" && (isset($_REQUEST['list_menu']) || isset($_REQUEST['menu_id']))) {
						?>
						<?php echo $lang['menu_edit_menu'];?>
						<?php
						} else {
						?>
						<a href="admin.php?list_menu=1"><?php echo $lang['menu_edit_menu'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['wiki'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "admin" && (isset($_REQUEST['list_item']) || isset($_REQUEST['item_id']))) {
						?>
						<?php echo $lang['menu_edit_items'];?>
						<?php
						} else {
						?>
						<a href="admin.php?list_item=1"><?php echo $lang['menu_edit_items'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['file'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "admin" && (isset($_REQUEST['list_files']) || isset($_REQUEST['file_id']))) {
						?>
						<?php echo $lang['menu_edit_files'];?>
						<?php
						} else {
						?>
						<a href="admin.php?list_files=1"><?php echo $lang['menu_edit_files'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['user'], $privilege_ids['allow_edit'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "admin" && (isset($_REQUEST['list_users']) || isset($_REQUEST['user_id']))) {
						?>
						<?php echo $lang['menu_edit_contributors'];?>
						<?php
						} else {
						?>
						<a href="admin.php?list_users=1"><?php echo $lang['menu_edit_contributors'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['newsletter'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "newsletter") {
						?>
						<?php echo $lang['menu_newsletter'];?>
						<?php
						} else {
						?>
						<a href="newsletter.php"><?php echo $lang['menu_newsletter'];?></a>
						<?php }}?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['acs'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
						echo "&nbsp;&#47;&nbsp;";
						if ($page_name_short == "acs") {
						?>
						<?php echo $lang['menu_acs'];?>
						<?php
						} else {
						?>
						<a href="acs.php"><?php echo $lang['menu_acs'];?></a>
						<?php }}?>
						<br />
					<?php }?>
				<?php }?>
			</div>
		</div>
		
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
	</div>

	<?php
	if (isset($log)) {
	?>
	<div id="system_message">
		<?php
		foreach($log as $key => $i):
			if (isset($i[0])) {
				unset($error);
				if (isset($error_handling) && $error_handling>0 && isset($i[1])) {
					$error = $lang['arr_error'][$i[0]] . ": " . $i[2] . "<br />";
				}
				elseif (empty($i[1])) {
					$error = $lang['arr_error'][$i[0]] . "<br />";
				}
			}

			if (isset($error)) {
				echo "<p>" . $error . "</p>";
			}
		endforeach;
		?>
	</div>
	<?php }?>


	<div id="content">
		<?php echo $content;?>
	</div>

	<div id="base_sub_menu">
		<?php
		$menu = $this->menu->selMenu(2);
		
		if (!empty($menu)) {
			foreach($menu as $key => $i):
				if ($i['menu_link_type_id'] == $link_type_ids['wikipage']) {
					$lnk = "index.php?page=" . $i['menu_link'];
				}
				elseif ($i['menu_link_type_id'] == $link_type_ids['tag']) {
					$lnk = "list.php?tag=" . $i['menu_link'];
				}
				else {
					$lnk = $i['menu_link'];	
				}
				
				echo "<a href=\"" . $lnk . "\">" . $i['menu_title'] . "</a>";
				
				echo "&nbsp;&nbsp;";
			endforeach;
		}
		?>
		
		<a href="rss_feed.php" title="<?php echo $lang['txt_rss_image_title'];?>"><img src="<?php echo $templatePath;?>img/rss.png" width="36" height="15" alt="" border="0" /></a><br />
	</div>
	
	<div id="footer">
		<!-- under our free license policy you are allowed to remove this, however we would obviously like it if you chose to promote us through including the following text/link/logo -->
		<a href="http://www.barnraiser.org/beacon/"><img src="<?php echo $templatePath;?>img/beacon.png" width="137" height="40" alt="" border="0" /></a>
		<?php echo $lang['txt_strap'];?><br />
	</div>
	
	<img name="session_reload_image" src="get_file.php?file=session_reload_image.png" alt="" />
	

</div>
</body>
</html>
