<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Users
{
  private static $instance;
  public $db;
  private function __construct() {
    $this->db = Database_SQLite::connect ("users");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Users();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS users (
  username text,
  password text,
  level integer,
  email text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  public function upgrade ()
  {
    $columns = array ();
    $query = "PRAGMA table_info (users);";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $columns [] = $row ['name'];
    }

    if (!in_array ("address", $columns)) {
      $sql = "ALTER TABLE users ADD COLUMN address text;";
      Database_SQLite::exec ($this->db, $sql);
    }

    if (!in_array ("agent", $columns)) {
      $sql = "ALTER TABLE users ADD COLUMN agent text;";
      Database_SQLite::exec ($this->db, $sql);
    }

    if (!in_array ("fingerprint", $columns)) {
      $sql = "ALTER TABLE users ADD COLUMN fingerprint text;";
      Database_SQLite::exec ($this->db, $sql);
    }

    if (!in_array ("timestamp", $columns)) {
      $sql = "ALTER TABLE users ADD COLUMN timestamp integer;";
      Database_SQLite::exec ($this->db, $sql);
    }
  }


  public function trim ()
  {
    // Remove persistent logins after a day of inactivity.
    $timestamp = time () - 86400;
    $query = "UPDATE users SET fingerprint = '' WHERE timestamp < $timestamp;";
    Database_SQLite::exec ($this->db, $query);
  }
    

  public function optimize ()
  {
    Database_SQLite::exec ($this->db, "REINDEX users;");
    Database_SQLite::exec ($this->db, "VACUUM users;");
  }


  // Returns how many administrators there are.
  public function getAdministratorCount () 
  {
    $query = "SELECT COUNT(*) FROM users WHERE level = " . Filter_Roles::ADMIN_LEVEL . ";";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return 0;
  }


  // Returns true if the username and password match.
  public function matchUsernamePassword ($username, $password)
  {
    $username = Database_SQLiteInjection::no ($username);
    $password = md5 ($password);
    $query = "SELECT * FROM users WHERE username = '$username' and password = '$password'";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return true;
    }
    return false;
  }


  // Returns true if the email and password match.
  public function matchEmailPassword ($email, $password) 
  {
    $email = Database_SQLiteInjection::no ($email);
    $password = md5 ($password);
    $query = "SELECT * FROM users WHERE email = '$email' and password = '$password'";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return true;
    }
    return false;
  }


  // Add the user details to the database.
  public function addNewUser ($username, $password, $level, $email) 
  {
    $username = Database_SQLiteInjection::no ($username);
    $level = Database_SQLiteInjection::no ($level);
    $email = Database_SQLiteInjection::no ($email);
    $query = "INSERT INTO users (username, level, email) VALUES ('$username', $level, '$email');";
    Database_SQLite::exec ($this->db, $query);
    $this->updateUserPassword ($username, $password);
  }


  // Returns the query to execute to add a new user.
  public function addNewUserQuery ($username, $password, $level, $email) 
  {
    $username = Database_SQLiteInjection::no ($username);
    $password = md5 ($password);
    $level = Database_SQLiteInjection::no ($level);
    $email = Database_SQLiteInjection::no ($email);
    $query = "INSERT INTO users (username, password, level, email) VALUES ('$username', '$password', $level, '$email')";
    return $query;
  }


  // Returns the username that belongs to the $email.
  public function getEmailToUser ($email) 
  {
    $email = Database_SQLiteInjection::no ($email);
    $query = "SELECT username FROM users WHERE email = '$email';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


  // Returns the email address that belongs to $user.
  public function getUserToEmail ($user) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT email FROM users WHERE username = '$user';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


  // Returns true if the username exists in the database.
  public function usernameExists ($user) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT * FROM users WHERE username = '$user'";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return true;
    }
    return false;
  }


  // Returns true if the email address exists in the database.
  public function emailExists ($email)
  {
    $email  = Database_SQLiteInjection::no ($email);
    $query  = "SELECT * FROM users WHERE email = '$email'";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return true;
    }
    return false;
  }


  // Returns the level that belongs to the user.
  public function getUserLevel ($user) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $query = "SELECT level FROM users WHERE username = '$user';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return Filter_Roles::GUEST_LEVEL;
  }


  // Updates the level of a given user.
  public function updateUserLevel ($user, $level) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $level = Database_SQLiteInjection::no ($level);
    $query = "UPDATE users SET level = $level WHERE username = '$user';";
    Database_SQLite::exec ($this->db, $query);
  }


  /**
  * removeUser - Remove a user from the database.
  */
  public function removeUser ($user) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $query = "DELETE FROM users WHERE username = '$user'";
    Database_SQLite::exec ($this->db, $query);
  }


  // Returns the site administrator's username.
  // This function needs improvement since it only returns one admin, even if there are more.
  public function getAdministrator () 
  {
    $query = "SELECT username FROM users WHERE level = " . Filter_Roles::ADMIN_LEVEL . ";";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


  // Updates the $password for $user.
  public function updateUserPassword ($user, $password) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $password = md5 ($password);
    $query = "UPDATE users SET password = '$password' WHERE username = '$user';";
    Database_SQLite::exec ($this->db, $query);
  }


  // Returns the query to update a user's email address.
  public function updateEmailQuery ($username, $email)
  {
    $query = "UPDATE users SET email = '$email' WHERE username = '$username';";
    return $query;
  }


  // Updates the $email for $user.
  public function updateUserEmail ($user, $email) 
  {
    $user = Database_SQLiteInjection::no ($user);
    $email = Database_SQLiteInjection::no ($email);
    $query = $this->updateEmailQuery ($user, $email);
    Database_SQLite::exec ($this->db, $query);
  }


  // Return an array with the available users.
  public function getUsers ()
  {
    $users = array ();
    $query = "SELECT username FROM users;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $users [] = $row[0];
    }
    return $users;
  }
  
  
  // Import function from MySQL.
  // The $password is hashed, and therefore stored in SQLite as it is.
  public function importMySQL ($username, $password, $level, $email) 
  {
    $username = Database_SQLiteInjection::no ($username);
    $password = Database_SQLiteInjection::no ($password);
    $level = Database_SQLiteInjection::no ($level);
    $email = Database_SQLiteInjection::no ($email);
    $query = "INSERT INTO users (username, password, level, email) VALUES ('$username', '$password', $level, '$email')";
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  // Sets the remote IP address for a username.
  public function setAddress ($username, $address)
  {
    $username = Database_SQLiteInjection::no ($username);
    $address = md5 ($address);
    $query = "UPDATE users SET address = '$address' WHERE username = '$username';";
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  // Sets the remote user agent for a username.
  public function setUserAgent ($username, $agent)
  {
    $username = Database_SQLiteInjection::no ($username);
    $agent = md5 ($agent);
    $query = "UPDATE users SET agent = '$agent' WHERE username = '$username';";
    Database_SQLite::exec ($this->db, $query);
  }


  // Sets the finger print for a username.
  public function setFingerprint ($username, $fingerprint)
  {
    $username = Database_SQLiteInjection::no ($username);
    $fingerprint = md5 ($fingerprint);
    $query = "UPDATE users SET fingerprint = '$fingerprint' WHERE username = '$username';";
    Database_SQLite::exec ($this->db, $query);
  }


  // Returns the username that matches the remote IP $address and the browser's user $agent,
  // and the remaining fingerprint from the user.
  // Returns false if no match was found.
  public function getUsername ($address, $agent, $fingerprint)
  {
    $address = md5 ($address);
    $agent = md5 ($agent);
    $fingerprint = md5 ($fingerprint);
    $query = "SELECT username FROM users WHERE address = '$address' AND agent = '$agent' AND fingerprint = '$fingerprint';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return false;
  }
  
  
  public function pingTimestamp ($username)
  {
    $username = Database_SQLiteInjection::no ($username);
    $timestamp = time ();
    $query = "UPDATE users SET timestamp = $timestamp WHERE username = '$username';";
    Database_SQLite::exec ($this->db, $query);
  }


}



?>
