<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


$database_logs = Database_Logs::getInstance ();


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") {
  $database_logs->log ("Fatal: export/esword.php only runs through the cli SAPI", Filter_Roles::ADMIN_LEVEL);
  die;
}


ignore_user_abort (true);
set_time_limit (0);


// The input parameters.
$bible = $argv [1];
$force = $argv [2];


// Create folder for the exports.
$directory = Export_Logic::osisDirectory ($bible);
if (!file_exists ($directory)) mkdir ($directory, 0777, true);


$directoryBasicPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 1);
if (!file_exists ($directoryBasicPython)) mkdir ($directoryBasicPython, 0777, true);
$directoryFullPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 2);
if (!file_exists ($directoryFullPython)) mkdir ($directoryFullPython, 0777, true);
$directoryBasicPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 1);
if (!file_exists ($directoryBasicPerl)) mkdir ($directoryBasicPerl, 0777, true);
$directoryFullPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 2);
if (!file_exists ($directoryFullPerl)) mkdir ($directoryFullPerl, 0777, true);


// Copy info for OSIS.
copy ("../osis/osis.html", "$directory/readme.html");


$fullUsfmDirectory = Export_Logic::USFMdirectory ($bible, 0);
$basicUsfmDirectory = Export_Logic::USFMdirectory ($bible, 1);

// If no update is forced, if the files are already there, bail out.
if (!$force) {
  if (!file_exists ("$directoryBasicPython/00_Bible.xml")) $force = true;
  if (!file_exists ("$directoryFullPython/00_Bible.xml")) $force = true;
  if (!file_exists ("$directoryBasicPerl/00_Bible.xml")) $force = true;
  if (!file_exists ("$directoryFullPerl/00_Bible.xml")) $force = true;
}
if (!$force) return;


$database_logs->log (gettext ("Convert Bible from full USFM to OSIS through Python") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($fullUsfmDirectory, $directoryFullPython, $bible);
$osis_text->run ('py');
$database_logs->log (gettext ("Convert Bible from basic USFM to OSIS through Python") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($basicUsfmDirectory, $directoryBasicPython, $bible);
$osis_text->run ('py');
$database_logs->log (gettext ("Convert Bible from full USFM to OSIS through Perl") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($fullUsfmDirectory, $directoryFullPerl, $bible);
$osis_text->run ('pl');
$database_logs->log (gettext ("Convert Bible from basic USFM to OSIS through Perl") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($basicUsfmDirectory, $directoryBasicPerl, $bible);
$osis_text->run ('pl');
$database_logs->log (gettext ("OSIS exports ready") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);


?>
