<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);


@include ("credentials.php");


// Check credentials and propose defaults.
if (!isset ($database_name)) $database_name = "bibledit-web";
if (!isset ($database_user)) $database_user = "username";
if (!isset ($database_pass)) $database_pass = "password";
if (!isset ($database_host)) $database_host = "localhost";


?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Bibledit-Web Installation</title>
<link rel="stylesheet" href="stylesheet.css" type="text/css" />
</head>
<body>
<h1><img src="../assets/bibledit.png"> <a href="http://bibledit.org/">Bibledit-Web</a></h1>
<form method="post" action="connect.php">
  <p>Enter the database connection details of the existing Bibledit-Web 1.3 installation. If you are not sure about these, contact your hosting provider.</p>
  <table class="form-table">
    <tr>
      <th scope="row"><label for="name">Database Name</label></th>
      <td><input name="name" id="name" type="text" size="25" value="<?php echo $database_name ?>" /></td>
      <td>The name of the database Bibledit-Web runs in.</td>
    </tr>
    <tr>
      <th scope="row"><label for="user">User Name</label></th>
      <td><input name="user" id="user" type="text" size="25" value="<?php echo $database_user ?>" /></td>
      <td>Your MySQL username.</td>
    </tr>
    <tr>
      <th scope="row"><label for="pass">Password</label></th>
      <td><input name="pass" id="pass" type="text" size="25" value="<?php echo $database_pass ?>" /></td>
      <td>Your MySQL password.</td>
    </tr>
    <tr>
      <th scope="row"><label for="host">Database Host</label></th>
      <td><input name="host" id="host" type="text" size="25" value="<?php echo $database_host ?>" /></td>
      <td>You should be able to get this information from your hosting provider, if <code>localhost</code> does not work.</td>
    </tr>
  </table>
  <p class="step"><input name="submit" type="submit" value="Submit" class="button button-large" /></p>
</form>
</body>
</html>
