<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Logs
{
  /**
  * Singleton logic.
  */
  private static $instance;
  private function __construct () {
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Logs();
    }
    return self::$instance;
  }


  public function rotate ()
  {
    // For easier operation, change to the working directory.
    chdir ($this->folder ());

    // Delete the entries as used in Bibledit-Web 1.5 and older.
    @unlink ("5.log");
    @unlink ("4.log");
    @unlink ("3.log");
    @unlink ("2.log");
    @unlink ("1.log");
    @unlink ("0.log");

    // Files older than five days.
    $second = strtotime ("today") -  (6 * 86400);
    $filename = $second . str_repeat ("0", 8);

    $files = scandir ($this->folder ());
    $files = Filter_Folders::cleanup ($files);
    foreach ($files as $file) {
      if ($file <= $filename) {
        unlink ($file);
      }
    }
  }
  
  
  private function folder ()
  {
    $folder = realpath (__DIR__ . "/../logbook");
    return $folder;
  }


  // Logs entry.
  public function log ($description, $level = 5)
  {
    // No new lines.
    $description = str_replace ("\n", " ", $description);
    
    // Save this logbook entry to a filename with seconds and microseconds.
    $time = explode (" ", microtime ());
    $seconds = $time [1];
    $microseconds = substr ($time [0], 2);
    $file = $this->folder () . "/$seconds$microseconds";

    // Due to the microseconds granularity, 
    // there may be the rare case of more than one entry per file.
    // So append the data.
    file_put_contents ($file, "$level $seconds $description", FILE_APPEND);
  }


  // Get the logbook entries for $day.
  // Day 0 is today, day 1 is yesterday, and so on.
  public function get ($day)
  {
    $day = (int) $day;
    $firstsecond = strtotime ("today") -  ($day * 86400);
    $lastsecond = $firstsecond + 86400 - 1;
    $firstfilename = $firstsecond . str_repeat ("0", 8);
    $lastfilename = $lastsecond . str_repeat ("9", 8);

    $lastentry = $firstfilename;

    $entries = array ();
    
    $files = scandir ($this->folder ());
    $files = Filter_Folders::cleanup ($files);
    foreach ($files as $file) {
      if (($file >= $firstfilename) && ($file <= $lastfilename)) {
        $lastentry = $file;
        $entries [] = file_get_contents ($this->folder () . "/$file");
      }
    }

    return array ($lastentry, $entries);
  }


  // Gets journal entry more recent than $filename.
  public function getNext ($filename)
  {
    $files = scandir ($this->folder ());
    $files = Filter_Folders::cleanup ($files);
    foreach ($files as $file) {
      if ($file > $filename) {
        $entry = file_get_contents ($this->folder () . "/$file");
        return array ($file, $entry);
      }
    }

    return NULL;
  }


}


?>
