<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h1><?php echo Locale_Translate::_("Installation") ?></h1>

<h2><?php echo Locale_Translate::_("Standard installation") ?></h2>
<p><a href="installlinuxhosting.php"><?php echo Locale_Translate::_("Bibledit-Web on shared Linux hosting.") ?></a></p>
<p><a href="installmacosx.php"><?php echo Locale_Translate::_("Bibledit-Web on Mac OS X.") ?></a></p>
<p><a href="installnewubuntu.php"><?php echo Locale_Translate::_("Bibledit-Web on Ubuntu 13.10.") ?></a></p>
<p><a href="installcentos.php"><?php echo Locale_Translate::_("Bibledit-Web on CentOS 6.4.") ?></a></p>
<!--
<p><a href="installwindows.php"><?php echo Locale_Translate::_("Bibledit-Web on Microsoft Windows.") ?></a></p>
-->

<h2><?php echo Locale_Translate::_("Upgrading") ?></h2>
<p>
  <?php echo Locale_Translate::_("A certain release of Bibledit-Web can upgrade the most recent previous release, but not older releases.") ?>
</p>

<h2><?php echo Locale_Translate::_("Email") ?></h2>
<p>
  <?php echo Locale_Translate::_("Bibledit-Web works with email.") ?>
  <?php echo Locale_Translate::_("After completing the installation of Bibledit-Web, sending and receiving emails does not yet work.") ?>
  <?php echo Locale_Translate::_("This needs to be set up.") ?>
  <?php echo Locale_Translate::_("Setting up the email means to pick an email address and setting details for the mail servers in Bibledit-Web.") ?>
  <?php echo Locale_Translate::_("This can be done from within the web application.") ?>
</p>

<h2><?php echo Locale_Translate::_("Multiple translation teams") ?></h2>
<p><?php echo Locale_Translate::_("There are two ways to have multiple translation teams on one server. ") ?></p>
<ol>
<li>
  <?php echo Locale_Translate::_("Install multiple parallel copies of Bibledit-Web on one server.") ?>
  <?php echo Locale_Translate::_("Unpack the installation zip archive in sub folders with different names.") ?>
  <?php echo Locale_Translate::_("Each copy has its own web address.") ?>
  <?php echo Locale_Translate::_("Everything is completely separated between the parallel copies.") ?>
  <?php echo Locale_Translate::_("This includes the data and the databases.") ?>
  <?php echo Locale_Translate::_("Every copy has its own independent databases.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("Use one installation of Bibledit-Web.") ?>
  <?php echo Locale_Translate::_("Give various users read or write access to varous Bibles.") ?>
  <?php echo Locale_Translate::_("Users with write access together constitute a translation team that can edit the Bible.") ?>
</li>
</ol>

<h2><?php echo Locale_Translate::_("Sword module repository") ?></h2>
<p>
  <?php echo Locale_Translate::_("Bibledit-Web can export Bibles to a Sword module.") ?>
  <?php echo Locale_Translate::_("It will store the module in a location accessible through the web server.") ?>
  <?php echo Locale_Translate::_("You can also create a Sword module repository.") ?>
  <?php echo Locale_Translate::_("This enables users to do an online installation of the Bible in their Sword front-end.") ?>
  <?php echo Locale_Translate::_("To create a Sword module repository, install an anonymous FTP server, and set the root for anonymous access to the folder with exported Bibles.") ?>
</p>
<p><a href="ftpserver.php"><?php echo Locale_Translate::_("Install FTP server on Ubuntu Server.") ?></a></p>

<h2><?php echo Locale_Translate::_("Install development version") ?></h2>
<p>
  <?php echo Locale_Translate::_("Read the instructions for a standard Bibledit-Web installation to find out about server setup and prerequisites.") ?>
</p>
<br>
<p>
  <?php echo Locale_Translate::_("The Bibledit-Web code is kept in a git repository.") ?>
  <a href="https://savannah.nongnu.org/projects/bibledit-web" target="_blank"><?php echo Locale_Translate::_("The repository is accessible from the Savannah Project Page.") ?></a>
  <?php echo Locale_Translate::_("To view the code on the web, click Source Code - Browse Sources Repository.") ?>
  <?php echo Locale_Translate::_("To use the repository in another way, click on Source Code - Use Git.") ?>
  <?php echo Locale_Translate::_("Information will be provided there.") ?>
  <?php echo Locale_Translate::_("The code can be checked out from the repository.") ?>
  <?php echo Locale_Translate::_("This gives the most recent version of Bibledit-Web.") ?>
  <?php echo Locale_Translate::_("The code is supported.") ?>
</p>
<br>
<p>
  <?php echo Locale_Translate::_("To get the most recent code, run the following in a terminal:") ?>
</p>
<p><code>$ git clone git://git.savannah.nongnu.org/bibledit-web</code></p>
<p>
  <?php echo Locale_Translate::_("This clones the code repository to your computer.") ?>
  <?php echo Locale_Translate::_("It will create directory") ?>
  <code>bibledit-web</code>.
  <?php echo Locale_Translate::_("Change into that directory.") ?>
  <?php echo Locale_Translate::_("Then create an installation package:") ?>
</p>
<p><code>$ ./scripts/package</code></p>
<p>
  <?php echo Locale_Translate::_("It will display where the package will be stored.") ?>
  <?php echo Locale_Translate::_("This package can be used to do a standard installation of Bibledit-Web.") ?>
</p>

<h2><?php echo Locale_Translate::_("Open installation") ?></h2>
<p>
  <?php echo Locale_Translate::_("You can configure Bibledit-Web to be open.") ?>
  <?php echo Locale_Translate::_("It means that there is no need to login.") ?>
  <?php echo Locale_Translate::_("The website appears to be logged in as user 'admin' to any visitor.") ?>
  <?php echo Locale_Translate::_("This is useful for demo installations, or to provide a free service to the the community.") ?>
  <?php echo Locale_Translate::_("A disadvantage is that the crawlers of the search engines keep clicking links, and will disturb data and settings.") ?>
  <?php echo Locale_Translate::_('For Bibledit-Web 1.4 and higher, open the following file:') ?>
  <code>config/open.php</code>.
  <?php echo Locale_Translate::_('Update one line as follows:') ?>
  <code>$open_installation = true;</code>
</p>

<h2><?php echo Locale_Translate::_("Shared hosting") ?></h2>
<p>
  <?php echo Locale_Translate::_("It is possible to install Bibledit-Web on a shared Linux hosting account.") ?>
  <?php echo Locale_Translate::_("The hosting provider may not be happy with the resources Bibledit-Web uses.") ?>
  <?php echo Locale_Translate::_("Bibledit-Web needs its regular tasks to run every minute.") ?>
  <?php echo Locale_Translate::_("It has been seen that a hosting provider changed the tasks to run every five minutes instead of every minute.") ?>
  <?php echo Locale_Translate::_("Bibledit-Web would not be fully operational in such a case.") ?>
  <?php echo Locale_Translate::_("Installing Bibledit-Web on a virtual Linux machine would be better in such a case.") ?>
</p>
