<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h1><?php echo Locale_Translate::_("Install Bibledit-Web 1.7 (not yet released) on Microsoft Windows") ?></h1>
<p>
  <?php echo Locale_Translate::_("This assumes a standard installation of the operating system.") ?>
  <?php echo Locale_Translate::_("Bibledit-Web runs on all recent versions of Windows.") ?>
  <?php echo Locale_Translate::_("The steps below have been tested on Windows 7.") ?>
</p>

<ol>

<li>
<p>
  <?php echo Locale_Translate::_("Download the 32 bits Cygwin installer:") ?>
  <a href="http://www.cygwin.com" target="_blank">http://www.cygwin.com</a>.
</p>
<p>
  <a href="https://sourceware.org/cygwinports" target="_blank"><?php echo Locale_Translate::_("Bibledit depends on Cygwin Ports.") ?></a>
  <?php echo Locale_Translate::_("The reason for using the 32 bits version is that not all applications have been ported to 64 bits yet.") ?>
</p>
</li>

<li>
<p><?php echo Locale_Translate::_("Start the Windows Command Prompt.") ?></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Run the Cygwin installer from the Windows Command Prompt:") ?></p>
<p><code>setup-x86.exe -K http://cygwinports.org/ports.gpg</code></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Install it for All Users.") ?></p>
<p><code></code></p>
</li>

<li>
<p>
  <?php echo Locale_Translate::_("On the Choose Download Site(s) page, select a distro mirror.") ?>
</p>
<p>
  <?php echo Locale_Translate::_("Add the following URL in the User URL field:") ?>
</p>
<p>
  ftp://ftp.cygwinports.org/pub/cygwinports
</p>
<p>
  <?php echo Locale_Translate::_("Press button Add.") ?>
</p>
<p>
  <?php echo Locale_Translate::_("Make sure that both download sites are highlighted.") ?>
</p>
</li>

<li>
<p><?php echo Locale_Translate::_("Proceed, and install the following packages, plus their dependencies:") ?></p>
<p>apache2</p>
<p>apache2-mod_php5</p>
<p>php-iconv</p>
<p>php-json</p>
<p>php-mbstring</p>
<p>php-pdo_sqlite</p>
<p>php-posix</p>
<p>php-simplexml</p>
<p>php-tidy</p>
<p>php-sqlite3</p>
<p>php-xmlreader</p>
<p>php-xmlwriter</p>
<p>cygrunsrv</p>
<p>cron</p>
</li>

<li>
<p><?php echo Locale_Translate::_("Wait till the packages have been installed.") ?></p>
<p><code></code></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Install a shortcut to the desktop.") ?></p>
<p><code></code></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Update the Apache configuration:") ?></p>
<p><?php echo Locale_Translate::_("Edit the following file in Notepad++:") ?></p>
<p><code>C:\cygwin\etc\apache2\httpd.conf</code></p>
<p><?php echo Locale_Translate::_("In that file, search for:") ?></p>
<p><code>DirectoryIndex index.html</code></p>
<p><?php echo Locale_Translate::_("Change that line to to:") ?></p>
<p><code>DirectoryIndex index.php index.html</code></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Start the 'Cygwin64 Terminal' as Administrator.") ?></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Configure cygserver:") ?></p>
<p><code>$ cygserver-config</code></p>
<p><?php echo Locale_Translate::_("Install cygserver as a service.") ?></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Start the service:") ?></p>
<p><code>$ net start cygserver</code></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Start the cron server:") ?></p>
<p><code>$ /usr/sbin/cron</code></p>
<p><?php echo Locale_Translate::_("Start the cron server each time after switching the computer on.") ?></p>
</li>

<li>
<p><?php echo Locale_Translate::_("Start the web server:") ?></p>
<p><code>$ /usr/sbin/httpd2 -k start</code></p>
<p><?php echo Locale_Translate::_("Start the web server each time after switching the computer on.") ?></p>
</li>

<li>
<p>
  <?php echo Locale_Translate::_("To verify Apache is running, point your browser to:") ?>
  <a href="http://localhost/" target="_blank">​http://localhost</a>.
  <?php echo Locale_Translate::_("The page should say:") ?>
  It works!
</p>
</li>

<li>
<p><?php echo Locale_Translate::_("Install Zend Framework version 1 (version 2 is not yet supported):") ?></p>
<p><a href="http://framework.zend.com/downloads/latest" target="_blank"><?php echo Locale_Translate::_("Download a Minimal release.") ?></a></p>
<p><?php echo Locale_Translate::_("Unpack it in the following directory:") ?></p>
<p><code>C:\cygwin\srv\www\htdocs</code></p>
</li>

<li>
<p>
  <a href="http://download.savannah.nongnu.org/releases/bibledit-web/source/bibledit-web-1.7.zip" target="_blank"><?php echo Locale_Translate::_("Download") ?>  Bibledit-Web 1.7</a>.
  Or if version 1.7 is not yet available,
  <a href="http://bibleconsultants.nl/downloads/temporal" target="_blank">download the most recent version of bibledit-web-1.6</a>.
</p>
</li>

<li>
<p><?php echo Locale_Translate::_("Unzip Bibledit-Web into this folder:") ?> <code>C:\cygwin\srv\www\htdocs</code></p>
</li>

<li>
<p>
  <?php echo Locale_Translate::_("To configure Bibledit-Web, point your browser to:") ?>
  <a href="http://localhost/bibledit-web" target="_blank">​http://localhost/bibledit-web</a>.
  <?php echo Locale_Translate::_("Follow all the steps in the browser.") ?>
</p>
</li>

<li>
<p>
  <?php echo Locale_Translate::_("To use Bibledit-Web, point your browser to the same address:") ?>
  <a href="http://localhost/bibledit-web" target="_blank">​http://localhost/bibledit-web</a>.
</p>
</li>

</ol>

<p>
  <?php echo Locale_Translate::_("Currently there are still problems with Bibledit-Web on Windows.") ?>
  <?php echo Locale_Translate::_("These should be solved in a later version.") ?>
</p>
