/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */

package data;

import java.io.PrintStream;
import java.util.Iterator;

import data.Wrappers.ListWrapper;

public class Bogen {

	private static final long serialVersionUID = 1L;

	public static final String PUNKT_KEIN = "0";

	public static final String PUNKT_EIN = "1";

	public static final String PUNKT_ZWEI = "2";

	public static final String PUNKT_DREI = "3";

	public static final String PUNKT_VIER = "4";

	public static final String PUNKT_FUENF = "5";

	public static final int MAX_PUNKTE = 5;

	public static final int ANMERKUNGEN_MAX_LEN = 120;

	public static final String[] kategorien = { "Unterhaltungswert",
			"Pornofaktor", "Gewaltdarstellung", "Gewaltverherrlichung",
			"Niveau", "Sexismus", "Professionalität", "Realismus" };

	public static final String[] texKategorien = { "bmUnterhaltungswert",
			"bmPornofaktor", "bmGewaltdarstellung", "bmGewaltverherrlichung",
			"bmNiveau", "bmSexismus", "bmProfessionalitaet", "bmRealismus" };

	public static final String texMakeBMovieBogen = "bmMakeBMovieBogen";

	public static final String[] TEXTFELDER = { "titel", "originaltitel",
			"land", "jahr", "genre", "fsk", "technisch", "inhalt",
			"wissenschaft", "bild", "handlung", "bemerkungen" };

	protected static int laengsteKategorie = 0;
	protected static int laengsterLinkTyp = 0;
	
	public final static int I_TITEL = 0;

	public final static int I_ORIGINALTITEL = 1;

	public final static int I_LAND = 2;

	public final static int I_JAHR = 3;

	public final static int I_GENRE = 4;

	public final static int I_FSK = 11;

	public final static int I_TECHNISCH = 6;

	public final static int I_INHALT = 7;

	public final static int I_WISSENSCHAFT = 8;

	public final static int I_BILD = 9;

	public final static int I_HANDLUNG = 10;

	public final static int I_BEMERKUNGEN = 5;

	public final static int I_MAX_INDEX = 12;
	public final static int I_MAX_DOCUMENT = 11;
	
	public final static String[] LINK_TYPES = {
			"UNBEKANNT",
			"IMDB(De)",
			"IMDB(En)",
			"Wiki(De)",
			"Wiki(En)",
			"VideoRaiders"
	};
	
	public final static String[] FSK_TYPES = {
		"unbekannt", "0", "6", "12",	"16", "18", "Keine Freigabe", "Indiziert", "Beschlagnahmt"  
	};

	protected int[] punkte;

	// protected String[] anmerkungen;

	protected Wrappers.StringWrapper[] anmerkungen;

	protected Wrappers.StringWrapper[] texte;

	protected Wrappers.ListWrapper<String> zitate;
	
	protected Wrappers.LinkList links;
	
	protected Wrappers.StringWrapper cover;

	public Bogen() {
		punkte = new int[kategorien.length];
		for (int i = 0; i < punkte.length; i++) {
			punkte[i] = 0;
		}

		texte = new Wrappers.StringWrapper[I_MAX_INDEX];

		anmerkungen = new Wrappers.StringWrapper[kategorien.length];
		for (int i = 0; i < kategorien.length; i++) {
			anmerkungen[i] = new Wrappers.StringWrapper("", 25);
		}

		texte[I_TITEL] = new Wrappers.StringWrapper("unbekannt");
		texte[I_ORIGINALTITEL] = new Wrappers.StringWrapper("unbekannt");
		texte[I_LAND] = new Wrappers.StringWrapper("unbekannt");
		texte[I_GENRE] = new Wrappers.StringWrapper("unbekannt");
		texte[I_JAHR] = new Wrappers.IntWrapper(0, 4);
		texte[I_FSK] = new Wrappers.StringWrapper("unbekannt");
		texte[I_TECHNISCH] = new Wrappers.TextWrapper("Dem Publikum ist nichts aufgefallen");
		texte[I_INHALT] = new Wrappers.TextWrapper(
				"Dem Publikum ist nichts aufgefallen");
		texte[I_WISSENSCHAFT] = new Wrappers.TextWrapper(
				"Dem Publikum ist nichts aufgefallen");
		texte[I_BILD] = new Wrappers.TextWrapper(
				"Dem Publikum ist keines aufgefallen");
		texte[I_HANDLUNG] = new Wrappers.TextWrapper(
				"Dem Publikum ist keine aufgefallen");
		texte[I_BEMERKUNGEN] = new Wrappers.TextWrapper(
				"Dem Publikum erscheint nichts bemerkenswert");

		zitate = new ListWrapper<String>();
		links = new Wrappers.LinkList();
		cover = new Wrappers.StringWrapper("");

	}

	public void printTex(PrintStream out) {

		// Latex - Header ausgeben
		out.print("\\documentclass [11pt]{article}");
		out.println();
		out.print("\\usepackage[utf8]{inputenc}");
		out.println();
		out.print("\\usepackage[ngerman]{babel}");
		out.println();
		out.print("\\usepackage {a4wide}");
		out.println();
		out.print("\\usepackage{bmovie}");
		out.println();
		out.print("\\begin{document}");
		out.println();

		for (int index = 0; index < punkte.length; index++) {
			if (punkte[index] > 0) {
				out.print("\\" + texKategorien[index]);
				if (this.anmerkungen[index] != null) {
					out.print("[" + anmerkungen[index] + "]");
				}
				out.print("{" + punkte[index] + "}");
				out.println();
			}
		}

		out.println("\\bmTechnisch{" + getText(I_TECHNISCH) + "}");
		out.println("\\bmWissenschaft{" + getText(I_WISSENSCHAFT) + "}");
		out.println("\\bmInhalt{" + getText(I_INHALT) + "}");
		out.println("\\bmBild{" + getText(I_BILD) + "}");
		out.println("\\bmHandlung{" + getText(I_HANDLUNG) + "}");
		out.println("\\bmBemerkungen{" + getText(I_BEMERKUNGEN) + "}");

		out.println("\\bmZitate{");
		Iterator<String> it = zitate.iterator();
		while (it.hasNext()) {
			String zitat = it.next();
			// Anfuehrungszeichen konvertieren
			int oeffnend = 0;
			for(int i = 0; i < zitat.length(); i++) {
				if(zitat.charAt(i) == '\"') {
					System.out.print("\" entdeckt");
					switch(oeffnend) {
					case 0:
						System.out.println("  oeffnendes \"");
						zitat = zitat.replaceFirst("\"", "``");
						break;
					case 1: 
						zitat = zitat.replaceFirst("\"", "\'\'");
						break;
					default:
						throw new RuntimeException();
					}
					oeffnend = 1 - oeffnend;
				}
			}
			System.out.println(zitat);
			out.println(zitat);
			if(it.hasNext()) {
				out.println("\\\\");
			}
		}
		out.println("}");

		out.println("\\" + texMakeBMovieBogen + "{" + getText(I_TITEL) + "}{"
				+ getText(I_LAND) + "}{" + getText(I_ORIGINALTITEL) + "}{"
				+ getText(I_JAHR) + "}{" + getText(I_FSK) + "}{"
				+ getText(I_GENRE) + "}");
		out.print("\\end{document}");
		out.println();
	}

	public void printXML(PrintStream out) {

		XML xml = new XML(this);
		xml.printHeader(out);
		xml.printBMovie(out);

	}

	static {

		for (int index = 0; index < kategorien.length; index++) {
			if (kategorien[index].length() > kategorien[laengsteKategorie]
					.length()) {
				laengsteKategorie = index;
			}
		}
		for (int index = 0; index < LINK_TYPES.length; index++) {
			if (LINK_TYPES[index].length() > LINK_TYPES[laengsterLinkTyp]
					.length()) {
				laengsterLinkTyp = index;
			}
		}
	}

	public static int getLaengsteKategorie() {
		return laengsteKategorie;
	}

	public static int getLaengsterLinkTyp() {
		return laengsterLinkTyp;
	}
	
	public String getAnmerkung(int index) throws IllegalArgumentException {
		if (index >= anmerkungen.length) {
			throw new IllegalArgumentException();
		}
		return anmerkungen[index].getS();
	}

	public void setAnmerkungen(int index, String anmerkung)
			throws IllegalArgumentException {
		if (index >= anmerkungen.length) {
			throw new IllegalArgumentException();
		}
		this.anmerkungen[index].setS(anmerkung);
	}

	public int getPunkt(int index) throws IllegalArgumentException {
		if (index >= punkte.length) {
			throw new IllegalArgumentException();
		}
		return punkte[index];
	}

	public void setPunkt(int index, int punkt) throws IllegalArgumentException {
		if (index >= punkte.length || punkt > MAX_PUNKTE || punkt < 0) {
			throw new IllegalArgumentException();
		}

		this.punkte[index] = punkt;
	}

	public void setText(int i, String s) {
		if (i < 0 || i > I_MAX_INDEX) {
			throw new IllegalArgumentException();
		}
		this.texte[i].setS(s);
	}

	public String getText(int i) {
		if (i < 0 || i > I_MAX_INDEX) {
			throw new IllegalArgumentException();
		}
		return this.texte[i].getS();
	}

	public Wrappers.StringWrapper getTextWrapper(int i) {
		if (i < 0 || i > I_MAX_INDEX) {
			throw new IllegalArgumentException();
		}
		return texte[i];
	}

	public Wrappers.StringWrapper[] getTextWrappers() {
		return texte;
	}

	public void setTitel(String titel) {
		if (titel == null) {
			throw new IllegalArgumentException();
		}
		this.setText(I_TITEL, titel);
	}

	public String getTitel() {
		return getText(I_TITEL);
	}

	public void setFSK(int fsk) {
		if(fsk < 0 || fsk >= Bogen.FSK_TYPES.length) {
			throw new IllegalArgumentException();
		}
		texte[I_FSK].setS(Bogen.FSK_TYPES[fsk]);
	}

	public String getFSK() {
		return texte[I_FSK].getS();
	}

	public String getGenre() {
		return getText(I_GENRE);
	}

	public void setGenre(String genre) {
		if (genre == null) {
			throw new IllegalArgumentException();
		}
		this.setText(I_GENRE, genre);
	}

	public int getJahr() {
		return ((Wrappers.IntWrapper) texte[I_JAHR]).getInt();
	}

	public void setJahr(int jahr) {
		((Wrappers.IntWrapper) texte[I_JAHR]).setInt(jahr);
	}

	public void setJahr(String s) {
		setText(I_JAHR, s);
	}

	public String getLand() {
		return getText(I_LAND);
	}

	public void setLand(String land) {
		setText(I_LAND, land);
	}

	public String getOriginalTitel() {
		return getText(I_ORIGINALTITEL);
	}

	public void setOriginalTitel(String originalTitel) {
		setText(I_ORIGINALTITEL, originalTitel);
	}

	public Wrappers.StringWrapper getTitelWrapper() {
		return texte[I_TITEL];
	}

	public Wrappers.StringWrapper getOriginalTitelWrapper() {
		return texte[I_ORIGINALTITEL];
	}

	public Wrappers.StringWrapper getLandWrapper() {
		return texte[I_LAND];
	}

	public Wrappers.StringWrapper getGenreWrapper() {
		return texte[I_GENRE];
	}

	public Wrappers.IntWrapper getJahrWrapper() {
		return (Wrappers.IntWrapper) texte[I_JAHR];
	}

	public Wrappers.StringWrapper getTechnischWrapper() {
		return texte[I_TECHNISCH];
	}

	public Wrappers.StringWrapper getInhaltWrapper() {
		return texte[I_INHALT];
	}

	public Wrappers.StringWrapper getWissenschaftWrapper() {
		return texte[I_WISSENSCHAFT];
	}

	public Wrappers.StringWrapper getBildWrapper() {
		return texte[I_BILD];
	}

	public Wrappers.StringWrapper getHandlungWrapper() {
		return texte[I_HANDLUNG];
	}

	public Wrappers.StringWrapper getBemerkungenWrapper() {
		return texte[I_BEMERKUNGEN];
	}

	public Wrappers.IntWrapper getFSKWrapper() {
		return (Wrappers.IntWrapper) texte[I_FSK];
	}

	public Wrappers.StringWrapper getAnmerkungWrapper(int i) {
		if (i < 0 || i >= kategorien.length) {
			throw new IllegalArgumentException();
		}
		return anmerkungen[i];
	}

	public Wrappers.ListWrapper<String> getZitate() {
		return zitate;
	}

	public Wrappers.LinkList getLinks() {
		return links;
	}

	public Wrappers.StringWrapper getCover(){
		return cover;
	}
	
	public String toString() {
		String str = getText(I_TITEL) + "    " + getText(I_LAND) + "   "
				+ getText(I_ORIGINALTITEL) + "   " + getText(I_JAHR) + "   "
				+ getText(I_FSK) + "   " + getText(I_GENRE) + "\n";

		for (int index = 0; index < punkte.length; index++) {
			if (punkte[index] > 0) {
				if (this.anmerkungen[index] != null) {
					str = str + "[" + anmerkungen[index] + "]  ";
				}
				str = str + punkte[index] + "\n";
			}
		}
		str = str + getText(I_TECHNISCH) + "\n" + getText(I_WISSENSCHAFT)
				+ "\n" + getText(I_INHALT) + "\n" + getText(I_BILD) + "\n"
				+ getText(I_HANDLUNG) + "\n" + getText(I_BEMERKUNGEN) + "\n";

		str = str + "Zitate:\n";
		Iterator<String> it = zitate.iterator();
		while (it.hasNext()) {
			str = str + it.next() + "\n";
		}
		
		return str;
	}
}
