/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileNameExtensionFilter;

import data.Bogen;
import data.XML;

public class HauptMenue extends JMenuBar {

	private static final long serialVersionUID = 1L;

	protected Gui gui;

	protected static class ExportTexListener implements ActionListener {

		HauptMenue menue;

		public ExportTexListener(HauptMenue menue) {
			if (menue == null) {
				throw new IllegalArgumentException();
			}
			this.menue = menue;
		}

		public void actionPerformed(ActionEvent e) {
			FileOutputStream fileOut = null;
			PrintStream out = null;
			try {
				fileOut = new FileOutputStream(menue.gui.getBogen().getTitel()
						.toLowerCase().replaceAll(" ", "_")
						+ ".tex", false);
				out = new PrintStream(fileOut);
			} catch (FileNotFoundException ex) {
				System.err.println("Konnte Datei nicht oeffnen");
			}
			if (out != null) {
				this.menue.gui.getBogen().printTex(out);
			}
		}
	}

	protected static class ExportXMLListener implements ActionListener {

		HauptMenue menue;

		public ExportXMLListener(HauptMenue menue) {
			if (menue == null) {
				throw new IllegalArgumentException();
			}
			this.menue = menue;
		}

		public void actionPerformed(ActionEvent e) {
			FileOutputStream fileOut = null;
			PrintStream out = null;
			try {
				fileOut = new FileOutputStream(menue.gui.getBogen().getTitel()
						.toLowerCase().replaceAll(" ", "_")
						+ ".xml", false);
				out = new PrintStream(fileOut);
			} catch (FileNotFoundException ex) {
				System.err.println("Konnte Datei nicht oeffnen");
			}
			if (out != null) {
				this.menue.gui.getBogen().printXML(out);
			}
		}
	}

	protected static class LadenListener implements ActionListener {

		HauptMenue menue;

		Gui gui;

		public LadenListener(Gui gui) {
			if (gui == null) {
				throw new IllegalArgumentException();
			}
			this.gui = gui;
		}

		public void actionPerformed(ActionEvent e) {
			File file;
			FileInputStream fileIn = null;
			InputStreamReader in = null;
			JFileChooser chooser = new JFileChooser();
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"XML-Dateien", "xml", "XML");
			chooser.setFileFilter(filter);

			int returnVal = chooser.showOpenDialog(gui);
			if (returnVal != JFileChooser.APPROVE_OPTION) {
				return;
			}

			file = chooser.getSelectedFile();
			try {
				fileIn = new FileInputStream(file);
			} catch (FileNotFoundException ex) {
				System.err.println("Laden: " + file.getName()
						+ " nicht gefunden");
				return; // throw new RuntimeException();
			}
			in = new InputStreamReader(fileIn);
			Bogen bogen = XML.readXML(in, null);
			if (bogen != null) {
				System.out.println("Laden: Bogen erzeugt");
				System.out.println(bogen);
				gui.setBogen(bogen);

			}
		}
	}

	
	public static class BeendenListener implements ActionListener{

		protected Gui gui;
		
		public BeendenListener(Gui gui){
			if(gui == null){
				throw new IllegalArgumentException();
			}
			this.gui = gui;
		}
		
		public void actionPerformed(ActionEvent e) {
			// Gui das Signal zum Terminieren senden...
			gui.terminate();
		}
		
	}
	
	
	protected void erzeugeEintrag(String bez, ActionListener aL, JMenu m, int mn) {
		// Eintrag anlegen
		JMenuItem mi = new JMenuItem(bez);
		if (mn != 0)
			mi.setMnemonic(mn);
		else
			mi = new JMenuItem(bez);

		// actionlistener setzen
		mi.addActionListener(aL);

		// und menue anfuegen
		m.add(mi);
	}

	/**
	 * der einzige Konstruktor, wird benutzt, um das ganze menu herzustellen
	 */
	public HauptMenue(Gui gui, int appType) {
		super();

		if (gui == null) {
			throw new IllegalArgumentException();
		}
		this.gui = gui;

		JMenu daten = new JMenu("Daten");

		// Bei einem Applet waere Laden/Speichern wegen den Sicherheitspolicies
		// nur
		// umstaendlich zu handhaben, daher bei Applet/Servlet die betreffenden
		// Menuepunkte gar nicht
		// erst erzeugen
		if (appType == 0) {
			erzeugeEintrag("Laden", new LadenListener(gui), daten,
					KeyEvent.VK_L);

			erzeugeEintrag("Speichern", new ExportXMLListener(this), daten,
					KeyEvent.VK_S);

			erzeugeEintrag("Exportiere nach Tex", new ExportTexListener(this),
					daten, KeyEvent.VK_T);
		}

		erzeugeEintrag("Sende an Server", new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// TODO: Implement
			}
		}, daten, KeyEvent.VK_S);

		add(daten);
		
		JMenuItem beenden = new JMenuItem("Beenden");
		beenden.addActionListener(new BeendenListener(gui));
		add(beenden);

	}

}
