/*
/#SYSTEM file en/decoder
*/

#include <stdio.h>
#include <limits.h>
#include <errno.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/unistd.h>

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;

typedef uint8_t BYTE; /* 1-byte integer */
typedef uint16_t WORD; /* 2-byte integer */
typedef uint32_t DWORD; /* 4-byte integer */
typedef uint64_t QWORD; /* 8-byte integer */

static WORD get_WORD( BYTE* b );
static DWORD get_DWORD( BYTE* b );
static QWORD get_QWORD( BYTE* b );
static WORD fread_WORD( FILE* f );
static DWORD fread_DWORD( FILE* f );
static QWORD fread_QWORD( FILE* f );

BYTE* buf = NULL;
uint buflen = 0;
char name[1000];

int main( int argc, char* argv[] ){
	uint i;
	for( i = 1; i <= argc; i++ ){
		FILE* f;
		f = fopen( argv[i], "rb" );
		if( f ){
			BYTE cl[4];
			DWORD version;
			fread( cl, 4, 1, f );
			version = get_DWORD( &cl[0] );
			printf( "File = %s\n\n", argv[i] );
			printf( "Version = %u\n\n", version );
			if( version!= 3 ) printf( "WARNING: unknown version\n", version );
			while( !feof(f) ){
				WORD code, len;
				fread( cl, 4, 1, f );
				code = get_WORD( &cl[0] );
				len = get_WORD( &cl[2] );
				if(feof(f)) break;
				printf( "Code %u entry (%u bytes long)\n", code, len );
				if( buflen < len ){
					BYTE* t = (BYTE*)realloc( buf, len+1 );
					if( !t ){
						printf( "ERROR: Not enough RAM\n" );
						return 1;
					}
					buf = t;
					buflen = len;
				}
				fread( buf, len, 1, f ); buf[len] = 0;
				{
					sprintf( name, "Code %u", code );
					mkdir( name, 0666 );
					chdir( name );
					{
						FILE* out = fopen( argv[i], "wb" );
						if(out){
							fwrite( buf, len, 1, out );
							fclose( out );
						}
					}
					chdir( ".." );
				}
				switch(code){
					case 0:
						printf( "Contents file=%s\n", buf );
					break;
					case 1:
						printf( "Index file=%s\n", buf );
					break;
					case 2:
						printf( "Default topic=%s\n", buf );
					break;
					case 3:
						printf( "Title=%s\n", buf );
					break;
					case 4:
						if( len == 36 ) printf( "WARNING: Code 4 entry is long version (36 bytes)\n" );
						else if( len != 28 ) printf( "WARNING: Code 4 entry has wrong length\n" );
						printf( "Language=0x%x\n", get_DWORD( buf ) );
						printf( "DBCS=%s\n", get_DWORD( buf+4 ) ? "Yes" : "No" );
						printf( "Full-text search=%s\n", get_DWORD( buf+8 ) ? "Yes" : "No" );
						if( get_DWORD( buf+12 ) ) printf( "This chm allegedly has KLinks\n" );
						if( get_DWORD( buf+16 ) ) printf( "This chm allegedly has ALinks\n" );
						{
							QWORD ft = get_QWORD( buf+24 );
							printf( "Creation Time (system flag): %llu 100-nanosecond intervals since January 1, 1601\n", ft );
						}
					break;
					case 5:
						printf( "Default Window=%s\n", buf );
					break;
					case 6:
						printf( "Compiled file=%s\n", buf );
					break;
					case 7:
						if( len != 4 ) printf( "WARNING: Code 7 entry has wrong length\n" );
						printf( "0x%x\n", get_DWORD( buf ) );
					break;
					case 8:
					break;
					case 9:
						printf( "Compiled with %s\n", buf );
					break;
					case 10:
						if( len != 4 ) printf( "WARNING: Code 10 entry has wrong length\n" );
						printf( "Creation Time (time tag): %u seconds since midnight, January 1, 1970 UTC\n", get_DWORD( buf ) );
					break;
					case 11:
						if( len != 4 ) printf( "WARNING: Code 11 entry has wrong length\n" );
						printf( "0x%x\n", get_DWORD( buf ) );
					break;
					case 12:
						if( len != 4 ) printf( "WARNING: Code 12 entry has wrong length\n" );
						printf( "%u information type(s)\n", get_DWORD( buf ) );
					break;
					case 13:
					break;
					case 14:
						{
							BYTE* s = buf+4;
							DWORD n = get_DWORD( buf );
							printf( "%u custom tab(s)\n", n );
							fread( buf, len-4, 1, f ); buf[len-4] = 0;
							while(n){
								printf( "Custom tab=\"%s\", ", s );
								s += strlen(s) + 1;
								printf( "%s\n", s );
								n --;
							}
						}
					break;
					case 15:
						if( len != 4 ) printf( "WARNING: Code 15 entry has wrong length\n" );
						printf( "Information type checksum is 0x%x\n", get_DWORD( buf ) );
					break;
					case 16:
						printf( "Default Font=%s\n", buf );
					break;
					default:
						printf( "WARNING: Code %u is new!!\n", code );
				}
				
				printf( "\n" );
	
			}
			fclose( f );
		}
	}
	return 0;
}

static WORD get_WORD( BYTE* b ){
	return b[0] | (b[1] << 8);
}

static DWORD get_DWORD( BYTE* b ){
	return b[0] | (b[1] << 8) | (b[2] << 16) | (b[3] << 24);
}

static QWORD get_QWORD( BYTE* b ){
	return b[0] | (b[1] << 8) | (b[2] << 16) | (b[3] << 24)
		| ((QWORD)b[4] << 32) | ((QWORD)b[5] << 40) | ((QWORD)b[6] << 48) | ((QWORD)b[7] << 56);
}

static WORD fread_WORD( FILE* f ){
	BYTE b[2]; fread( b, 2, 1, f );
	return b[0] | (b[1] << 8);
}

static DWORD fread_DWORD( FILE* f ){
	BYTE b[4]; fread( b, 4, 1, f );
	return b[0] | (b[1] << 8) | (b[2] << 16) | (b[3] << 24);
}

static QWORD fread_QWORD( FILE* f ){
	BYTE b[8]; fread( b, 8, 1, f );
	return b[0] | (b[1] << 8) | (b[2] << 16) | (b[3] << 24)
		| ((QWORD)b[4] << 32) | ((QWORD)b[5] << 40) | ((QWORD)b[6] << 48) | ((QWORD)b[7] << 56);
}


/*
DWORD sv = 3; //* /#SYSTEM file version 

typedef _SYSTEM_entry_t{
	WORD code;
	WORD length;
	BYTE* data;
} SYSTEM_entry_t;

SYSTEM_entry_t SYSTEM_Default_Font = { 16, HHP_OPTIONS_Default_Font_len, HHP_OPTIONS_Default_Font_len };

int fwrite_SYSTEM(FILE* f){
	fwrite_DWORD( f, sv );

	fwrite_WORD( f, item.code );
	fwrite_WORD( f, item.length );
	switch( item.code ){
		case 0: break;
		case 0: break;
		default:
			printf( "BUG: Invalid /#SYSTEM file code (%u)", item.code );
			exit( -1 );
	}
}

*/