/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

var Form1 = getForm();
var Textarea1 = getTextarea();

function ButtonClick(code)
{
  // tag zum text hinzufgen und button-text aktualisieren
  var ClickedButton = eval('Form1.bbcode_' + code);
  var ButtonValue = new String(ClickedButton.value);
  if(ButtonValue.substr(-1) != "*")
  {
    // tag ffnen
    ClickedButton.value += '*';
    switch(code)
    {
      case 'b':
        tag = '[b]'; break;
      case 'i':
        tag = '[i]'; break;
      case 'u':
        tag = '[u]'; break;
      case 's':
        tag = '[s]'; break;
      case 'sub':
        tag = '[sub]'; break;
      case 'sup':
        tag = '[sup]'; break;
      case 'code':
        tag = '[code]'; break;
      case 'quote':
        tag = '[quote]'; break;
      case 'url':
        tag = '[url]'; break;
      case 'email':
        tag = '[email]'; break;
      case 'img':
        tag = '[img]'; break;
      case 'li':
        tag = '[li]'; break;
    }
  }
  else
  {
    // tag schliessen
    ClickedButton.value = ButtonValue.substr(0, ButtonValue.length - 1);
    switch(code)
    {
      case 'b':
        tag = '[/b]'; break;
      case 'i':
        tag = '[/i]'; break;
      case 'u':
        tag = '[/u]'; break;
      case 's':
        tag = '[/s]'; break;
      case 'sub':
        tag = '[/sub]'; break;
      case 'sup':
        tag = '[/sup]'; break;
      case 'code':
        tag = '[/code]'; break;
      case 'quote':
        tag = '[/quote]'; break;
      case 'url':
        tag = '[/url]'; break;
      case 'email':
        tag = '[/email]'; break;
      case 'img':
        tag = '[/img]'; break;
      case 'li':
        tag = '[/li]'; break;
    }
  }
  eval(Textarea1 + '.value += tag');
  eval(Textarea1 + '.focus()');
}

function SelectChange(code)
{
  // tag zum text hinzufgen und gleich schlieen
  var ChangedSelect = eval('Form1.bbcode_' + code);
  if(ChangedSelect.value != 0)
  {
    switch(code)
    {
      case 'font':
        tag = '[font=' + ChangedSelect.value + '][/font]'; break;
      case 'color':
        tag = '[color=' + ChangedSelect.value + '][/color]'; break;
      case 'size':
        tag = '[size=' + ChangedSelect.value + '][/size]'; break;
      case 'list':
        if(ChangedSelect.value == "*")
        {
          tag = '[ulist]\n[/ulist]'
        }
        else
        {
          tag = '[list=' + ChangedSelect.value + ']\n[/list]'; break;
        }
        break;
      case 'align':
        tag = '[align=' + ChangedSelect.value + '][/align]'; break;
    }
    ChangedSelect.selectedIndex = 0;
    eval(Textarea1 + '.value += tag');
  }
  eval(Textarea1 + '.focus()');
}

function AddSmilie(code)
{
  switch(code)
  {
    case ':)':
      tag = ':)'; break;
    case ':D':
      tag = ':D'; break;
    case ':(':
      tag = ':('; break;
    case ';)':
      tag = ';)'; break;
    case ':o':
      tag = ':o'; break;
    case ':shock:':
      tag = ':shock:'; break;
    case ':S':
      tag = ':S'; break;
    case '8)':
      tag = '8)'; break;
    case ':lol:':
      tag = ':lol:'; break;
    case ':x':
      tag = ':x'; break;
    case ':P':
      tag = ':P'; break;
    case ':blush:':
      tag = ':blush:'; break;
    case ':cry:':
      tag = ':cry:'; break;
    case ':evil:':
      tag = ':evil:'; break;
    case ':twisted:':
      tag = ':twisted:'; break;
    case ':roll:':
      tag = ':roll:'; break;
    case ':!:':
      tag = ':!:'; break;
    case ':?:':
      tag = ':?:'; break;
    case ':idea:':
      tag = ':idea:'; break;
    case ':arrow:':
      tag = ':arrow:'; break;
    case ':|':
      tag = ':|'; break;
    case ':mrgreen:':
      tag = ':mrgreen:'; break;
  }
  eval(Textarea1 + '.value += tag');
  eval(Textarea1 + '.focus()');
}

function Info(code)
{
  // info zum code im infotext-input anzeigen
  switch(code)
  {
    case 'b':
      info = 'Fetter Text: [b]Text[/b]'; break;
    case 'i':
      info = 'Kursiver Text: [i]Text[/i]'; break;
    case 'u':
      info = 'Unterstrichener Text: [u]Text[/u]'; break;
    case 's':
      info = 'Durchgestrichener Text: [s]Text[/s]'; break;
    case 'sub':
      info = 'Tiefgestellter Text: [sub]Text[/sub]'; break;
    case 'sup':
      info = 'Hochgestellter Text: [sup]Text[/sup]'; break;
    case 'font':
      info = 'Schriftart: [font=Arial]Text[/font]'; break;
    case 'color':
      info = 'Schriftfarbe: [color=red]Text[/color] auch: color: #FF0000'; break;
    case 'size':
      info = 'Schriftgre: [size=18]Text[/size]'; break;
    case 'code':
      info = 'Monotype-Text: [code]Text[/code]'; break;
    case 'quote':
      info = 'Zitat: [quote]Text[/quote]'; break;
    case 'url':
      info = 'Link: [url]http://link.com[/url] oder: [url=http://link.com]Text[/url]'; break;
    case 'email':
      info = 'E-Mail-Link: [email]mail@link.com[/email] oder: [email=mail@link.com]Text[/url]'; break;
    case 'img':
      info = 'Bild: [img]http://link.com/bild.jpg[/img]'; break;
    case 'list':
      info = 'Liste: [ulist]Text[/ulist] oder: [list=1]Text[/list]'; break;
    case 'li':
      info = 'List-Item: [li]Text[/li]'; break;
    case 'align':
      info = 'Text-Ausrichtung: [align=right]Text[/align]'; break;

    case ':)':
      info = 'Smile: :)'; break;
    case ':D':
      info = 'Breites Grinsen: :D'; break;
    case ':(':
      info = 'Traurig: :('; break;
    case ';)':
      info = 'Zwinkern: ;)'; break;
    case ':o':
      info = 'Staunen: :o'; break;
    case ':shock:':
      info = 'Schockiert: :shock:'; break;
    case ':S':
      info = 'Verwirrt: :S'; break;
    case '8)':
      info = 'Cool: 8)'; break;
    case ':lol:':
      info = 'Lachen: :lol:'; break;
    case ':x':
      info = 'Verrckt: :x'; break;
    case ':P':
      info = 'Zunge rausstrecken: :P'; break;
    case ':blush:':
      info = 'Verlegen: :blush:'; break;
    case ':cry:':
      info = 'Weinen: :cry:'; break;
    case ':evil:':
      info = 'Bse: :evil:'; break;
    case ':twisted:':
      info = 'Sehr bse: :twisted:'; break;
    case ':roll:':
      info = 'Augenrollen: :roll:'; break;
    case ':!:':
      info = 'Ausrufezeichen: :!:'; break;
    case ':?:':
      info = 'Fragezeichen: :?:'; break;
    case ':idea:':
      info = 'Idee: :idea:'; break;
    case ':arrow:':
      info = 'Pfeil: :arrow:'; break;
    case ':|':
      info = 'Neutral: :|'; break;
    case ':mrgreen:':
      info = 'Mr Green: :mrgreen:'; break;
  }
  Form1.infotext.value = info;
}