<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

$boardrechte = getboardrechte($aktboard["id"]);
if($boardrechte["lesen"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

// BB-Code-Parser laden
include("./bbcode_parser.php");
$parser = new HTML_BBCodeParser;

// Smilie-Parser
include("./smilie_parser.php");

// soll ein abo aktualisiert werden?
$aboresult = sql_select("abo_typ", "thread_abos", "WHERE thread_id=".$aktthread["id"]." AND user_id=".$user["id"], NULL, NULL);
if(sql_num_rows($aboresult) != 0) $abo = sql_fetch_assoc($aboresult);
else $abo["abo_typ"] = 0;

if(isset($_POST["update_abo"]))
{
  // thread-abos aktualisieren
  if($abo["abo_typ"] == 0 and $_POST["benachrichtigung"] != 0 and $user["id"] != 1)
  {
    $werte = array("thread_id" => $aktthread["id"], "user_id" => $user["id"], "abo_typ" => $_POST["benachrichtigung"]);
    sql_insert("thread_abos", $werte);
  }
  if($abo["abo_typ"] != 0 and $_POST["benachrichtigung"] != $abo["abo_typ"])
  {
    $werte = array("abo_typ" => $_POST["benachrichtigung"]);
    sql_update("thread_abos", $werte, "WHERE thread_id=".$aktthread["id"]." AND user_id=".$user["id"]);
  }
  if($abo["abo_typ"] != 0 and $_POST["benachrichtigung"] == 0)
  {
    sql_delete("thread_abos", "WHERE thread_id=".$aktthread["id"]." AND user_id=".$user["id"]);
  }
}

// hat der thread eine umfrage?
$umfragen = sql_select("id", "umfragen", "WHERE thread=".$aktthread["id"], NULL, NULL);
// hat er auf "ergebnisse anzeigen" geklickt ?
if(isset($_GET["ergebnis"])) $showergebnis = true;
if(sql_num_rows($umfragen)!=0) include ("./umfrage.php");

// hitcounter fr den thread
if($conf["sql_typ"] == "mysql") mysql_query("UPDATE ".$conf["sql_prefix"]."_threads SET hits=hits+1 WHERE id=".$aktthread["id"].";");
if($conf["sql_typ"] == "postgresql") pg_query("UPDATE ".$conf["sql_prefix"]."_threads SET hits=hits+1 WHERE id=".$aktthread["id"].";");

// start und end werte fr LIMIT feststellen
if(!isset($_GET["seite"]))
{
  $seite = 1;
  $poststart = 0;
}
else
{
  $seite = $_GET["seite"];
  $poststart = ($seite - 1) * $einstellungen["postsperpage"];
}
$postzahl = sql_num_rows(sql_select("*", "posts", "WHERE thread=".$aktthread["id"], NULL, NULL));

// seiten-navigationsleiste
$seitenzahl = ceil($postzahl/$einstellungen["postsperpage"]);
$strseite = "<b>Seite: ";
$startausgeblendet = false;
$endeausgeblendet = false;
for($i = 1; $i <= $seitenzahl; $i++)
{
  if($i < ($seite - 2))
  {
    if($startausgeblendet == false)
    {
      $strseite .= ".. ";
      $startausgeblendet = true;
    }
  }
  if($i > ($seite + 2))
  {
    if($endeausgeblendet == false)
    {
      $strseite .= ".. <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."&amp;seite=".$seitenzahl."\">[letzte Seite]</a>";
      $endeausgeblendet = true;
    }
  }
  if($i <= ($seite + 2) and $i >= ($seite - 2))
  {
    if($i != $seite)
    {
      $strseite .= "<a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."&amp;seite=".$i."\">".$i."</a> ";
    }
    else
    {
      $strseite .= $i." ";
    }
  }
}
$strseite .= "</b><br /><br />";
echo $strseite;

?>
<table class="maintable" width="100%">
<tr class="rowberschrift">
  <td><b>Autor</b></td><td colspan="2"><b>Post</b></td>
</tr>

<?php

$postresult = sql_select("*", "posts", "WHERE thread=".$aktthread["id"]." ORDER BY id ASC", $poststart, $einstellungen["postsperpage"]);

// posts anzeigen
$zeile = 2;

while($post = sql_fetch_assoc($postresult))
{
  ?>
  <tr class="row<?php echo $zeile ?>">
    <td id="<?php echo $post["id"] ?>" width="150" class="postautorfeld">
    <?php
    $posterresult = sql_select("*", "users", "WHERE id=".$post["autor_id"], NULL, NULL);
    if(sql_num_rows($posterresult)!=0)
    {
      //user ist in der datenbank
      $poster = sql_fetch_assoc($posterresult);
      if($poster["id"]!=1)
      {
        if($rechte["memberlist"] == true)
        {
          ?>
          <a href="index.php?action=userinfo&amp;id=<?php echo $poster["id"] ?>"><?php
        }
        ?><b><?php echo htmlspecialchars($poster["username"]) ?></b><?php
        if($rechte["memberlist"] == true)
        {
          ?></a><?php
        }
        ?><br />
        <?php
        // benutzerrang?
        $posterposts = sql_num_rows(sql_select("*", "posts", "WHERE autor_id=".$poster["id"]));
        $posterrank = sql_fetch_assoc(sql_select("*", "userranks", "WHERE minposts<=".$posterposts." ORDER BY minposts DESC", 0, 1));
        echo $posterrank["titel"];
        ?><br />
        <img src="./gfx/userranks/<?php echo $posterrank["icon"] ?>" /><br />
        <br /><br />
        registriert seit: <?php echo date("d.m.Y",$poster["reg_since"] + $zeitoffset) ?><br />
        Posts: <?php echo $posterposts ?><br />
        <?php
      }
      else
      {
        // Gast
        ?>
        <b><?php echo htmlspecialchars($post["autor_name"]) ?></b><br />
        <i>Gast</i>
        <?php
      }
    }
    else
    {
      //gelschter user
      ?>
      <b><?php echo htmlspecialchars($post["autor_name"]) ?></b><br />
      <i>gelschter Benutzer</i>
      <?php
    }
    ?></td>
    <td colspan="2" class="postnachrichtfeld"><b><?php echo $post["titel"] ?></b><br />
    <?php
    if($post["bbcode"] == 1)
    {
      $parser->setText($post["nachricht"]);
      $parser->parse();
      $nachricht = $parser->getParsed();
    }
    else
    {
      $nachricht = $post["nachricht"];
    }
    if($post["smilies"] == 1)
    {
      $nachricht = parse_smilies($nachricht);
    }
    echo str_replace("\n", "<br />\n", $nachricht);

    // signatur?
    if($post["signatur"] == 1)
    {
      if($poster["sig_bbcode"] == 1)
      {
        $parser->setText($poster["signatur"]);
        $parser->parse();
        $signatur = $parser->getParsed();
      }
      else
      {
        $signatur = $poster["signatur"];
      }
      if($poster["sig_smilies"] == 1)
      {
        $signatur = parse_smilies($signatur);
      }
      echo str_replace("\n", "<br />\n", "\n___________________\n".$signatur);
    }
    ?></td>
  </tr>
  <tr class="row<?php echo $zeile ?>">
    <td width="150" class="postdatumfeld"><?php echo date("d.m.Y - H:i:s",$post["created"] + $zeitoffset) ?></td>
    <td align="left" class="postlinksfeld">
    <?php
    // modul-links anzeigen
    if(isset($modlinks["userlinks"]))
    {
        foreach($modlinks["userlinks"] as $modtitel => $modlink)
        {
            if($modlink["gast"] == true or $post["autor_id"] != 1)
            {
                ?>
                <a href="<?php echo str_replace("{userid}", $post["autor_id"], $modlink["link"]) ?>"><?php echo $modlink["text"] ?></a>
                <?php
            }
        }
    }
    
    if($rechte["sendmail"] == true) { ?><a class="alignleft" href="index.php?action=sendmail&amp;id=<?php echo $post["autor_id"] ?>"><?php echo $t_email ?></a><?php } ?>
    </td>
    <td  align="right" class="postlinksfeld"><?php
    if ($boardrechte["moderieren"] == true or ($post["autor_id"]==$user["id"] and $user["id"] != 1))
    {
      ?><a class="alignright" href="index.php?action=moderate&amp;type=editpost&amp;id=<?php echo $post["id"] ?>"><?php echo $t_bearbeiten ?></a><?php
    }
    ?></td>
  </tr>
  <?php
  $zeile++;
  if ($zeile>2) $zeile=1;
}
?>
</table>
<br />
<table class="maintable" width="100%">
<tr class="rowberschrift">
  <td align="left"><b>Legende</b></td>
  <td align="right"><b>Aktionen</b></td>
</tr>
<tr class="row2">
  <td align="left">&nbsp</td><td align="right"><?php
  if($user["id"] != 1)
  {
    $aboresult = sql_select("abo_typ", "thread_abos", "WHERE thread_id=".$aktthread["id"]." AND user_id=".$user["id"], NULL, NULL);
    if(sql_num_rows($aboresult) != 0) $abo = sql_fetch_assoc($aboresult);
    else $abo["abo_typ"] = 0;
    ?>
    <form method="POST" action="index.php?action=viewthread&amp;id=<?php echo $aktthread["id"] ?>">
    Benachrichtigung: <select class="inputtext" name="benachrichtigung" size="1">
    <option value="0"<?php if($abo["abo_typ"] == 0) echo " selected" ?>>keine</option>
    <option value="1"<?php if($abo["abo_typ"] == 1) echo " selected" ?>>einmalig</option>
    <option value="2"<?php if($abo["abo_typ"] == 2) echo " selected" ?>>immer</option>
    </select> <input name="update_abo" type="submit" value="ndern" />
    <?php
  }
  if($boardrechte["moderieren"] == true)
  {
    ?><a href="index.php?action=moderate&amp;type=editthread&amp;id=<?php echo $aktthread["id"] ?>">thread bearbeiten</a> <?php
  }
  if(($boardrechte["threads"] == true or $boardrechte["moderieren"] == true) and ($aktthread["status"]=1))
  {
    ?><a href="index.php?action=newpost&amp;type=post&amp;threadid=<?php echo $aktthread["id"] ?>"><?php echo $t_antworten ?></a><?php
  }
  ?></td>
</tr>
</table>
<br />
<?php echo $strseite ?>