/*****************************************************************************************/
/* Copyright 2008,2009,2010,2011,2012 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007
   The GSL Team. */

/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Tampere University of Technology, Dep. of Signal Processing.
   Moscow, Russia / Tampere, Finland*/
/****************************************************************************************/

#include "init.h"
#include <stdio.h>
#include <gsl/gsl_eigen.h>/* For eigenvalues */
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_linalg.h>
#include <gsl/gsl_permutation.h>

int solver(double x[],double h,int(*func)(double,const double [],double [],void *)) 
{
  int i;
  double k1[DIM],k2[DIM],k3[DIM],k4[DIM];
  double x_help[DIM];


  if(strcmp(mynum.method,"run-kut4")==0){
    // 1-st STEP
    i=1;
    while(i <= DIM){
      x_help[i-1]=*(x+i-1);
      i++;
    }
    func(t,x,f,&mu);i=1;
    while (i <= DIM){
      k1[i-1]=*(f+i-1);
      i++;
    }

    //2-nd STEP
    i=1;
    while(i<=DIM){
      *(x+i-1)=x_help[i-1] + h*k1[i-1]/2;
      i++;
    }
    func(t,x,f,&mu);i=1;
    while(i<=DIM){
      k2[i-1]=*(f+i-1);
      i++;
    }

    //3-rd STEP
    i=1;
    while(i<=DIM){
      *(x+i-1)=x_help[i-1] + h*k2[i-1]/2;
      i++;
    }
    func(t,x,f,&mu);i=1;
    while(i<=DIM){
      k3[i-1]=*(f+i-1);
      i++;
    }

    //4-th STEP
    i=1;
    while(i<=DIM){
      *(x+i-1)=x_help[i-1] + h*k3[i-1];
      i++;
    }
    func(t,x,f,&mu);i=1;
    while(i<=DIM){
      k4[i-1]=*(f+i-1);
      i++;
    }
    //
    //Finally, calculating the next point
    i=1;
    while(i<=DIM){
      *(x+i-1)=x_help[i-1] + h*(k1[i-1] + 2*k2[i-1] + 2*k3[i-1] + k4[i-1])/6;
      i++;
    }
  }
  else if (strcmp(mynum.method,"eu")==0){
    i=1;
    while(i<=DIM){
      x_help[i-1]=*(x+i-1);/*Store x from previous moment*/
      i++;
    }
    func(t,x,f,&mu);/*Compute derivatives*/
    i=1;
    while(i<=DIM){/*Get x for next moment*/
      *(x+i-1) = x_help[i-1] + *(f+i-1)*h;
      i++;
    }
  }
  else {
    fprintf(stderr,"Error: I dont know the method\n");
    return 1;
  }
  return 0;

}


int solver_lin(const double x_0[],double x_lin[],
	       double f_lin[], double h,int(*func)(double,const double [],
	       double [], double [], double [], void *)) 
{
  /*REMEMBER: linear system always takes the current vector x_0, so call
    this function before solver() for nonlinear system which changes
    x_0. x_0 is an attractor values.*/
  int i,j;
  double k1[DIM],k2[DIM],k3[DIM],k4[DIM];
  double x_help[DIM];
  double dfdx[DIM*DIM];
  double dfdt[DIM];

  if(strcmp(mynum.method,"run-kut4")==0){
    // 1-st STEP
    i=1;
    while(i <= DIM){
      x_help[i-1]=*(x_lin+i-1);
      i++;
    }
    jac(t,x_0,dfdx,dfdt,&mu);
    func(t,x_lin,f_lin,dfdx,dfdt,&mu);i=1;
    while (i <= DIM){
      k1[i-1]=*(f_lin+i-1);
      i++;
    }

    //2-nd STEP
    i=1;
    while(i<=DIM){
      *(x_lin+i-1)=x_help[i-1] + h*k1[i-1]/2;
      i++;
    }
    jac(t,x_0,dfdx,dfdt,&mu);
    func(t,x_lin,f_lin,dfdx,dfdt,&mu);i=1;
    while(i<=DIM){
      k2[i-1]=*(f_lin+i-1);
      i++;
    }

    //3-rd STEP
    i=1;
    while(i<=DIM){
      *(x_lin+i-1)=x_help[i-1] + h*k2[i-1]/2;
      i++;
    }
    jac(t,x_0,dfdx,dfdt,&mu);
    func(t,x_lin,f_lin,dfdx,dfdt,&mu);i=1;
    while(i<=DIM){
      k3[i-1]=*(f_lin+i-1);
      i++;
    }

    //4-th STEP
    i=1;
    while(i<=DIM){
      *(x_lin+i-1)=x_help[i-1] + h*k3[i-1];
      i++;
    }
    jac(t,x_0,dfdx,dfdt,&mu);
    func(t,x_lin,f_lin,dfdx,dfdt,&mu);i=1;
    while(i<=DIM){
      k4[i-1]=*(f_lin+i-1);
      i++;
    }
    /*Finally, calculating the next point*/
    i=1;
    while(i<=DIM){
      *(x_lin+i-1)=x_help[i-1] + h*(k1[i-1] + 2*k2[i-1] + 2*k3[i-1] + k4[i-1])/6;
      i++;
    }
  }
  else if (strcmp(mynum.method,"eu")==0){
    i=1;
    while(i<=DIM){
      x_help[i-1]=*(x_lin+i-1);/*Store x from previous moment*/
      i++;
    }
    jac(t,x_0,dfdx,dfdt,&mu);
    func(t,x_lin,f_lin,dfdx,dfdt,&mu);/*Compute derivatives*/
    i=1;
    while(i<=DIM){/*Get x for next moment*/
      *(x_lin+i-1) = x_help[i-1] + *(f_lin+i-1)*h;
      i++;
    }
  }
  else {
    fprintf(stderr,"Error: I dont know the method\n");
    return 1;
  }
  return 0;

}

int gill_init(long int *X, double *A, double *A_sum)
{
  /*This function initialize the gillespie algorithm. X is array of
    species numbers. A is the array of propensities of
    reactions. A_sum is the sum of A.*/
  int i;
  *A_sum=0.0;
  double Y[DIM];
  for(i=0;i<DIM;i++)/*Doublify*/
    Y[i]=(double)X[i];
  /*Compute all propensities*/
  propensity(Y,mu.P,A);
  for(i=0;i<NREAC;i++)
    //printf("A[%d]=%lf\n",i,A[i]);
    *A_sum = *A_sum + A[i];
  
  return 0;
}

int ss_stab(const double *xss)
{
  /* This function computes the stability of the steady state (SS). It
     returns 0 in case the SS is stable and 1 otherwise. It
     takes as the input values vector xss of the SS. */
  int i,j;
  gsl_complex tmp;
  double dfdx[DIM*DIM];
  double dfdt[DIM];
  double dxdot[DIM];/* Derivatives of the increments, i.e. deviations from SS */
  jac(t,xss,dfdx,dfdt,&mu);
  /* Allocating workspace */
  gsl_eigen_nonsymm_workspace *w=gsl_eigen_nonsymm_alloc(DIM);
  /* Creating the matrix out of Jacobian */
  gsl_matrix_view jacob=gsl_matrix_view_array(dfdx,DIM,DIM);
  /* printf("Reconstructing Jacobian:\n"); */
  /* printf("J=\n"); */
  /* for(i=0;i<DIM;i++){ */
  /*   for(j=0;j<DIM;j++) */
  /*     printf("%G ",gsl_matrix_get(&jacob.matrix,i,j)); */
  /*   printf("\n"); */
  /* } */
  /* eigenvalues are in eval */
  gsl_vector_complex *eval=gsl_vector_complex_alloc(DIM);
  gsl_eigen_nonsymm(&jacob.matrix,eval,w);
  j=0;
  for(i=0;i<DIM;i++){
    tmp=gsl_vector_complex_get(eval,i);
    printf("L_%d=%G + %Gi\n",i+1,GSL_REAL(tmp),GSL_IMAG(tmp));
    if(GSL_REAL(tmp)>1e-7) j++;
  }
  /* Freeing the memory */
  gsl_vector_complex_free(eval);
  gsl_eigen_nonsymm_free(w);
  if(j>0) return 1;
  else return 0;
}
