# Use genStubs.tcl (/tools in TCL source package) to generate
# mcDecls.h and mcStubInit.c from this file.
#
# Procedure:
# touch mcDecls.h
# touch mcStubInit.c
# ./genStubs.tcl . mc.decls
#
# Problem: if there are no arguments, you have to add parenthesis and
# remove some '*' in generated file mcDecls.h, moreover you have to
# remove '&' in generated file mcStubInit.c.

library mc
interface mc
declare 0 generic {
  int mc_status
}
declare 1 generic {
  int mc_formulae
}
declare 2 generic {
  Mc_Formula *mc_formulaTable
}
declare 3 generic {
  const int MC_SIMPLE
}
declare 4 generic {
  const int MC_TRACE
}
declare 5 generic {
  const int MC_XTRACE
}
declare 6 generic {
  const int MC_EXPLAIN
}
declare 7 generic {
  const int MC_TRACEPATH
}
declare 8 generic {
  const int MC_DIAGNOSTIC
}
declare 9 generic {
  const int MC_AUTOMATON
}
declare 10 generic {
  const int MC_MINIMIZE
}
declare 11 generic {
  const int MC_TREE
}
declare 12 generic {
  const int MC_PROGRESS
}
declare 13 generic {
  void Mc_InitPkg()
}
declare 14 generic {
  void Mc_ExitPkg()
}
declare 15 generic {
  void Mc_AboutPkg()
}
declare 16 generic {
  int Mc_AddNewFormula(Est_String name, Est_String formula)
}
declare 17 generic {
  int Mc_FOANextFormula(Est_String f, Est_String prefix)
}
declare 18 generic {
  int Mc_FindFormula(Est_String name)
}
declare 19 generic {
  void Mc_WriteKnownFormulae()
}
declare 20 generic {
  void Mc_WriteFormula(Est_String ime, char type)
}
declare 21 generic {
  void Mc_CheckACTL(int par, Est_String name, Est_String f, int parserSettings)
}
declare 22 generic {
  void Mc_CheckACTLString(int par, Est_String name, Est_String f, int parserSettings)
}
declare 23 generic {
  void Mc_CheckACTLFile(int par, Est_String name, Est_String f, int parserSettings)
}
declare 24 generic {
  void Mc_GenerateWCA(Est_String name, Est_String f, Est_String aname)
}
declare 25 generic {
  void Mc_ReadACTL(Est_String name, Est_String f)
}
declare 26 generic {
  void Mc_ReadACTLFile(Est_String f)
}
declare 27 generic {
  Bdd_Edge Mc_CheckEEU(Bdd_Edge D, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge a2, Bdd_Edge s2)
}
declare 28 generic {
  Bdd_Edge Mc_CheckAAU(Bdd_Edge D, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge *AWfun, Bdd_Edge *AFfun)
}
declare 29 generic {
  Bdd_Edge Mc_CheckEEW(Bdd_Edge D, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge *EUfun, Bdd_Edge *EGfun)
}
declare 30 generic {
  Bdd_Edge Mc_CheckAAW(Bdd_Edge D, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge a2, Bdd_Edge s2)
}
declare 31 generic {
  Bdd_Edge Mc_CheckEEX(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 32 generic {
  Bdd_Edge Mc_CheckAAX(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 33 generic {
  Bdd_Edge Mc_CheckEEF(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 34 generic {
  Bdd_Edge Mc_CheckAAF(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 35 generic {
  Bdd_Edge Mc_CheckEEG(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 36 generic {
  Bdd_Edge Mc_CheckAAG(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 37 generic {
  Bdd_Edge Mc_CheckEU(Bdd_Edge D, Bdd_Edge s1, Bdd_Edge a1, Bdd_Edge a2, Bdd_Edge s2)
}
declare 38 generic {
  Bdd_Edge Mc_CheckAU(Bdd_Edge D, Bdd_Edge s1, Bdd_Edge a1, Bdd_Edge a2, Bdd_Edge s2)
}
declare 39 generic {
  Bdd_Edge Mc_CheckEX(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 40 generic {
  Bdd_Edge Mc_CheckAX(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 41 generic {
  Bdd_Edge Mc_CheckHME(Bdd_Edge D, Bdd_Edge s1, Bdd_Edge a, Bdd_Edge s2)
}
declare 42 generic {
  Bdd_Edge Mc_CheckHMA(Bdd_Edge D, Bdd_Edge a, Bdd_Edge s)
}
declare 43 generic {
  Bdd_Edge Mc_CheckEF(Bdd_Edge D, Bdd_Edge s)
}
declare 44 generic {
  Bdd_Edge Mc_CheckAF(Bdd_Edge D, Bdd_Edge s)
}
declare 45 generic {
  Bdd_Edge Mc_CheckEG(Bdd_Edge D, Bdd_Edge a)
}
declare 46 generic {
  Bdd_Edge Mc_CheckAG(Bdd_Edge D, Bdd_Edge a)
}
declare 47 generic {
  void Mc_InevitableCheckEEU(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 48 generic {
  void Mc_InevitableCheckAAU(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge *f2, Bdd_Edge *f2x, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 49 generic {
  void Mc_InevitableCheckEEW(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge *f2, Bdd_Edge *f2x, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 50 generic {
  void Mc_InevitableCheckAAW(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a1, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 51 generic {
  void Mc_InevitableCheckEEX(int cn, Bdd_Edge *f,  Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 52 generic {
  void Mc_InevitableCheckAAX(int cn, Bdd_Edge *f,  Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 53 generic {
  void Mc_InevitableCheckEEF(int cn, Bdd_Edge *f,  Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 54 generic {
  void Mc_InevitableCheckEEG(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 55 generic {
  void Mc_InevitableCheckAAF(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 56 generic {
  void Mc_InevitableCheckAAG(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 57 generic {
  void Mc_InevitableCheckEU(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a1, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 58 generic {
  void Mc_InevitableCheckAU(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge *f2, Bdd_Edge *f2x, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a1, Bdd_Edge a2, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 59 generic {
  void Mc_InevitableCheckEX(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 60 generic {
  void Mc_InevitableCheckAX(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 61 generic {
  void Mc_InevitableCheckHME(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s1, Bdd_Edge s1x, Bdd_Edge a, Bdd_Edge s2, Bdd_Edge s2x)
}
declare 62 generic {
  void Mc_InevitableCheckHMA(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge a, Bdd_Edge s, Bdd_Edge sx)
}
declare 63 generic {
  void Mc_InevitableCheckEF(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s, Bdd_Edge sx)
}
declare 64 generic {
  void Mc_InevitableCheckEG(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s, Bdd_Edge sx)
}
declare 65 generic {
  void Mc_InevitableCheckAF(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s, Bdd_Edge sx)
}
declare 66 generic {
  void Mc_InevitableCheckAG(int cn, Bdd_Edge *f, Bdd_Edge *fx, Bdd_Edge *f1, Bdd_Edge *f1x, Bdd_Edge s, Bdd_Edge sx)
}
