"""Unit tests for lazyarray.py"""

import unittest
import objects, program
from lazyarray import *

def get_la():
	"""Return an example lazy array"""
	la = LazyArray(5)
	keys = [1, 2, objects.Blank, 'foo']
	values = [lambda: objects.Blank, lambda: 'bar', lambda: 5,
			  lambda: 'baz']
	for i in range(4):
		key, value = keys[i], values[i]
		la.set_key(i, key)
		la.set_value(i, value)
	return la

def get_nested_la():
	"""Return a lazy array that has a lazy array inside of it"""
	exa = objects.ExArray(get_la())
	la2 = LazyArray(5)
	la2.set_keys((1,2,None,4,'foo'))
	la2.set_values_precomputed(('hello', 'how', 'you', exa, 6))
	return la2	

class LazyArrayTest(unittest.TestCase):
	"""Test the Lazy Array class"""
	def testBasic(self):
		"""Test some basic operations"""
		la = get_la()
		assert len(la) == 5, len(la)
		assert la[1] == objects.Blank, la[1]
		assert la[2] == 'bar', la[2]
		try: none_val = la[objects.Blank]
		except AttributeError: pass
		else: assert False, ("No attribute error, got "+str(la[None]))
		assert la['foo'] == 'baz'

	def testDict(self):
		"""Test converting lazy array to dictionary"""
		d = get_la().todict()
		assert objects.Blank not in d, d
		assert d[1]() is objects.Blank, d
		assert d[2]() == 'bar', d
		assert len(d) == 3, d

	def testListSet(self):
		"""Test the methods which set from a list"""
		la = LazyArray(5)
		la.set_keys((1,2,None,4,'foo'))
		la.set_values_precomputed(('hello', 'how', 'you', 'today', 6))
		assert la[2] == 'how', la[2]
		assert la['foo'] == 6
		assert la.topairs() == ((1, 'hello'), (2, 'how'), (None, 'you'),
								(4, 'today'), ('foo', 6)), la.topairs()

	def testDeref(self):
		"""Test dereferencing an absolute reference"""
		la = get_nested_la()
		subla = la(4)
		assert isinstance(subla, objects.ExArray)
		assert la.deref_absref(program.AbsoluteReference(())) is la
		assert la.deref_absref(program.AbsoluteReference((3,))) is subla
		assert la.deref_absref(program.AbsoluteReference((3,2))) == 5


class LazyArrayStackTest(unittest.TestCase):
	"""Test the LazyArrayStack class"""
	def testBasic(self):
		"""Test simple key query, adding"""
		la1 = get_la()
		la2 = LazyArray(5)
		la2.set_keys((1,2,None,4,'foo'))
		la2.set_values_precomputed(('hello', 'how', 'you', 'today', 6))
		
		las = LazyArrayStack()
		try: las[3]
		except AttributeError: pass
		else: assert False
		
		las1 = las + la1
		try: las['oaeustnh']
		except AttributeError: pass
		else: assert False
		
		assert las1[1] == objects.Blank, las1[1]
		assert las1['foo'] == 'baz', las1['foo']
		
		las2 = las1 + la2
		assert las2[1] == 'hello', las2[1]
		assert las2[4] == 'today', las2[4]


if __name__ == '__main__': unittest.main()