# Copyright 2009 Ben Escoto
#
# This file is part of Explicans.

# Explicans is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Explicans is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Explicans.  If not, see <http://www.gnu.org/licenses/>.

import unittest, code
import parse


class ParseTest(unittest.TestCase):
	"""Test the Formula Class"""
	parse_examples = (('5', ('NUM', '5')),
					  ('5.32', ('NUM', '5', '.', '32')),
					  ('5+2.5', ('+', ('NUM', '5'), ('NUM', '2', '.', '5'))),
					  ('5*2+3723', ('+', ('*', ('NUM', '5'),
									   ('NUM', '2')),
								 ('NUM', '3723'))),
					  ('2+3*3+4', ('+', ('+', ('NUM', '2'),
											  ('*', ('NUM', '3'),
												    ('NUM', '3'))),
								   ('NUM', '4'))),
					  ('-5', ('NEG', ('NUM', '5'))),
					  ('-5--5', ('-', ('NEG', ('NUM', '5')),
								 ('NEG', ('NUM', '5')))),
					  ('a', ('NAME', 'a')),
					  ('a^b^-c', ('^', ('NAME', 'a'),
								      ('^', ('NAME', 'b'),
									   ('NEG', ('NAME', 'c'))))),
					  ('(5+2)*a', ('*', ('+', ('NUM', '5'),
											  ('NUM', '2')),
								        ('NAME', 'a'))),
					  ('hello:there', (':', ('NAME', 'hello'),
									        ('NAME', 'there'))),
					  ('g()', ('FUNCALL', ('NAME', 'g'))),
					  ('g(hello)', ('FUNCALL', ('NAME', 'g'),
									           ('NAME', 'hello'))),
					  ('f(1.9,2,3)', ('FUNCALL', ('NAME', 'f'),
										       ('NUM', '1', '.', '9'),
											   ('NUM', '2'),
											   ('NUM', '3'))),
					  ('f(a+b)', ('FUNCALL', ('NAME', 'f'),
								        ('+', ('NAME', 'a'),
										      ('NAME', 'b')))),
					  ('a:b(1)', ('FUNCALL', (':', ('NAME', 'a'),
												   ('NAME', 'b')),
								             ('NUM', '1'))),
					  ('a.c', ('.', ('NAME', 'a'), ('NAME', 'c'))),
					  ('a:b:c.d', ('.', (':', (':', ('NAME', 'a'),
													('NAME', 'b')),
										 ('NAME', 'c')),
								   ('NAME', 'd'))),
					  ('(3)', ('NUM', '3')),
					  ('"hello"', ('STRING', 'hello')),
					  ('f("hello")', ('FUNCALL', ('NAME', 'f'),
									  ('STRING', 'hello'))),
					  ('"quoted\'string"', ('STRING', 'quoted\'string')),
					  ('"quoted\\"str"', ('STRING', 'quoted"str')),
					  ('hello there', ('NAME', 'hello there')),
					  ('hello + there', ('+', ('NAME', 'hello'),
										 ('NAME', 'there'))),
					  ('f a  (3)', ('FUNCALL', ('NAME', 'f a'),
								   ('NUM', '3'))),
					  ('Sales Year 2009/ 3', ('/', ('NAME', 'Sales Year 2009'),
											  ('NUM', '3'))),
					  ('  foo bar   ', ('NAME', 'foo bar')),
					  (' a  ^   b  ', ('^', ('NAME', 'a'), ('NAME', 'b'))),
					  (' foo  bar ', None),
					  ('32+*43', None),
					  ('a[3]', ('INDEX', ('NAME', 'a'), ('NUM', '3'))),
					  ('f:g[a]', ('INDEX', (':', ('NAME', 'f'), ('NAME', 'g')),
								  ('NAME', 'a'))),
					  ('a[3].u', ('.', ('INDEX', ('NAME', 'a'), ('NUM', '3')),
								  ('NAME', 'u'))),
					  ('a < b', ('<', ('NAME', 'a'), ('NAME', 'b'))),
					  ('a > b', ('>', ('NAME', 'a'), ('NAME', 'b'))),
					  ('a <= b', ('<=', ('NAME', 'a'), ('NAME', 'b'))),					  
					  ('a >= b', ('>=', ('NAME', 'a'), ('NAME', 'b'))),
					  ('a = b', ('=', ('NAME', 'a'), ('NAME', 'b'))),
					  ('a != b', ('!=', ('NAME', 'a'), ('NAME', 'b'))),
					  ('a and b or c and d', ('or', ('and', ('NAME', 'a'),
													 ('NAME', 'b')),
											  ('and', ('NAME', 'c'),
											   ('NAME', 'd')))),
					  ('a*2 where a<2', ('where', ('*', ('NAME', 'a'),
												   ('NUM', '2')),
										 ('<', ('NAME', 'a'), ('NUM', '2')))),
					  ('1..10', ('ARITHSEQ2', ('NUM', '1'), ('NUM', '10'))),
					  ('9,2+3..-31', ('ARITHSEQ3', ('NUM', '9'),
											('+', ('NUM', '2'), ('NUM', '3')),
										('NEG', ('NUM', '31'))))
					 )

	def testParsing(self):
		"""Test formula parsing"""
		for expr_string, sexp in self.parse_examples:
			result = parse.parse_string(expr_string)
			#print expr_string, result
			if result != sexp:
				print "Error parsing string "+expr_string
				print "Expected:\n%s\nReceived:\n%s" % (sexp, result)
				assert False

	def testParsing_toomuch(self):
		"""Test parsing expressions when there is extra stuff on the end"""
		result = parse.parse_string('(3)foo')
		assert result == None, result


if __name__ == "__main__": unittest.main()