<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des Documents
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/


	/**
	* Gere le code HTML du debut du tableau contenant la liste des documents
	* @access	public
	*/
	function OpenListDocument() {
	 global $color2, $gusertype ;
	 global $st_table ;
		put('
	<br><br>
	<table align="center" width="95%" border="0" cellspacing="0" cellpadding="2" bgcolor="'.$color2.'">
	<tr><td>
	 <table align="middle" width="100%" border="0" cellspacing="0" cellpadding="5">
	  <tr align="left" bgColor="'.$color2.'">
			<td width="20%" class="title2">'.$st_table['de'].'</td>
			<td width="10%" class="title2">'.$st_table['date'].'</td>
			<td width="30%" align="middle" class="title2">'.$st_table['desc'].'</td>
			<td width="30%" class="title2">'.$st_table['fichier'].'</td>');
		if ( $gusertype != STAGIAIRE ) {
			put('        <td width="10%" class="title2">'.$st_table['action'].'</td>');
		}
		put('</tr>');
	}

	/**
	* Ajoute une ligne au tableau de la liste des documents
	* @param	integer	$i Numero de ligne
	* @param	string	$entry Nom du fichier dans la bdd
	* @param	string	$user Membre qui a fait le post
	* @param	string	$fichier Nom du fichier sur le disque
	* @param	integer	$size taille du fichier
	* @param	string	$date date du post
	* @param	string	$desc description lors du post
	* @param	string	$comment commentaire
	* @param	integer	$id Id du document
	* @param	integer	$nb Nombre de commentaires
	* @access	public
	*/
	function AddDocument($i,$entry,$user,$fichier,$size,$date,$desc,$comment,$id,$nb) {
	 global $color2, $groupe, $connexion, $menu, $ClsGroupe, $HTTP ;
	 global $ClsMembre, $ext, $gusertype ;
	 global $st_texte ;

		// CSS !!!
		$desc		= htmlentities($desc);
		$fichier	= htmlentities($fichier);

		$http		= ( $gusertype==STAGIAIRE?HTTP_STAGIAIRE:HTTP_TUTEUR)	;
		$rep		= $ClsGroupe->Directory($groupe);
		$dir		= RP_GROUPES.$rep."/"		;
		$text_nb	= ( $nb=="0"?"":"(".$nb.")" )	;

		$url	 = HTTP_COMMUN.'p_comment'.$ext.'?connexion='.$connexion.'&groupe='.$groupe.'&id_comment='.$id;
		$click	 = 'onClick="openWindow(\''.$url.'\',\'cw\',\'scrollbars=yes,width=400,height=400\')"';
		$status = Status($st_texte["comment"]);
		$comment = '<a class="student" href="#" '.$click." ".$status.'>'.$st_texte["comment"].$text_nb.'</a>';

		$status = Status('');
		$dnl = HTTP_COMMUN."download.php?connexion=".$connexion ;
		$dnl.= "&dir=".urlencode($dir)."&filename=".urlencode($entry) ;
		$see   = '<a class="student" target="_blank" href="'.$dnl.'" '.$status.'>'.$fichier.'</a>&nbsp;';

		$url	=$http.'index'.$ext.'?menu='.$menu.'&groupe='.$groupe.'&connexion='.$connexion.'&delete='.$id;
		$status = Status($st_texte['supprim']);
		$del	= '<a class="error" href="javascript:DeleteFile(\''.$url.'\');" '.$status.'>'.$st_texte['supprim'].'</a>';

		put('	  <tr bgcolor="'.GetColor($i).'">')		;
		put('			 <td>'.$user.'</td>')			;
		put('		 <td>'.$date.'</td>')				;
		put('		 <td>'.$desc.'<br>'.$comment.'</td>');
		put('		 <td>'.$see.'('.$size.')</td>')		;

		if ( $gusertype != STAGIAIRE ) {
			put('<td>'.$del.'</td>');
		}
		put('</tr>');
	}

	/**
	* Ferme la table qui affiche la liste des documents
	* @access	public
	*/
	function CloseListDocument() {
	 global $color2 ;
		put('	 </table>')	;
		put('	</td></tr>');
		put('	</table>')	;
	}

	/**
	* Affiche et retourne le Nombre de documents postes
	* @return	integer Retourne le nombre de documents postes
	* @access	public
	*/
	function NbDocument() {
	 global $groupe, $ClsDocument ;
	 global $st_texte, $st_titre ;
		$num = $ClsDocument->Nb($groupe) ;
		SubTitle ($st_titre['nbdoc'].($num==0?'<b>'.$st_texte['nodoc'].'<b>':$num ) ) ;
		return($num) ;
	}

	/**
	* Affiche le tableau avec tous les documents postes
	* @access	public
	*/
	function ListerDocument() {
	 global $groupe, $ClsDocument;
		if ( ($nb = NbDocument()) > 0 ) {
			OpenListDocument();
			$doc = $ClsDocument->Lister($groupe);
			for ($i=0 ; $i<$doc['cnt'] ; $i++) {
				$ret = $doc[$i] ;
				AddDocument($i, $ret['file'], $ret['user'], ExtractFileName($ret['file']), $ret['size'], 
							$ret['date'], $ret['titre'], $ret['comment'], $ret['id'], $ret['nb'])	;
			}
			CloseListDocument();
		}
	}


	/**
	* Affiche un tableau avec des Form pour ajouter un document
	* et un planning si le membre est un tuteur.
	* @access	public
	*/
	function FrmDocument() {
	 global $gusertype ;
	 global $tu_texte ;
		BR(3);
		if ( !OPT_UPLOAD_ACTIVE ) {
			put('<CENTER>')		;
			put('<table align="center" width="30%" border="0" cellspacing="5" cellpadding="0">')	;
			put('   <tr><td width="100%" valign="top" class="title1" > '.$tu_texte['erruploadM'])	;
			put('  </td></tr>')	;
			put('</table>')		;
			put('</CENTER>')	;
			return ;
		}
		if ( $gusertype == STAGIAIRE ) {
			//stagiaire
			put('<CENTER>')	;
			put('<table align="center" width="30%" border="0" cellspacing="5" cellpadding="0">');
			put('  <tr><td width="100%" valign="top">');
			FrmNewDocument()		;
			put('  </td></tr>')		;
			put('</table></CENTER>');	
			put('</CENTER>');	
		} else {
			//tuteur
			put('<table align="center" width="95%" border="0" cellspacing="5" cellpadding="0">');
			put('  <tr>')	;
			put('	<td width="50%" valign="top">');
			FrmPlanning()	;
			put('</td>')	;
			put('	<td width="50%" valign="top">');
			FrmNewDocument();
			put('</td>')	;
			put('  </tr>')	;
			put('</table>')	;	
		}
	}

	/**
	* Affiche un form pour ajouter un planning
	* @access	public
	*/
	function FrmPlanning() {
	 global $color3, $color2, $connexion, $groupe, $menu, $ext, $ClsGroupe, $HTTP ;
	 global $tu_titre, $tu_texte, $tu_form ;
		$planning = $ClsGroupe->Planning($groupe) ;
		if ( $planning == "" ) {
			// pas de planning
			$lPlanning = "<b>".$tu_texte['noplanning']."</b>"		;
			$update_planning = $tu_texte['iplanning']				;
		} else {
			$rep =  $ClsGroupe->Directory($groupe)					;
			$httpPlanning = HTTP_GROUPE.$rep."/".$planning			;
			$url = HTTP_TUTEUR."index".$ext."?connexion=".$connexion."&groupe=".$groupe	;
			$url.= "&menu=".$menu."&deleteplanning=1"				;
			$httpDelPlanning = "javascript:DeleteFile('".$url."');"	;
			$status1 = Status('Voir le planning')		;
			$status2 = Status('Supprimer le planning')	;

			$lPlanning = '<a class="student" target="_blank" href="'.$httpPlanning.'" '.$status1.' >';
			$lPlanning.= $tu_texte['vplanning'].'</a>&nbsp;|&nbsp;' ;
			$lPlanning.= '<a class="student" href="'.$httpDelPlanning.'" '.$status2.'>';
			$lPlanning.= $tu_texte['splanning'].'</a>'	;
			$update_planning = $tu_texte['rplanning']	;
		}
		put('
<table width="100%" border="0" cellspacing="0" cellpadding="2" bgcolor="'.$color2.'">
 <tr><td>
 <table align="center" width="100%" border="0" cellspacing="0" cellpadding="5" bgColor="'.$color3.'">
  <tr align="middle" bgColor="'.$color2.'" >
  <td class="title2">'.$tu_titre['gplanning'].'</td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  <tr><td>'.$lPlanning.'</td></tr>
  <tr><td>
      <form action="index'.$ext.'?connexion='.$connexion.'" method="post" enctype="multipart/form-data" >
        <input type="hidden" name="update_planning" value="1" >
        <input type="hidden" name="groupe" value="'.$groupe.'" >
        <input type="hidden" name="menu" value="'.$menu.'" >
        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="left" >
          <tr><td>&nbsp;</td></tr>
          <tr>
            <td valign="top">'.$update_planning.'</td>
          </tr>
          <tr><td>&nbsp;</td></tr>
          <tr>	
            <td><input type="hidden" name="MAX_FILE_SIZE" value="'.MAX_FILE_SIZE.'">
                <input type="file" class="bouton" name="fichier" size="15" maxlength="250">
            </td>
          </tr>
          <tr><td>&nbsp;</td></tr>
          <tr>
            <td align="center"><input type="button" class="bouton" name="OK" value="'.$tu_form['envoyer'].'" onClick="ValiderFormPlanning(this.form);" ></td> 
          </tr>
        </table>
      </form>
  </td></tr>
 </table>
 </td></tr>
 </table>');
	}

	/**
	* Affiche un form pour ajouter un nouveau document
	* @access	public
	*/
	function FrmNewDocument() {
	 global $color3, $color2, $connexion, $groupe, $menu, $ext ;
	 global $st_titre, $st_form ;
		put('
 <table width="100%" border="0" cellspacing="0" cellpadding="2" bgcolor="'.$color2.'">
 <tr><td>
 <table align="center" width="100%" border="0" cellspacing="0" cellpadding="5" bgColor="'.$color3.'">
  <tr align="middle" bgColor="'.$color2.'">
  <td class="title2">'.$st_titre['ajoutdocgrp'].'</td>
  </tr>
  <tr><td>
      <form action="index'.$ext.'?connexion='.$connexion.'" method="post" enctype="multipart/form-data" >
        <input type="hidden" name="insert_file" value="1" >
        <input type="hidden" name="groupe" value="'.$groupe.'" >
        <input type="hidden" name="menu" value="'.$menu.'" >
        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="left">
          <tr><td valign="top">'.$st_form['entrerdesc'].'</td></tr>
          <tr><td valign="top"><input type="text" name="titre" size="25" maxlength="30"></td></tr>
          <tr><td>&nbsp;</td></tr>	
          <tr><td valign="top">'.$st_form['entrercomm'].'</td></tr>
          <tr><td valign="top"><textarea name="comment" cols="25" rows="10" wrap="virtual"></textarea></td></tr>
          <tr><td>&nbsp;</td></tr>	
          <tr><td valign="top">'.$st_form['selectfichier'].'</td></tr>	
          <tr>	
            <td><input type="hidden" name="MAX_FILE_SIZE" value="'.MAX_FILE_SIZE.'">
                <input type="file" class="bouton" name="fichier" size="20" maxlength="250">
            </td>
          </tr>
          <tr><td>&nbsp;</td></tr>
          <tr>
            <td align="center"><input type="button" class="bouton"  name="OK" value="'.$st_form['envoyer'].'" onClick="ValiderFormFile(this.form);" ></td> 
          </tr>
          <tr><td>&nbsp;</td></tr>
        </table>
      </form>
  </td></tr>
 </table>
 </td></tr>
 </table>');
	}

	/**
	* Affiche un form pour ajouter nouveau commentaire a un document
	* @access	public
	*/
	function FrmNewComment() {
	 global $color3, $color2, $connexion, $groupe, $ext, $id_comment ;
	 global $st_titre, $st_form ;
		put('
	 <table width="95%" border="0" cellspacing="0" cellpadding="2" bgcolor="'.$color2.'" align="center">
	 <tr><td>
	 <table align="center" width="100%" border="0" cellspacing="0" cellpadding="5" bgColor="'.$color3.'">
	  <tr align="middle" bgColor="'.$color2.'" class="title2">
	  <td class="title2">'.$st_titre['ajoutcomm'].'</td>
	  </tr>
	  <tr><td>
		  <form action="p_comment'.$ext.'?connexion='.$connexion.'" method="post" enctype="multipart/form-data" >
			<input type="hidden" name="insert_comment" value="1" >
			<input type="hidden" name="groupe" value="'.$groupe.'" >
			<input type="hidden" name="id_comment" value="'.$id_comment.'" >
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="left">
			  <tr><td valign="top">'.$st_form['entrercomm'].'</td></tr>
			  <tr><td valign="top"><textarea name="comment" cols="30" rows="10" wrap="virtual"></textarea></td></tr>
			  <tr><td>&nbsp;</td></tr>
			  <tr>
				<td align="center"><input type="button" class="bouton"  name="OK" value="'.$st_form['envoyer'].'" onClick="ValiderFormComment(this.form);" ></td> 
			  </tr>
			  <tr><td>&nbsp;</td></tr>
			</table>
		  </form>
	  </td></tr>
	 </table>
	 </td></tr>
	 </table>');
	}

	/**
	* Affiche le sous menu des documents
	* @access	public
	*/
	function MenuDocument() {
	 global $color1, $HTTP, $cmd_zd, $ext, $connexion, $groupe, $menu, $gusertype ;
	 global $st_titre ;
		$lcmd_zd= "index".$ext."?connexion=".$connexion."&groupe=".$groupe."&menu=".$menu;

		$c1		= ($cmd_zd==CMD_ZD_LIST?$color1:"#FFFFFF") ;
		$over1	= 'onMouseOver="window.status=\'Liste des documents\';return true;"';
		$status = Status($st_titre['listdoc']); 
		$a1	= '<a class="student" href="'.$lcmd_zd.'&cmd_zd='.CMD_ZD_LIST.'" '.$status.'>';
		$a1.= '<img align="absmiddle" alt="'.$st_titre['listdoc'].'" border="0" src="'.HTTP_IMAGES.'document.gif">';
		$a1.= $st_titre['listdoc'].'</a>';

		$c2		= ($cmd_zd==CMD_ZD_POST?$color1:"#FFFFFF") ;
		$status = Status($st_titre['ajoutdoc']); 
		$a2 = '<a class="student" href="'.$lcmd_zd.'&cmd_zd='.CMD_ZD_POST.'" '.$status.'>';
		$a2.= '<img align="absmiddle" alt="'.$st_titre['ajoutdoc'].'" border="0" src="'.HTTP_IMAGES.'addfile.gif">';
		$a2.= $st_titre['ajoutdoc'].'</a>';

		put('<table width="60%" border="0" cellspacing="0" cellpadding="5">');
		put('  <tr>')	;
		put('    <td width="10%" >&nbsp;</td>');
		put('    <td width="40%" align="middle" valign="middle" bgcolor="'.$c1.'">'.$a1.'</td>');
		put('    <td width="10%" >&nbsp;</td>');
		if ( $groupe != 0  ) {
			if ( $gusertype != STAGIAIRE && OPT_UPLOAD_ACTIVE ) {
				put ('    <td width="40%" align="middle" valign="middle" bgcolor="'.$c2.'")">'.$a2.'</td>');
			} elseif ( OPT_STUDENT_UPLOAD_DOC_ACTIVE && OPT_UPLOAD_ACTIVE ) {
				put ('    <td width="40%" align="middle" valign="middle" bgcolor="'.$c2.'")">'.$a2.'</td>');
			} else {
				put ('    <td width="40%">&nbsp;</td> ');
			}
		} else {
			put ('    <td width="40%">&nbsp;</td> ');
		}
		put('  </tr>')	;
		put('</table>')	;
		put('<br>')		;
	}

	/**
	* Gere l'affichage de la page document 
	* @access	public
	*/
	function page_document() {
	 global $ClsGroupe, $groupe, $delete, $update_planning, $deleteplanning, $insert_file ;
	 global $fichier, $fichier_name, $comment, $titre, $ClsDocument, $guserid, $gusertype, $cmd_zd ;
	 global $HTTP_POST_FILES ;
	 global $st_menu, $tu_menu ;
		Title($tu_menu['doc']." [ ".CSS($ClsGroupe->Name($groupe))." ]");
		if ( ! (isset($cmd_zd)) || $cmd_zd=='' ) {
			$cmd_zd=CMD_ZD_LIST;
		}
		$msg = '' ;
		if ( isset($delete) && ($delete != "") ) {
			$msg = $ClsDocument->Del($delete) ;
		}
		if ( isset($deleteplanning) ) {
			$msg =  $ClsGroupe->DeletePlanning($groupe);
		}
		if ( isset($insert_file) && $insert_file=="1" ) {
			$msg = $ClsDocument->Add($guserid,$HTTP_POST_FILES,$comment,$titre );
		}
		if ( isset($update_planning) && $update_planning=="1" ) {
			$msg = $ClsGroupe->UpdatePlanning($groupe,$HTTP_POST_FILES);
		}
		message($msg);
		if ( $msg != "" ) {
			$cmd_zd=CMD_ZD_LIST ;
		}
		MenuDocument();
		if ( $cmd_zd == CMD_ZD_LIST ) {
			ListerDocument();
		} else {
			FrmDocument();
		}
	}
	
	function page_comment() {
		if (isset($insert_comment) && $insert_comment!="" ) {
			$ClsDocument->InsertComment($id_comment, $comment);
		}
		InitPageHtmlNoCache();
		
		$table = 'cellpadding="3" cellspacing="0" border="0" align="center" width="100%" bgcolor="'.$color1.'"' ;
		
		$DEB = '<table align="center" width="95%" cellpadding="2" cellspacing="0" border="0" bgcolor="'.$color2.'"><tr><td>
			<table '.$table.'>
			<tr><td valign=top><b>';
		
		$MID = '</b></td></tr>
		<tr><td>' ;
		
		$FIN = '</td></tr>
			</table>
		</td></tr></table><BR>';
		
		$ret = $ClsDocument->Read($id_comment);
		$comment = htmlentities($ret['comment']) ;
		if ( strlen($comment)!=0 ) {
			$comment = ereg_replace("&lt;DEB&gt;",$DEB,$comment );
			$comment = ereg_replace("&lt;MID&gt;",$MID,$comment );
			$comment = ereg_replace("&lt;FIN&gt;",$FIN,$comment );
		}
		
		put('<table '.$table.'>');
		put('  <tr><td valign=top>'.$st_titre['postdoc'].' '.$ret['user'].' : '.$ret['date'].'</td></tr>');
		put('</table>')	;
		
		put('<table '.$table.'>');
		put('  <tr><td valign=top>'.$st_titre['titre'].'<b>'.$ret['titre'].'</b></td></tr>');
		put('</table>')	;
		
		BR(2)			;
		put($comment)	;
		BR()			;
		FrmNewComment()	;
		BR()			;
		CloseWindow()	;
		Footer()		;
		ClosePageHtml()	;
	}		
	
	
?>