<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des formulaires 
*
* @author		Eric Villard <evillard@nef.fr>
* @package		GaneshaInc
*/

	/**
	* fonction de cration d'entte de boite de slection
	* permmettant de dfinir sa taille et des slections multiples
	* @param	string	$name	nom de la boite de slection
	* @param	string	$action	action  effectuer lors de l'vnement onChange
	* @param	integer	$size	dfinit la taille de la boite de slection
	* @param	boolean	$multi	slection multiple / unique
	* @access	public
	*/
	function DebutOption($name,$action,$size,$multi) {
		put_debug(" Debut OPTION ".$name);
		($multi) ? $m = "multiple": $m = "";
		(!empty($size)) ? $s = "size=".$size: $s = "";
		put('&nbsp;<select class="bouton" name="'.$name.'" '.$s.' '.$m.' onChange="'.$action.'">');
	}

	/**
	* fonction de fin d'option
	* @access	public
	*/ 	 
	 function FinOption(){
        put("</select>");
        put_debug(" Fin OPTION ");
     }

	/**
	* fonction d'ajout d'options
	* @param	string	$text		intitul de l'option
	* @param	string	$value		valeur de l'attribut value
	* @param	integer	$selected	dfinit dfinit si l'option est slectionne
	* @access	public
	*/
     function AjoutOption($text,$value,$selected) {
          $text = Unreplace($text) ;
          $sel = ($selected?'selected':'');
          put('<option value="'.$value.'" '.$sel.'>'.$text.'</option>');
	}

	/**	 
	* ajout de bouton
	* @param	variant $val	valeur de l'attribut "value"
	* @param	string	$num	n du bouton
	* @param	string	$action	action  raliser lors de l'vnement onClick
	* @access	public
	*/ 
    function AjoutBouton($val,$num,$action) {
    	put('&nbsp;<input class="bouton" type="button" name="bouton'.$num.'" value="'.$val.'" onclick="'.$action.'">&nbsp;');
    }

	/**	 
	* procdure listeMulti : cre une liste de slection
	* @param	string	$titre	intitul
	* @param	array	$tab	tableau des lments  lister
	* @param	string	$name	nom de la boite de slection
	* @param	string	$action	action  raliser lors de l'vnement onChange
	* @param	integer	$id		identifiant de l'option
	* @param	integer	$size	dfinit la taille de la boite de slection
	* @param	boolean	$multi	slection multiple / unique
	* @param	integer	$numb	numero des boutons
	* @param	integer	$$ide	id de l'element liste
	* @access	public
	*/
	function listeMulti($titre,$tab,$name,$action,$id,$size,$multi,$numb='',$ide='') {
		$lgtab = count($tab);
		put('<tr align="left" valign="top" bgcolor="'.CoulForm().'"><td width="30%">&nbsp;'.$titre.'</td><td width="70%">');		
        DebutOption($name, $action, $size, $multi);
		if (empty($id)) $select = true ;
      	for ($i=0; $i < $lgtab; $i++) {
            $select = false ;
			if ($tab[$i]["id"] == $id ) $select = true ;
            if (isset($tab[$i]["prenom"])) {
				AjoutOption($tab[$i]["prenom"]." ".$tab[$i]["nom"],$tab[$i]["id"],$select);
			} else {
				AjoutOption($tab[$i]["nom"],$tab[$i]["id"],$select);
			}
        }
        FinOption();
        if ( $numb != '' && $ide != '' ) {
	        BR();
	        AjoutBouton('Tous',$numb,'selectAll(document.evalx.elements['.$ide.'], true)');
	        put('&nbsp;');
	        AjoutBouton('Aucun',$numb+1,'selectAll(document.evalx.elements['.$ide.'], false)');
        }
    	put('</td></tr>');
    }

	/**	 
	* ajout de case  cocher
	* @param	string	$titre	intitul
	* @param	string	$check	checked ou uncheked
	* @param	string	$num	n de la case  cocher
	* @param	variant $val	valeur de l'attribut "value"
	* @access	public
	*/ 
    function AjoutCheck($titre,$check,$num,$val) {
  		put('&nbsp;'.$titre.'&nbsp;');
  		put('&nbsp;<input class="bouton" type="checkbox" name="check'.$num.'" value="'.$val.'" '.$check.'>&nbsp;');
     }

	/**	 
	* ajout de champ de texte
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"
	* @param	string	$num	n du champ de texte
	* @param	integer $nbChar	nombre de caractre visibles
	* @param	integer $maxL	nombre de caractre autoriss
	* @access	public
	*/ 
    function AjoutText($titre,$val,$num,$nbChar="20",$maxL="50") {
    	put('<tr align="left" valign="top" bgcolor="'.CoulForm().'"><td>&nbsp;'.$titre.'</td>');		
        put('<td>&nbsp;<input class="bouton" type="text" maxLength="'.$maxL.'" size="'.$nbChar.'" value="'.Unreplace($val).'" name="text'.$num.'"></td></tr>');
     }

	/**	 
	* ajout de champ de texte pour une date
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"
	* @param	string	$num	n du champ de texte
	* @param	integer $nbChar	nombre de caractre visibles
	* @param	integer $maxL	nombre de caractre autoriss
	* @access	public
	*/ 
    function AjoutTextDate($titre,$val,$num,$nbChar="20",$maxL="50") {
    	$jour = $num ;
    	$mois = $num + 1 ;
    	$annee = $num + 2 ;
		$aujourdhui = getdate();
  		$month = sprintf("%02d", $aujourdhui['mon']);
  		$day = sprintf("%02d", $aujourdhui['mday']);
  		$year = sprintf("%04d", $aujourdhui['year']);
  		$auto = "this.form.text".$jour.".value='".$day."';this.form.text".$mois.".value='".$month."';this.form.text".$annee.".value='".$year."';" ;
  		$value = "$day / $month / $year";
    	put('<tr align="left" valign="top" bgcolor="'.CoulForm().'"><td>&nbsp;'.$titre.'</td><td>');		
        put('&nbsp;JJ : <input class="bouton" type="text" maxLength="2" size="4" value="'.Unreplace($val[0]).'" name="text'.$jour.'">&nbsp;');
        put('&nbsp;MM : <input class="bouton" type="text" maxLength="2" size="4" value="'.Unreplace($val[1]).'" name="text'.$mois.'">&nbsp;');
        put('&nbsp;AAAA : <input class="bouton" type="text" maxLength="4" size="4" value="'.Unreplace($val[2]).'" name="text'.$annee.'">');
		put('&nbsp;<input class="bouton" type="button" value="<<< '.$value.'" name="auto" onclick="'.$auto.'"></td></tr>');        
		put('</td></tr>');        
    }

	/**	 
	* ajout de champ de texte pour un temps
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"
	* @param	string	$num	n du champ de texte
	* @param	integer $nbChar	nombre de caractre visibles
	* @param	integer $maxL	nombre de caractre autoriss
	* @access	public
	*/ 
    function AjoutTextTime($titre,$val,$num,$nbChar="20",$maxL="50") {
    	put('<tr align="left" valign="top" bgcolor="'.CoulForm().'"><td>&nbsp;'.$titre.'</td><td>');		
        put('&nbsp;hh : <input class="bouton" type="text" maxLength="2" size="4" value="'.Unreplace($val[0]).'" name="text'.$num++.'">&nbsp;');
        put('&nbsp;mm : <input class="bouton" type="text" maxLength="2" size="4" value="'.Unreplace($val[2]).'" name="text'.$num.'"></td></tr>');
    }

	/**	 
	* ajout de champ textarea
	* @param	string	$titre	intitul
	* @param	string  $txt	texte affich par dfaut
	* @param	string	$num	n du champ textarea
	* @param	integer $cols	largeur de la zone d'affichage
	* @param	integer $rows	hauteur de la zone d'affichage
	* @param	boolean	$disab	donne le conrle de la zone ou non
	* @param	boolean	$read	lecture seule / lecture - criture
	* @access	public
	*/ 
    function AjoutTextarea($titre, $txt, $num, $cols=80, $rows=20, $disab=false, $read=false) {
        put('<tr align="left" valign="top" bgcolor="'.CoulForm().'"><td>&nbsp;'.$titre.'</td>');		
        $txtdisab = ( $disab ? 'disabled' : '');
        $txtread  = ( $read  ? 'readonly' : '');
		put('<td>&nbsp;<textarea class="bouton" name="textarea'.$num.'" cols="'.$cols.'" rows="'.$rows.'" '.$txtdisab.' '.$txtread.'>'.Unreplace($txt).'</textarea></td></tr>');
     }

	/**	 
	* ajout de champ cach
	* @param	string	$label	nom du champ
	* @param	variant $val	valeur de l'attribut "value"
	* @access	public
	*/	 
	function AjoutHidden($label,$val) {
		put('<input type="hidden" name="'.$label.'" value="'.$val.'">');
	}

	/**
	* procdure rcursive d'ajout de champs cachs pour des valeurs contenues dans un tableau
	* @param	array	$data	tableau de donnes  afficher
	* @access	public
	*/
	function AjoutHiddenRec($data) {
		$ind=0;
		reset($data);
		while (list($cle, $val) = each($data)) {
			if (gettype($val)=="array") {
				AjoutHiddenRec($val);
			} else {
				AjoutHidden("champ[]",$val);
			}

		}
	}
///////////////////////////////////////////////////////////////////////////////////////////////

 
///////////////////////////////////////////////////////
	/**	 
	* retourne couleur des background des tableaux
	* @return 	string	$color3	couleur
	* @access	public
	*/
     function CoulForm() { 
     	global $color3 ;
       	return ($color3);
     }

	/**	 
	* dbut de formulaire
	* @param	string	$titre	titre
	* @param	string	$nom	nom du formulaire
	* @param	string	$action	action du formulaire
	* @access	public
	*/
     function DebutFormulaire($titre, $nom, $action,$image=''){ 
     	global $color2;
     	BR();
     	if ( $image=='' ) {
			SubTitle($titre);
     	} else {
			SubTitleImage($titre,$image);     		
     	}
		put('<center>');
		//beginBorder("90%",$color2);
     	//put('<form name="'.$nom.'" action="'.$action.'" method="post">');
     	put('<form name="evalx" action="'.$action.'" method="post">');
     	beginBorder("90%",$color2);
 		put('<table width="100%" bgcolor="#FFFFFF" cellSpacing="1" cellPadding="0" border="0">');
     }

	/**	 
	* fin de formulaire
	* @param	string	$action	action du formulaire
	* @access	public
	*/
     function FinFormulaire($action)  { 
	  global $color2, $color3 ;
	  global $tu_titre, $ad_titre, $evx_act;
	  	
		if (!isset($action) || empty($action)) { $action = "submit()" ; }
		if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// tableau rfrenant les intituls des boutons  afficher suivant le type d'action
		$bt = array($tu_titre["enregistrer"], $tu_titre["enregistrer"], $tu_titre["supprimer"]);
		put('
<tr height="35" bgcolor="'.$color2.'">		
 <td align="center" bgcolor="'.$color3.'">* : '.$ad_titre['renseign'].'&nbsp;</td>
 <td align="right"><input class="bouton" type="button" value="'.$bt[$evx_act].'" onClick="'.$action.'">
		&nbsp;&nbsp;<input class="bouton" type="reset" value="Annuler"></td>
</tr>
</table>');
		CloseBorder();
		put('</form>');
		put('</center>');
		//put_debug('Fin formulaire administration GANESHA');
     }

?>