% FUNCTION ELTM = gf_eltm(elt_matrix_type, args..)
% Generates a descriptor for an elementary matrix type.
% 
%   * gf_eltm('base', @tfem FEM)
%  Integration of shape functions on elements, using the fem FEM.
% 
%   * gf_eltm('grad', @tfem FEM)
%  Integration of gradient of shape functions on elements, using the fem FEM.
% 
%   * gf_eltm('hessian', @tfem FEM)
%  Integration of hessian of shape functions on elements, using the fem FEM.
% 
%   * gf_eltm('normal')
%  The unit normal to the current convex face
% 
%   * gf_eltm('grad_geotrans')
%  The gradient of the geometric transformation.  * gf_eltm('grad_geotrans_inv')
%  The inverse of the gradient of the geometric transformation.  *
% gf_eltm('product', @eltm A, @eltm B)
%  Integration of the tensorial product of elementary matrices A and B.
% 
%   In order to obtain a numerical value of theses matrices, see
% gf_mesh_im_get(MIM,'eltm').
function [varargout]=gf_eltm(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('eltm',varargin{:});
  else
    gf_matlab('eltm',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
