% FUNCTION I = gf_integ_get(F, ...)
%     General function for querying information about FEM integration method objects.
% 
%   * gf_integ_get(IM,'is_exact')
%   Return 0 if the integration is an approximate one.
% 
%   * gf_integ_get(IM,'dim')
%   Return the dimension of the ref. convex of the method.
% 
%   * gf_integ_get(IM,'nbpts')
%   Return the total number of integration points.   Count the points for the
%   volume integration, and points for surface integration on each face of the
%   reference convex. Raises an error for exact integration methods.
% 
%   * gf_integ_get(IM,'pts')
%   Return the list of integration points (only for approximate methods).
% 
%   * gf_integ_get(IM,'coeffs')
%   Returns the coefficients associated to each integration point.
% 
%   * gf_integ_get(IM,'face_pts',F)
%   Return the list of integration points for a face.
% 
%   * gf_integ_get(IM,'face_coeffs',F)
%   Returns the coefficients associated to each integration of a face.
% 
%   * gf_integ_get(IM,'char')
%   Ouput a (unique) string representation of the integration method.   This can
%   be used to  comparisons between two different @tinteg objects.
% 
function [varargout]=gf_integ_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('integ_get',varargin{:});
  else
    gf_matlab('integ_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
