% FUNCTION F=gf_linsolve(args)
% 
%   * gf_linsolve('gmres', @spmat M, vec b [, int restart][, @precond
%   P][,'noisy'][,'res', r][,'maxiter', n])
%   Solve MX=b with the generalized minimum residuals method, using P as a
%   preconditioner.   The default value of the restart parameter is 50.
% 
%   * gf_linsolve('cg', @spmat M, vec b [, @precond P][,'noisy'][,'res',
%   r][,'maxiter', n])
%   Solve MX=b with the conjugated gradient method, using P as a preconditioner.
% 
%   * gf_linsolve('bicgstab', @spmat M, vec b [, @precond P][,'noisy'][,'res',
%   r][,'maxiter', n])
%   Solve MX=b with the bi-conjugated gradient stabilized method, using P as a
%   preconditioner.
% 
%   * U,cond = gf_linsolve('lu', @spmat M, vec b [, @precond P])
%   Alias for gf_linsolve('superlu')
% 
%   * U,cond = gf_linsolve('superlu', @spmat M, vec b [, @precond P])
%   Apply the SuperLU solver (sparse LU factorization). The condition number
%   estimate is returned with the solution.
% 
function [varargout]=gf_linsolve(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('linsolve',varargin{:});
  else
    gf_matlab('linsolve',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
