% FUNCTION M = gf_mdbrick_set(cmd, [, args])
%   Modify a model brick object.
% 
%   * gf_mdbrick_set(b,'param', string name, {meshfem MF,V | V})
%   Change the value of a brick parameter.  V should contain the new parameter
%   value. If a meshfem is given , V should hold the field values over that
%   meshfem (i.e. its last dimension should be gf_mesh_fem_get(MF,'nbdof')).
% 
%   * gf_mdbrick_set(b,'constraints', mat H, vec R)
%   Set the constraints imposed by a constraint brick.  This is only applicable to
%   the bricks which inherit from the constraint brick, such as the Dirichlet
%   ones. Imposes HU=R.
% 
%   * gf_mdbrick_set(b,'constraints_rhs', mat H, vec R)
%   Set the right hand side of the constraints imposed by a constraint brick.
%   This is only applicable to the bricks which inherit from the constraint brick,
%   such as the Dirichlet ones.
% 
% 
%   $Id: gf_mdbrick_set.cc,v 1.6 2006/03/28 10:06:35 pommier Exp $
function [varargout]=gf_mdbrick_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick_set',varargin{:});
  else
    gf_matlab('mdbrick_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
