% FUNCTION M = gf_mdstate_get(cmd, [, args])
%   Get information from a model state object.
%   
% 
%   * gf_mdstate_get(mds,'is_complex')
%   Return 0 is the model state is real, 1 if it is complex.
% 
%   * gf_mdstate_get(mds,'tangent_matrix')
%   Return the tangent matrix stored in the model state.
% 
%   * gf_mdstate_get(mds,'constraints_matrix')
%   Return the constraints matrix stored in the model state.
% 
%   * gf_mdstate_get(mds,'reduced_tangent_matrix')
%   Return the reduced tangent matrix (i.e. the tangent matrix after elimination
%   of the constraints).
% 
%   * gf_mdstate_get(mds,'constraints_nullspace')
%   Return the nullspace of the constraints matrix.
% 
%   * gf_mdstate_get(mds,'state')
%   Return the vector of unknowns, which contains the solution after
%   gf_mdbrick_get(b,'solve').
% 
%   * gf_mdstate_get(mds,'residual')
%   Return the residual.
% 
%   * gf_mdstate_get(mds,'reduced_residual')
%   Return the residual on the reduced system.
% 
%   * gf_mdstate_get(mds,'unreduce', vec U)
%   Reinsert the constraint eliminated from the system.
% 
%   * gf_mdstate_get(mds,'memsize')
%   Return the amount of memory (in bytes) used by the model state.
% 
% 
%   $Id: gf_mdstate_get.cc,v 1.3 2006/03/28 10:06:35 pommier Exp $
function [varargout]=gf_mdstate_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate_get',varargin{:});
  else
    gf_matlab('mdstate_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
