% FUNCTION [...] = gf_levelset([operation [, args]])
%
%   General constructor for levelset objects.
%
%   
%   The level-set object is represented by a primary level-set and optionally
%   a secondary level-set used to represent fractures (if p(x) is the primary
%   level-set function and s(x) is the secondary level-set, the crack is
%   defined by p(x)=0 and s(x)<=0: the role of the secondary is to determine
%   the crack front/tip).
%   
%   .. note::
%   
%   All tools listed below need the package qhull installed on your
%   system. This package is widely available. It computes convex hull and
%   delaunay triangulations in arbitrary dimension.
%   
%   
%
%   * LS = gf_levelset(mesh m, int d[, string 'ws'| string f1[, string f2 | string 'ws']])
%   Create a levelset object on a mesh represented by a primary function
%   (and optional secondary function, both) defined on a lagrange mesh_fem of
%   degree `d`.
%   
%   If `ws` (with secondary) is set; this levelset is represented by a
%   primary function and a secondary function. If `f1` is set; the primary
%   function is defined by that expression. If `f2` is set; this levelset
%   is represented by a primary function and a secondary function defined
%   by these expressions.
%
%
function [varargout]=gf_levelset(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('levelset', varargin{:});
  else
    gf_matlab('levelset', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
